/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.adminservices.configuration.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.GovernanceServerEndpoint;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIAdminServicesConfigHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UIServerConfig
extends UIAdminServicesConfigHeader {
    public static final String VERSION_ONE = "V1.0";
    private static final String defaultOrganizationName = null;
    private static final String defaultLocalServerUserId = "UIServer";
    private static final int defaultMaxPageSize = 1000;
    private static final String defaultLocalServerType = "User Interface for the Open Metadata and Governance Server";
    private String versionId = null;
    private String localServerId = UUID.randomUUID().toString();
    private String localServerName = null;
    private String localServerUserId = "UIServer";
    private String localServerPassword = null;
    private String localServerType = "User Interface for the Open Metadata and Governance Server";
    private String localServerURL = null;
    private int maxPageSize = 1000;
    private String organizationName = defaultOrganizationName;
    private Connection serverSecurityConnection = null;
    private String metadataServerName;
    private String metadataServerURL;
    private List<GovernanceServerEndpoint> governanceServerEndpoints = null;
    private List<String> auditTrail = null;

    public UIServerConfig() {
    }

    public UIServerConfig(UIServerConfig template) {
        super(template);
        if (template != null) {
            this.versionId = template.getVersionId();
            this.localServerId = template.getLocalServerId();
            this.localServerName = template.getLocalServerName();
            this.localServerURL = template.getLocalServerURL();
            this.localServerUserId = template.getLocalServerUserId();
            this.localServerPassword = template.getLocalServerPassword();
            this.localServerType = template.getLocalServerType();
            this.organizationName = template.getOrganizationName();
            this.maxPageSize = template.getMaxPageSize();
            this.serverSecurityConnection = template.getServerSecurityConnection();
            this.metadataServerName = template.getMetadataServerName();
            this.metadataServerURL = template.getMetadataServerURL();
            this.governanceServerEndpoints = template.getGovernanceServerEndpoints();
            this.auditTrail = template.getAuditTrail();
        }
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getLocalServerId() {
        return this.localServerId;
    }

    public void setLocalServerId(String uiServerId) {
        this.localServerId = uiServerId;
    }

    public String getLocalServerName() {
        return this.localServerName;
    }

    public void setLocalServerName(String uiServerName) {
        this.localServerName = uiServerName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getLocalServerURL() {
        return this.localServerURL;
    }

    public void setLocalServerURL(String uiServerURL) {
        this.localServerURL = uiServerURL;
    }

    public String getLocalServerUserId() {
        return this.localServerUserId;
    }

    public void setLocalServerUserId(String uiServerUserId) {
        this.localServerUserId = uiServerUserId;
    }

    public String getLocalServerPassword() {
        return this.localServerPassword;
    }

    public void setLocalServerPassword(String uiServerPassword) {
        this.localServerPassword = uiServerPassword;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public Connection getServerSecurityConnection() {
        return this.serverSecurityConnection;
    }

    public void setServerSecurityConnection(Connection serverSecurityConnection) {
        this.serverSecurityConnection = serverSecurityConnection;
    }

    public String getMetadataServerName() {
        return this.metadataServerName;
    }

    public void setMetadataServerName(String metadataServerName) {
        this.metadataServerName = metadataServerName;
    }

    public String getMetadataServerURL() {
        return this.metadataServerURL;
    }

    public void setMetadataServerURL(String metadataServerURL) {
        this.metadataServerURL = metadataServerURL;
    }

    public List<GovernanceServerEndpoint> getGovernanceServerEndpoints() {
        return this.governanceServerEndpoints;
    }

    public void setGovernanceServerEndpoints(List<GovernanceServerEndpoint> governanceServerEndpoints) {
        this.governanceServerEndpoints = governanceServerEndpoints;
    }

    public String getLocalServerType() {
        return this.localServerType;
    }

    public void setLocalServerType(String localServerType) {
        this.localServerType = localServerType;
    }

    public List<String> getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(List<String> auditTrail) {
        this.auditTrail = auditTrail;
    }

    public String toString() {
        return "org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIServerConfig{localServerId='" + this.localServerId + '\'' + ", localServerName='" + this.localServerName + '\'' + ", organizationName='" + this.organizationName + '\'' + ", localServerURL='" + this.localServerURL + '\'' + ", localServerUserId='" + this.localServerUserId + '\'' + ", localServerPassword='" + this.localServerPassword + '\'' + ", localServerType='" + this.localServerType + '\'' + ", maxPageSize=" + this.maxPageSize + ", metadataServerName=" + this.metadataServerName + ", metadataServerURL=" + this.metadataServerURL + ", governanceServerEndpoints=" + this.governanceServerEndpoints + ", auditTrail=" + this.auditTrail + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        UIServerConfig that = (UIServerConfig)objectToCompare;
        return this.getMaxPageSize() == that.getMaxPageSize() && Objects.equals(this.getLocalServerId(), that.getLocalServerId()) && Objects.equals(this.getLocalServerName(), that.getLocalServerName()) && Objects.equals(this.getOrganizationName(), that.getOrganizationName()) && Objects.equals(this.getLocalServerURL(), that.getLocalServerURL()) && Objects.equals(this.getLocalServerUserId(), that.getLocalServerUserId()) && Objects.equals(this.getLocalServerPassword(), that.getLocalServerPassword()) && Objects.equals(this.getLocalServerType(), that.getLocalServerType()) && Objects.equals(this.getMetadataServerName(), that.getMetadataServerName()) && Objects.equals(this.getMetadataServerURL(), that.getMetadataServerURL()) && Objects.equals(this.getGovernanceServerEndpoints(), that.getGovernanceServerEndpoints()) && Objects.equals(this.getAuditTrail(), that.getAuditTrail());
    }

    public int hashCode() {
        return Objects.hash(this.getLocalServerId(), this.getLocalServerName(), this.getOrganizationName(), this.getLocalServerUserId(), this.getMaxPageSize(), this.getMetadataServerName(), this.getMetadataServerURL(), this.getGovernanceServerEndpoints());
    }
}

