/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices;

import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIServerConfig;
import org.odpi.openmetadata.userinterfaces.adminservices.UIAdminServicesRESTClient;

public class ConfigurationManagementClient {
    private String serverName;
    private String serverPlatformRootURL;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private UIAdminServicesRESTClient restClient;

    public ConfigurationManagementClient(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        String methodName = "Client Constructor";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor");
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new UIAdminServicesRESTClient(serverName, serverPlatformRootURL);
        }
        catch (InvalidParameterException error) {
            throw new InvalidParameterException(error);
        }
    }

    public ConfigurationManagementClient(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformRootURL, serverName, "Client Constructor (with security)");
            this.serverName = serverName;
            this.serverPlatformRootURL = serverPlatformRootURL;
            this.restClient = new UIAdminServicesRESTClient(serverName, serverPlatformRootURL, userId, password);
        }
        catch (InvalidParameterException error) {
            throw new InvalidParameterException(error);
        }
    }

    public void setUIServerConfig(String userId, UIServerConfig uiServerConfig) throws OMAGNotAuthorizedException, OMAGConfigurationErrorException, InvalidParameterException {
        String methodName = "deployUIServerConfig";
        String urlTemplate = "/open-metadata/admin-services/users/{0}/servers/{1}/configuration";
        try {
            VoidResponse restResult = this.restClient.callVoidPostRESTCall("deployUIServerConfig", this.serverPlatformRootURL + "/open-metadata/admin-services/users/{0}/servers/{1}/configuration", uiServerConfig, new Object[]{userId, this.serverName});
            this.exceptionHandler.detectAndThrowInvalidParameterException("deployUIServerConfig", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deployUIServerConfig", (FFDCResponseBase)restResult);
            this.exceptionHandler.detectAndThrowPropertyServerException("deployUIServerConfig", (FFDCResponseBase)restResult);
        }
        catch (InvalidParameterException error) {
            throw new InvalidParameterException(error);
        }
        catch (UserNotAuthorizedException error) {
            throw new OMAGNotAuthorizedException(error);
        }
        catch (PropertyServerException error) {
            throw new OMAGConfigurationErrorException(error);
        }
    }
}

