/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.GovernanceServerEndpoint;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIServerConfig;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.UIAdminErrorCode;

class UIServerErrorHandler {
    private static final String allGovernanceServices = UIServerErrorHandler.getAllValidGovernanceServerURLMarkers();

    private static String getAllValidGovernanceServerURLMarkers() {
        String allServerNamesStr = "";
        Set allGovernanceServerURLMarkers = GovernanceServicesDescription.getGovernanceServersURLMarkers();
        for (String urlMarker : allGovernanceServerURLMarkers) {
            allServerNamesStr = allServerNamesStr + " " + urlMarker;
        }
        return allServerNamesStr;
    }

    void validateUserId(String userId, String serverName, String methodName) throws OMAGNotAuthorizedException {
        if (userId == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_USER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateServerName(String serverName, String methodName) throws InvalidParameterException {
        if (serverName == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "serverName");
        }
    }

    void validateConfigServerName(String serverName, String configServerName, String methodName) throws OMAGConfigurationErrorException {
        if (!serverName.equals(configServerName)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.INCOMPATIBLE_SERVER_NAMES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, configServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateConnection(Connection connection, String serverName, String methodName) throws InvalidParameterException {
        if (connection == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "Connection");
        }
    }

    void validateConnection(Connection connection, String methodName) throws InvalidParameterException {
        if (connection == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_PLATFORM_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "connection");
        }
    }

    public void validateMetadataServerName(String serverName, String methodName, String metadataServerName) throws InvalidParameterException {
        if (metadataServerName == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_METADATA_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "metadataServerName");
        }
    }

    public void validateMetadataServerURL(String serverName, String methodName, String metadataServerURL) throws InvalidParameterException {
        if (metadataServerURL == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_METADATA_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "metadataServerURL");
        }
        if (!this.isURLValid(metadataServerURL)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.INVALID_METADATA_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, metadataServerURL});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "metadataServerURL");
        }
    }

    public void validateUIconfiguration(String serverName, UIServerConfig uiServerConfig, String methodName) throws InvalidParameterException {
        this.validateMetadataServerName(serverName, methodName, uiServerConfig.getMetadataServerName());
        this.validateMetadataServerURL(serverName, methodName, uiServerConfig.getMetadataServerURL());
        List governanceServerEndpoints = uiServerConfig.getGovernanceServerEndpoints();
        HashSet<String> governanceServernames = new HashSet<String>();
        for (GovernanceServerEndpoint governanceServerEndpoint : governanceServerEndpoints) {
            String governanceServiceName = governanceServerEndpoint.getGovernanceServiceName();
            this.validateGovernanceServiceName(governanceServiceName, serverName, methodName);
            this.validateGovernanceServerURL(governanceServerEndpoint.getServerRootURL(), serverName, methodName);
            this.validateGovernanceServerName(governanceServerEndpoint.getServerName(), serverName, methodName);
            if (governanceServernames.contains(governanceServiceName)) {
                UIAdminErrorCode errorCode = UIAdminErrorCode.DUPLICATE_GOVERNANCE_SERVERS;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, governanceServiceName});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "governanceServiceName");
            }
            governanceServernames.add(governanceServiceName);
        }
    }

    public void validateGovernanceServerName(String governanceServiceName, String serverName, String methodName) throws InvalidParameterException {
        if (governanceServiceName == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_GOVERNANCE_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "governanceServiceName");
        }
    }

    public void validateGovernanceServerURL(String governanceServiceURL, String serverName, String methodName) throws InvalidParameterException {
        if (governanceServiceURL == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_GOVERNANCE_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "governanceServiceURL");
        }
        if (!this.isURLValid(governanceServiceURL)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.INVALID_GOVERNANCE_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, governanceServiceURL});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "governanceServiceURL");
        }
    }

    public void validateGovernanceServiceName(String governanceServiceName, String serverName, String methodName) throws InvalidParameterException {
        if (governanceServiceName == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_GOVERNANCE_SERVICE_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "governanceServiceName");
        }
        if (!this.isGovernanceServiceNameValid(governanceServiceName)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.INVALID_GOVERNANCE_SERVICE_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, governanceServiceName, allGovernanceServices});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "governanceServiceName");
        }
    }

    private boolean isURLValid(String candidateURL) {
        boolean isValid = false;
        try {
            new URL(candidateURL);
            isValid = true;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isValid;
    }

    private boolean isGovernanceServiceNameValid(String candidateGovernanceServerName) {
        boolean isValid = false;
        Set servicesURLMarkers = GovernanceServicesDescription.getGovernanceServersURLMarkers();
        if (servicesURLMarkers.contains(candidateGovernanceServerName)) {
            isValid = true;
        }
        return isValid;
    }
}

