/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.UIAdminErrorCode;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.exception.UIConfigurationErrorException;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.exception.UIInvalidParameterException;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.exception.UINotAuthorizedException;

class UIServerExceptionHandler
extends RESTExceptionHandler {
    void captureRuntimeException(String serverName, String methodName, FFDCResponseBase response, Throwable runtimeException) {
        UIAdminErrorCode errorCode = UIAdminErrorCode.UNEXPECTED_EXCEPTION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, runtimeException.getClass().getName(), runtimeException.getMessage()});
        UIConfigurationErrorException error = new UIConfigurationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), runtimeException);
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    void captureRuntimeException(String methodName, FFDCResponseBase response, Throwable runtimeException) {
        UIAdminErrorCode errorCode = UIAdminErrorCode.UNEXPECTED_PLATFORM_EXCEPTION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, runtimeException.getClass().getName(), runtimeException.getMessage()});
        UIConfigurationErrorException error = new UIConfigurationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), runtimeException);
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    void captureConfigurationErrorException(FFDCResponseBase response, UIConfigurationErrorException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    void captureInvalidParameterException(FFDCResponseBase response, UIInvalidParameterException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    void captureNotAuthorizedException(FFDCResponseBase response, UINotAuthorizedException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }

    void captureNotAuthorizedException(FFDCResponseBase response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (OCFCheckedExceptionBase)error, error.getClass().getName());
    }
}

