/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIServerConfig;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.UIAdminErrorCode;
import org.odpi.openmetadata.userinterface.adminservices.rest.UIServerConfigResponse;
import org.odpi.openmetadata.userinterfaces.adminservices.UIServerAdminStoreServices;
import org.odpi.openmetadata.userinterfaces.adminservices.UIServerErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIServerAdminServices {
    private static final Logger log = LoggerFactory.getLogger(UIServerAdminServices.class);
    private UIServerAdminStoreServices configStore = new UIServerAdminStoreServices();
    private UIServerErrorHandler errorHandler = new UIServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public VoidResponse setOrganizationName(String userId, String serverName, String name) {
        String methodName = "setOrganizationName";
        log.debug("Calling method: setOrganizationName");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setOrganizationName");
            this.errorHandler.validateUserId(userId, serverName, "setOrganizationName");
            UIServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setOrganizationName");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(name)) {
                name = null;
            }
            if (name == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server's owning organization's name.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server's owning organization's name to " + name + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setOrganizationName(name);
            this.configStore.saveServerConfig(serverName, "setOrganizationName", serverConfig);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setOrganizationName", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setOrganizationName with response: " + response.toString());
        return response;
    }

    public VoidResponse setServerUserId(String userId, String serverName, String serverUserId) {
        String methodName = "setLocalServerUserId";
        log.debug("Calling method: setLocalServerUserId");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setLocalServerUserId");
            this.errorHandler.validateServerName(serverName, "setLocalServerUserId");
            UIServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalServerUserId");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(serverUserId)) {
                serverUserId = null;
            }
            if (serverUserId == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server's userId.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server's userId to " + serverUserId + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerUserId(serverUserId);
            this.configStore.saveServerConfig(serverName, "setLocalServerUserId", serverConfig);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setLocalServerUserId", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setLocalServerUserId with response: " + response.toString());
        return response;
    }

    public VoidResponse setServerPassword(String userId, String serverName, String serverPassword) {
        String methodName = "setLocalServerPassword";
        log.debug("Calling method: setLocalServerPassword");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "setLocalServerPassword");
            this.errorHandler.validateServerName(serverName, "setLocalServerPassword");
            UIServerConfig serverConfig = this.configStore.getServerConfig(userId, serverName, "setLocalServerPassword");
            ArrayList<String> configAuditTrail = serverConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            if ("".equals(serverPassword)) {
                serverPassword = null;
            }
            if (serverPassword == null) {
                configAuditTrail.add(new Date().toString() + " " + userId + " removed configuration for local server's password.");
            } else {
                configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for local server's password to " + serverPassword + ".");
            }
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setLocalServerPassword(serverPassword);
            this.configStore.saveServerConfig(serverName, "setLocalServerPassword", serverConfig);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setLocalServerPassword", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setLocalServerPassword with response: " + response.toString());
        return response;
    }

    public VoidResponse setMaxPageSize(String userId, String serverName, int maxPageSize) {
        String methodName = "setMaxPageSize";
        log.debug("Calling method: setMaxPageSize");
        VoidResponse response = new VoidResponse();
        try {
            ArrayList<String> configAuditTrail;
            UIServerConfig serverConfig;
            this.errorHandler.validateServerName(serverName, "setMaxPageSize");
            this.errorHandler.validateUserId(userId, serverName, "setMaxPageSize");
            if (maxPageSize > 0) {
                serverConfig = this.configStore.getServerConfig(userId, serverName, "setMaxPageSize");
                configAuditTrail = serverConfig.getAuditTrail();
                if (configAuditTrail == null) {
                    configAuditTrail = new ArrayList<String>();
                }
            } else {
                UIAdminErrorCode errorCode = UIAdminErrorCode.BAD_MAX_PAGE_SIZE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, Integer.toString(maxPageSize)});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setMaxPageSize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " updated configuration for maximum page size to " + maxPageSize + ".");
            serverConfig.setAuditTrail(configAuditTrail);
            serverConfig.setMaxPageSize(maxPageSize);
            this.configStore.saveServerConfig(serverName, "setMaxPageSize", serverConfig);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setMaxPageSize", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setMaxPageSize with response: " + response.toString());
        return response;
    }

    public VoidResponse setUIServerConfig(String userId, String serverName, UIServerConfig uiServerConfig) {
        String methodName = "setUIServerConfig";
        log.debug("Calling method: setUIServerConfig");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "setUIServerConfig");
            this.errorHandler.validateConfigServerName(serverName, uiServerConfig.getLocalServerName(), "setUIServerConfig");
            this.errorHandler.validateUserId(userId, serverName, "setUIServerConfig");
            if (uiServerConfig == null) {
                UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_SERVER_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGInvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setUIServerConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.errorHandler.validateUIconfiguration(serverName, uiServerConfig, "setUIServerConfig");
            ArrayList<String> configAuditTrail = uiServerConfig.getAuditTrail();
            if (configAuditTrail == null) {
                configAuditTrail = new ArrayList<String>();
            }
            configAuditTrail.add(new Date().toString() + " " + userId + " deployed configuration for server.");
            uiServerConfig.setAuditTrail(configAuditTrail);
            this.configStore.saveServerConfig(serverName, "setUIServerConfig", uiServerConfig);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "setUIServerConfig", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: setUIServerConfig with response: " + response.toString());
        return response;
    }

    public UIServerConfigResponse getStoredConfiguration(String userId, String serverName) {
        String methodName = "getStoredConfiguration";
        log.debug("Calling method: getStoredConfiguration");
        UIServerConfigResponse response = new UIServerConfigResponse();
        try {
            this.errorHandler.validateServerName(serverName, "getStoredConfiguration");
            this.errorHandler.validateUserId(userId, serverName, "getStoredConfiguration");
            response.setUIServerConfig(this.configStore.getServerConfig(userId, serverName, "getStoredConfiguration"));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "getStoredConfiguration", (FFDCResponseBase)response, error);
        }
        log.debug("Returning from method: getStoredConfiguration with response: " + response.toString());
        return response;
    }
}

