/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.OMAGServerExceptionHandler;
import org.odpi.openmetadata.adminservices.OMAGServerOperationalInstanceHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogDestination;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIServerConfig;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.UIAdminErrorCode;
import org.odpi.openmetadata.userinterface.adminservices.rest.UIServerConfigResponse;
import org.odpi.openmetadata.userinterfaces.adminservices.UIOperationalServicesInstance;
import org.odpi.openmetadata.userinterfaces.adminservices.UIServerAdminStoreServices;
import org.odpi.openmetadata.userinterfaces.adminservices.UIServerErrorHandler;
import org.odpi.openmetadata.userinterfaces.adminservices.ViewServiceAdmin;

public class UIServerOperationalServices {
    private OMAGServerOperationalInstanceHandler instanceHandler = new OMAGServerOperationalInstanceHandler(CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName());
    private OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    private UIServerAdminStoreServices configStore = new UIServerAdminStoreServices();
    private UIServerErrorHandler errorHandler = new UIServerErrorHandler();
    private OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();

    public SuccessMessageResponse activateWithStoredConfig(String userId, String serverName) {
        String methodName = "activateWithStoredConfig";
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithStoredConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithStoredConfig");
            response = this.activateWithSuppliedConfig(userId, serverName, this.configStore.getServerConfig(userId, serverName, "activateWithStoredConfig"));
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "activateWithStoredConfig", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public SuccessMessageResponse activateWithSuppliedConfig(String userId, String serverName, UIServerConfig configuration) {
        String methodName = "activateWithSuppliedConfig";
        ArrayList<String> activatedServiceList = new ArrayList<String>();
        SuccessMessageResponse response = new SuccessMessageResponse();
        try {
            this.errorHandler.validateServerName(serverName, "activateWithSuppliedConfig");
            this.errorHandler.validateUserId(userId, serverName, "activateWithSuppliedConfig");
            if (configuration == null) {
                UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_SERVER_CONFIG;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "UIServerConfig");
            }
            int maxPageSize = configuration.getMaxPageSize();
            List viewServiceConfigList = configuration.getViewServiceConfigs();
            if (viewServiceConfigList == null || viewServiceConfigList.isEmpty()) {
                UIAdminErrorCode errorCode = UIAdminErrorCode.EMPTY_CONFIGURATION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
                throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.errorHandler.validateConfigServerName(serverName, configuration.getLocalServerName(), "activateWithSuppliedConfig");
            this.errorHandler.validateMetadataServerName(serverName, "activateWithSuppliedConfig", configuration.getMetadataServerName());
            this.errorHandler.validateMetadataServerURL(serverName, "activateWithSuppliedConfig", configuration.getMetadataServerURL());
            if (this.instanceHandler.isServerActive(userId, serverName)) {
                this.deactivateTemporarily(userId, serverName);
            }
            UIOperationalServicesInstance operationalServicesInstance = new UIOperationalServicesInstance(serverName, CommonServicesDescription.ADMIN_OPERATIONAL_SERVICES.getServiceName(), maxPageSize);
            operationalServicesInstance.setOperationalConfiguration(configuration);
            OMRSAuditLogDestination auditLogDestination = new OMRSAuditLogDestination(configuration.getLocalServerName(), configuration.getLocalServerType(), configuration.getOrganizationName(), this.getAuditLogStores(configuration.getAuditLogConnections(), configuration.getLocalServerName()));
            OMRSAuditLog auditLog = new OMRSAuditLog(auditLogDestination, OMRSAuditingComponent.OPERATIONAL_SERVICES);
            List<ViewServiceAdmin> operationalViewServiceAdminList = operationalServicesInstance.getOperationalViewServiceAdminList();
            if (viewServiceConfigList != null) {
                ArrayList<ViewServiceConfig> updatedViewServiceConfigList = new ArrayList<ViewServiceConfig>();
                for (ViewServiceConfig viewServiceConfig : viewServiceConfigList) {
                    if (viewServiceConfig != null) {
                        String viewServiceAdminClassName = viewServiceConfig.getViewServiceAdminClass();
                        if (viewServiceAdminClassName == null) continue;
                        ViewServiceAdmin viewServiceAdmin = null;
                        try {
                            viewServiceAdmin = (ViewServiceAdmin)Class.forName(viewServiceAdminClassName).newInstance();
                        }
                        catch (InstantiationException exception) {
                            this.throwBadViewAdminClassException(serverName, viewServiceAdminClassName, "activateWithSuppliedConfig", viewServiceConfig);
                        }
                        catch (IllegalAccessException exception) {
                            this.throwBadViewAdminClassException(serverName, viewServiceAdminClassName, "activateWithSuppliedConfig", viewServiceConfig);
                        }
                        ViewServiceConfig updatedViewServiceConfig = viewServiceAdmin.initialize(viewServiceConfig, auditLog, configuration.getLocalServerUserId(), maxPageSize, serverName, configuration.getMetadataServerName(), configuration.getMetadataServerURL());
                        updatedViewServiceConfigList.add(updatedViewServiceConfig);
                        operationalViewServiceAdminList.add(viewServiceAdmin);
                        activatedServiceList.add(updatedViewServiceConfig.getViewServiceName() + " OMVS");
                        configuration.setViewServiceConfigs(updatedViewServiceConfigList);
                        continue;
                    }
                    OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.NULL_VIEW_SERVICE_ADMIN_CLASS;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, viewServiceConfig.getViewServiceName()});
                    throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "activateWithSuppliedConfig", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
            }
            this.configStore.saveServerConfig(serverName, "activateWithSuppliedConfig", configuration);
            operationalServicesInstance.setOperationalViewServiceAdminList(operationalViewServiceAdminList);
            response.setSuccessMessage(new Date().toString() + " " + serverName + " is running the following services: " + ((Object)activatedServiceList).toString());
        }
        catch (OMAGConfigurationErrorException error) {
            this.exceptionHandler.captureConfigurationErrorException((FFDCResponseBase)response, error);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "activateWithSuppliedConfig", (FFDCResponseBase)response, error);
        }
        return response;
    }

    void throwBadViewAdminClassException(String serverName, String viewServiceAdminClassName, String methodName, ViewServiceConfig viewServiceConfig) throws OMAGConfigurationErrorException {
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_VIEW_SERVICE_ADMIN_CLASS;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, viewServiceAdminClassName, viewServiceConfig.getViewServiceName()});
        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private List<OMRSAuditLogStore> getAuditLogStores(List<Connection> auditLogStoreConnections, String serverName) {
        ArrayList<OMRSAuditLogStore> auditLogStores = new ArrayList<OMRSAuditLogStore>();
        for (Connection auditLogStoreConnection : auditLogStoreConnections) {
            auditLogStores.add(this.getAuditLogStore(auditLogStoreConnection, serverName));
        }
        if (auditLogStores.isEmpty()) {
            return null;
        }
        return auditLogStores;
    }

    private OMRSAuditLogStore getAuditLogStore(Connection auditLogStoreConnection, String serverName) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(auditLogStoreConnection);
            return (OMRSAuditLogStore)connector;
        }
        catch (Throwable error) {
            String methodName = "getAuditLogStore";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_AUDIT_LOG_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private void deactivateRunningServiceInstances(String userId, String serverName, String methodName, UIOperationalServicesInstance instance, boolean permanentDeactivation) throws InvalidParameterException, PropertyServerException {
        this.instanceHandler.removeServerServiceInstance(serverName);
        this.platformInstanceMap.shutdownServerInstance(userId, serverName, methodName);
    }

    public VoidResponse deactivateTemporarily(String userId, String serverName) {
        String methodName = "deactivateTemporarily";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deactivateTemporarily");
            this.errorHandler.validateUserId(userId, serverName, "deactivateTemporarily");
            this.deactivateRunningServiceInstances(userId, serverName, "deactivateTemporarily", (UIOperationalServicesInstance)this.instanceHandler.getServerServiceInstance(userId, serverName, "deactivateTemporarily"), false);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "deactivateTemporarily", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public VoidResponse deactivatePermanently(String userId, String serverName) {
        String methodName = "deactivatePermanently";
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateServerName(serverName, "deactivatePermanently");
            this.errorHandler.validateUserId(userId, serverName, "deactivatePermanently");
            this.deactivateRunningServiceInstances(userId, serverName, "deactivatePermanently", (UIOperationalServicesInstance)this.instanceHandler.getServerServiceInstance(userId, serverName, "deactivatePermanently"), true);
            this.configStore.saveServerConfig(serverName, "deactivatePermanently", null);
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "deactivatePermanently", (FFDCResponseBase)response, error);
        }
        return response;
    }

    public UIServerConfigResponse getActiveConfiguration(String userId, String serverName) {
        String methodName = "getActiveConfiguration";
        UIServerConfigResponse response = new UIServerConfigResponse();
        try {
            this.errorHandler.validateUserId(userId, serverName, "getActiveConfiguration");
            UIOperationalServicesInstance instance = (UIOperationalServicesInstance)this.instanceHandler.getServerServiceInstance(userId, serverName, "getActiveConfiguration");
            response.setUIServerConfig(instance.getOperationalConfiguration());
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeException(serverName, "getActiveConfiguration", (FFDCResponseBase)response, error);
        }
        return response;
    }
}

