/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIServerConfig;
import org.odpi.openmetadata.userinterface.adminservices.ffdc.UIAdminErrorCode;

public class UIServerErrorHandler {
    private static final String allGovernanceServices = UIServerErrorHandler.getAllValidGovernanceServerURLMarkers();

    private static String getAllValidGovernanceServerURLMarkers() {
        String allServerNamesStr = "";
        Set allGovernanceServerURLMarkers = GovernanceServicesDescription.getGovernanceServersURLMarkers();
        for (String urlMarker : allGovernanceServerURLMarkers) {
            allServerNamesStr = allServerNamesStr + " " + urlMarker;
        }
        return allServerNamesStr;
    }

    public void validateUserId(String userId, String serverName, String methodName) throws OMAGNotAuthorizedException {
        if (userId == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_USER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName});
            throw new OMAGNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateServerName(String serverName, String methodName) throws InvalidParameterException {
        if (serverName == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_LOCAL_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "serverName");
        }
    }

    public void validateConfigServerName(String serverName, String configServerName, String methodName) throws OMAGConfigurationErrorException {
        if (!serverName.equals(configServerName)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.INCOMPATIBLE_SERVER_NAMES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, configServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateConfigMetadataServerName(String metadataServerName, String configServerName, String methodName) throws OMAGConfigurationErrorException {
        if (!metadataServerName.equals(configServerName)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_METADATA_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{metadataServerName, configServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateConfigMetadataServeURL(String metadataServerURL, String configServerName, String methodName) throws OMAGConfigurationErrorException {
        if (!metadataServerURL.equals(configServerName)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_METADATA_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{metadataServerURL, configServerName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateConnection(Connection connection, String serverName, String methodName) throws InvalidParameterException {
        if (connection == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "Connection");
        }
    }

    public void validateConnection(Connection connection, String methodName) throws InvalidParameterException {
        if (connection == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_PLATFORM_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "connection");
        }
    }

    public void validateMetadataServerName(String serverName, String methodName, String metadataServerName) throws InvalidParameterException {
        if (metadataServerName == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_METADATA_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "metadataServerName");
        }
    }

    public void validateMetadataServerURL(String serverName, String methodName, String metadataServerURL) throws InvalidParameterException {
        if (metadataServerURL == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_METADATA_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "metadataServerURL");
        }
        if (!this.isURLValid(metadataServerURL)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.INVALID_METADATA_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, metadataServerURL});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "metadataServerURL");
        }
    }

    public void validateLineageServerName(String serverName, String methodName, String openLineageServerName) throws OMAGConfigurationErrorException {
        if (openLineageServerName == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_OPEN_LINEAGE_SERVER_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateLineageServerURL(String serverName, String methodName, String openLineageServerURL) throws OMAGConfigurationErrorException {
        if (openLineageServerURL == null) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.NULL_OPEN_LINEAGE_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.isURLValid(openLineageServerURL)) {
            UIAdminErrorCode errorCode = UIAdminErrorCode.INVALID_OPEN_LINEAGE_SERVER_URL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, methodName, openLineageServerURL});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateUIconfiguration(String serverName, UIServerConfig uiServerConfig, String methodName) throws InvalidParameterException {
        this.validateMetadataServerName(serverName, methodName, uiServerConfig.getMetadataServerName());
        this.validateMetadataServerURL(serverName, methodName, uiServerConfig.getMetadataServerURL());
    }

    private boolean isURLValid(String candidateURL) {
        boolean isValid = false;
        try {
            new URL(candidateURL);
            isValid = true;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isValid;
    }
}

