/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices;

import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.auditlog.OMAGAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.ViewServiceConfig;

public abstract class ViewServiceAdmin {
    protected OMRSAuditLog auditLog = null;
    protected String serverName = null;

    public ViewServiceConfig initialize(ViewServiceConfig viewServiceConfigurationProperties, OMRSAuditLog auditLog, String serverUserName, int maxPageSize, String serverName, String metadataServerName, String metadataServerURL) {
        ViewServiceConfig updatedViewServiceConfig = null;
        this.auditLog = auditLog;
        this.serverName = serverName;
        try {
            if (viewServiceConfigurationProperties == null || viewServiceConfigurationProperties.getViewServiceName() == null) {
                this.auditServiceInitializing();
            } else {
                this.auditServiceInitializing(viewServiceConfigurationProperties.getViewServiceName());
            }
            updatedViewServiceConfig = this.validateAndExpandViewServicesConfigurationProperties(viewServiceConfigurationProperties);
            this.createViewServicesInstance(viewServiceConfigurationProperties, auditLog, serverUserName, maxPageSize, metadataServerName, metadataServerURL, viewServiceConfigurationProperties.getViewServiceOptions());
            this.auditServiceInitialized(updatedViewServiceConfig.getViewServiceName());
        }
        catch (Exception error) {
            this.auditServiceInitializingError(error);
        }
        return updatedViewServiceConfig;
    }

    protected abstract ViewServiceConfig validateAndExpandViewServicesConfigurationProperties(ViewServiceConfig var1) throws OMAGConfigurationErrorException;

    protected abstract void auditServiceInitializing(String var1);

    protected abstract void auditServiceInitializing();

    protected abstract void auditServiceInitialized(String var1);

    protected abstract void auditServiceInitializingError(Exception var1);

    protected abstract void createViewServicesInstance(ViewServiceConfig var1, OMRSAuditLog var2, String var3, int var4, String var5, String var6, Map<String, Object> var7) throws OMAGConfigurationErrorException;

    public abstract void shutdown();

    protected void logBadConfigProperties(String viewServiceName, String propertyName, String propertyValue, OMRSAuditLog auditLog, String methodName) throws OMAGConfigurationErrorException {
        OMAGAuditCode auditCode = OMAGAuditCode.BAD_CONFIG_PROPERTY;
        auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{viewServiceName, propertyValue, propertyName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        OMAGAdminErrorCode errorCode = OMAGAdminErrorCode.BAD_CONFIG_PROPERTIES;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{viewServiceName, propertyValue, propertyName});
        throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    protected String extractPropertyFromViewServiceOptions(Map<String, Object> viewServiceOptions, String viewServiceName, String propertyName, OMRSAuditLog auditLog) throws OMAGConfigurationErrorException {
        String methodName = "extractMetadataServerName";
        String property = null;
        if (viewServiceOptions == null) {
            this.logBadConfigProperties(viewServiceName, "viewServiceOptions", null, auditLog, "extractMetadataServerName");
        } else {
            property = (String)viewServiceOptions.get(propertyName);
            if (property == null) {
                this.logBadConfigProperties(viewServiceName, propertyName, null, auditLog, "extractMetadataServerName");
            }
        }
        return property;
    }
}

