/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterfaces.adminservices.spring;

import org.odpi.openmetadata.adminservices.rest.SuccessMessageResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.UIServerConfig;
import org.odpi.openmetadata.userinterface.adminservices.rest.UIServerConfigResponse;
import org.odpi.openmetadata.userinterfaces.adminservices.UIServerOperationalServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/ui-admin-services/users/{userId}/servers/{serverName}"})
public class UIOperationalServicesResource {
    private UIServerOperationalServices operationalServices = new UIServerOperationalServices();

    @PostMapping(path={"/instance"})
    public SuccessMessageResponse activateWithStoredConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.activateWithStoredConfig(userId, serverName);
    }

    @PostMapping(path={"/instance/configuration"})
    public SuccessMessageResponse activateWithSuppliedConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody UIServerConfig configuration) {
        return this.operationalServices.activateWithSuppliedConfig(userId, serverName, configuration);
    }

    @DeleteMapping(path={"/instance"})
    public VoidResponse deactivateTemporarily(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.deactivateTemporarily(userId, serverName);
    }

    @DeleteMapping(path={""})
    public VoidResponse deactivatePermanently(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.deactivatePermanently(userId, serverName);
    }

    @GetMapping(path={"/instance/configuration"})
    public UIServerConfigResponse getActiveConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.operationalServices.getActiveConfiguration(userId, serverName);
    }
}

