/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.admin;

import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.userinterface.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auditlog.ViewServiceAuditCode;
import org.odpi.openmetadata.userinterfaces.adminservices.ViewServiceAdmin;

public abstract class AuditableViewServiceAdmin
extends ViewServiceAdmin {
    private final String actionDescription = "initialize";

    protected void auditServiceInitializing() {
        ViewServiceAuditCode auditCode = ViewServiceAuditCode.UNKNOWN_SERVICE_INITIALIZING;
        this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.serverName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.auditLog = this.auditLog;
    }

    protected void auditServiceInitializing(String serviceName) {
        ViewServiceAuditCode auditCode = ViewServiceAuditCode.SERVICE_INITIALIZING;
        this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.serverName, serviceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.auditLog = this.auditLog;
    }

    protected void auditServiceInitialized(String serviceName) {
        ViewServiceAuditCode auditCode = ViewServiceAuditCode.SERVICE_INITIALIZED;
        this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.serverName, serviceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    protected void auditServiceInitializingError(Exception error) {
        ViewServiceAuditCode auditCode = ViewServiceAuditCode.SERVICE_INSTANCE_FAILURE;
        this.auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    protected ViewServiceConfig validateAndExpandViewServicesConfigurationProperties(ViewServiceConfig viewServiceConfigurationProperties, ViewServiceDescription viewServiceDescription) throws OMAGConfigurationErrorException {
        String methodName = "validateAndExpandViewServicesConfigurationProperties";
        ViewServiceConfig updatedViewServiceConfig = new ViewServiceConfig();
        if (viewServiceConfigurationProperties.getViewServiceName() != null && !viewServiceConfigurationProperties.getViewServiceName().equals(viewServiceDescription.getViewServiceName())) {
            this.logBadConfigProperties(viewServiceDescription.getViewServiceName(), "viewServiceName", viewServiceConfigurationProperties.getViewServiceName(), this.auditLog, methodName);
        }
        updatedViewServiceConfig.setViewServiceName(viewServiceDescription.getViewServiceName());
        if (viewServiceConfigurationProperties.getViewServiceDescription() != null && !viewServiceConfigurationProperties.getViewServiceDescription().equals(viewServiceDescription.getViewServiceDescription())) {
            this.logBadConfigProperties(viewServiceDescription.getViewServiceName(), "viewServiceDescription", viewServiceConfigurationProperties.getViewServiceDescription(), this.auditLog, methodName);
        }
        updatedViewServiceConfig.setViewServiceDescription(viewServiceDescription.getViewServiceDescription());
        if (viewServiceConfigurationProperties.getViewServiceId() != viewServiceDescription.getViewServiceCode()) {
            this.logBadConfigProperties(viewServiceDescription.getViewServiceName(), "viewServiceId", viewServiceConfigurationProperties.getViewServiceId() + "", this.auditLog, methodName);
        }
        updatedViewServiceConfig.setViewServiceId(viewServiceDescription.getViewServiceCode());
        if (viewServiceConfigurationProperties.getViewServiceWiki() != null && !viewServiceConfigurationProperties.getViewServiceWiki().equals(viewServiceDescription.getViewServiceWiki())) {
            this.logBadConfigProperties(viewServiceDescription.getViewServiceName(), "viewServiceWiki", viewServiceConfigurationProperties.getViewServiceWiki(), this.auditLog, methodName);
        }
        updatedViewServiceConfig.setViewServiceAdminClass(viewServiceConfigurationProperties.getViewServiceAdminClass());
        viewServiceConfigurationProperties.setViewServiceWiki(viewServiceDescription.getViewServiceWiki());
        return updatedViewServiceConfig;
    }
}

