/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.admin;

import java.util.Map;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.userinterface.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.userinterface.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.userinterface.uichassis.springboot.admin.AuditableViewServiceAdmin;
import org.odpi.openmetadata.userinterface.uichassis.springboot.admin.serviceinstances.SubjectAreaViewServicesInstance;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auditlog.ViewServiceAuditCode;

public class SubjectAreaViewAdmin
extends AuditableViewServiceAdmin {
    private SubjectAreaViewServicesInstance instance = null;

    protected void createViewServicesInstance(ViewServiceConfig viewServiceConfigurationProperties, OMRSAuditLog auditLog, String serverUserName, int maxPageSize, String metadataServerName, String metadataServerURL, Map<String, Object> options) {
        this.instance = new SubjectAreaViewServicesInstance(this.serverName, auditLog, serverUserName, maxPageSize, metadataServerName, metadataServerURL);
        this.serverName = this.instance.getServerName();
    }

    protected ViewServiceConfig validateAndExpandViewServicesConfigurationProperties(ViewServiceConfig viewServiceConfigurationProperties) throws OMAGConfigurationErrorException {
        ViewServiceConfig updatedViewServiceConfig = this.validateAndExpandViewServicesConfigurationProperties(viewServiceConfigurationProperties, ViewServiceDescription.SUBJECT_AREA);
        return updatedViewServiceConfig;
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        if (this.auditLog != null) {
            String actionDescription = "shutdown";
            ViewServiceAuditCode auditCode = ViewServiceAuditCode.SERVICE_SHUTDOWN;
            this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.serverName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public OMRSAuditLog getAuditLog() {
        return this.auditLog;
    }
}

