/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import javax.servlet.Filter;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthFilter;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.LoginFilter;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.UserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@EnableWebSecurity
@Configuration
@Order(value=-2147483648)
class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private AuthService authService;
    @Value(value="${ldap.user.search.base}")
    private String userSearchBase;
    @Value(value="${ldap.user.search.filter}")
    private String userSearchFilter;
    @Value(value="${ldap.group.search.base}")
    private String groupSearchBase;
    @Value(value="${ldap.group.search.filter}")
    private String groupSearchFilter;
    @Value(value="${ldap.url}")
    private String url;
    @Value(value="${authentication.source}")
    private String authenticationSource;

    public SecurityConfig() {
        super(true);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.exceptionHandling().and()).anonymous().and()).authorizeRequests().antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/service-worker.js"})).permitAll().antMatchers(new String[]{"/manifest.json"})).permitAll().antMatchers(new String[]{"/favicon.ico"})).permitAll().antMatchers(new String[]{"/node_modules/**"})).permitAll().antMatchers(new String[]{"/src/**"})).permitAll().antMatchers(new String[]{"/h2/**"})).permitAll().antMatchers(new String[]{"/images/**"})).permitAll().antMatchers(new String[]{"/css/**"})).permitAll().antMatchers(new String[]{"/locales/**"})).permitAll().antMatchers(new String[]{"/properties/**"})).permitAll().antMatchers(new String[]{"/open-metadata/ui-admin-services/**"})).permitAll().antMatchers(new String[]{"/swagger-resources/**"})).permitAll().antMatchers(new String[]{"/swagger**"})).permitAll().antMatchers(new String[]{"/webjars/springfox-swagger-ui/**"})).permitAll().antMatchers(new String[]{"/v2/api-docs"})).permitAll().antMatchers(new String[]{"/csrf"})).permitAll().anyRequest()).authenticated().and()).addFilterBefore((Filter)new AuthFilter(this.authService), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new LoginFilter("/auth/login", this.authenticationManager(), this.authService), UsernamePasswordAuthenticationFilter.class);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public InetOrgPersonContextMapper userContextMapper() {
        return new InetOrgPersonContextMapper();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (this.authenticationSource.equals("ldap")) {
            auth.ldapAuthentication().userSearchBase(this.userSearchBase).userSearchFilter(this.userSearchFilter).groupSearchBase(this.groupSearchBase).groupSearchFilter(this.groupSearchFilter).rolePrefix("").userDetailsContextMapper((UserDetailsContextMapper)this.userContextMapper()).contextSource().url(this.url);
        } else {
            auth.userDetailsService((org.springframework.security.core.userdetails.UserDetailsService)this.userDetailsService).passwordEncoder((PasswordEncoder)new BCryptPasswordEncoder());
        }
    }

    protected UserDetailsService userDetailsService() {
        return this.userDetailsService;
    }
}

