/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OpenLineageService {
    public static final String EDGES_LABEL = "edges";
    public static final String NODES_LABEL = "nodes";
    public static final String GLOSSARY_TERM = "glossaryTerm";
    private final OpenLineageClient openLineageClient;
    private static final Logger LOG = LoggerFactory.getLogger(OpenLineageService.class);

    @Autowired
    public OpenLineageService(OpenLineageClient openLineageClient) {
        this.openLineageClient = openLineageClient;
    }

    public Map<String, List> getUltimateSource(String userId, String guid, boolean includeProcesses) {
        LineageVerticesAndEdges response = null;
        try {
            response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_SOURCE, guid, "", includeProcesses);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error(e.getErrorMessage(), e);
        }
        return this.processResponse(response);
    }

    public Map<String, List> getEndToEndLineage(String userId, String guid, boolean includeProcesses) {
        LineageVerticesAndEdges response = null;
        try {
            response = this.openLineageClient.lineage(userId, Scope.END_TO_END, guid, "", includeProcesses);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error(e.getErrorMessage(), e);
        }
        return this.processResponse(response);
    }

    public Map<String, List> getUltimateDestination(String userId, String guid, boolean includeProcesses) {
        LineageVerticesAndEdges response = null;
        try {
            response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_DESTINATION, guid, "", includeProcesses);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error(e.getErrorMessage(), e);
        }
        return this.processResponse(response);
    }

    public Map<String, List> getGlossaryLineage(String userId, String guid, boolean includeProcesses) {
        LineageVerticesAndEdges response = null;
        try {
            response = this.openLineageClient.lineage(userId, Scope.GLOSSARY, guid, "", includeProcesses);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error(e.getErrorMessage(), e);
        }
        return this.processResponse(response);
    }

    public Map<String, List> getSourceAndDestination(String userId, String guid, boolean includeProcesses) {
        LineageVerticesAndEdges response = null;
        try {
            response = this.openLineageClient.lineage(userId, Scope.SOURCE_AND_DESTINATION, guid, "", includeProcesses);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error(e.getErrorMessage(), e);
        }
        return this.processResponse(response);
    }

    private Map<String, List> processResponse(LineageVerticesAndEdges response) {
        HashMap<String, List> graphData = new HashMap<String, List>();
        List<Object> listEdges = new ArrayList();
        List<Object> listNodes = new ArrayList();
        LOG.debug("Received response from open lineage service: {}", (Object)response);
        if (response == null || CollectionUtils.isEmpty((Collection)response.getLineageVertices())) {
            graphData.put(EDGES_LABEL, listEdges);
            graphData.put(NODES_LABEL, listNodes);
        }
        listNodes = Optional.ofNullable(response.getLineageVertices()).map(Collection::stream).orElseGet(Stream::empty).map(v -> this.createNode(v)).collect(Collectors.toList());
        listEdges = Optional.ofNullable(response.getLineageEdges()).map(e -> e.stream()).orElseGet(Stream::empty).map(e -> {
            Edge newEdge = new Edge(e.getSourceNodeID(), e.getDestinationNodeID());
            return newEdge;
        }).collect(Collectors.toList());
        graphData.put(EDGES_LABEL, listEdges);
        graphData.put(NODES_LABEL, listNodes);
        return graphData;
    }

    private Node createNode(LineageVertex currentNode) {
        String displayName = currentNode.getDisplayName();
        String glossaryTerm = "";
        if (!CollectionUtils.isEmpty((Map)currentNode.getProperties())) {
            glossaryTerm = (String)currentNode.getProperties().get(GLOSSARY_TERM);
        }
        if (!StringUtils.isEmpty((Object)glossaryTerm)) {
            displayName = displayName + "\n" + glossaryTerm;
        }
        Node node = new Node(currentNode.getNodeID(), displayName);
        node.setGroup(currentNode.getNodeType());
        node.setProperties(currentNode.getProperties());
        return node;
    }
}

