/* SPDX-License-Identifier: Apache-2.0 */

/* Copyright Contributors to the ODPi Egeria project. */
import { PolymerElement, html } from "../node_modules/@polymer/polymer/polymer-element.js";
import { mixinBehaviors } from "../node_modules/@polymer/polymer/lib/legacy/class.js";
import { IronOverlayBehavior } from "../node_modules/@polymer/iron-overlay-behavior/iron-overlay-behavior.js";
import "../node_modules/@polymer/paper-spinner/paper-spinner-lite.js";

class SpinnerOverlay extends mixinBehaviors(IronOverlayBehavior, PolymerElement) {
  static get template() {
    return html`
          <style>
            :host {
              background: transparent;
            }
            
            paper-spinner-lite {
                width: 80pt;
                height: 80pt;              
            }
          </style>
          <paper-spinner-lite active></paper-spinner-lite> 
    `;
  }

}

window.customElements.define('spinner-overlay', SpinnerOverlay);