/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db.UserRepository;
import org.odpi.openmetadata.userinterface.uichassis.springboot.domain.Role;
import org.odpi.openmetadata.userinterface.uichassis.springboot.domain.User;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"authentication.source"}, havingValue="db")
public class DemoInMemoryInitializingBean
implements InitializingBean {
    @Autowired
    private UserRepository userRepository;

    public void afterPropertiesSet() {
        this.addUser("user", "John", "user", "/resources/img/user.png");
        this.addUser("admin", "Administrator", "admin", "/resources/img/admin.png", new Role[]{Role.ADMIN});
        this.addUser("faith", "Faith Broker ", "admin", "/resources/img/faith.png", new Role[]{Role.DATA_ANALYST});
        this.addUser("callie", "Callie Quartile ", "admin", "/resources/img/callie.png", new Role[]{Role.HR});
        this.addUser("zach", "Zach Now", "admin", "/resources/img/user.png");
        this.addUser("steves", "Steve Starter", "admin", "/resources/img/user.png");
        this.addUser("terri", "Terri Daring", "admin", "/resources/img/user.png");
        this.addUser("tanyatidie", "Tanya Tide", "admin", "/resources/img/user.png");
        this.addUser("pollytasker", "Polly Tasker", "admin", "/resources/img/user.png");
        this.addUser("tessatube", "Tessa Tube", "admin", "/resources/img/user.png");
        this.addUser("calliequartile", "Callie quartile", "admin", "/resources/img/user.png");
        this.addUser("ivorpadlock", "Ivor Padlock", "admin", "/resources/img/user.png");
        this.addUser("bobnitter", "Bob Nitter", "admin", "/resources/img/user.png");
        this.addUser("faithbroker", "Faith Broker", "admin", "/resources/img/user.png");
        this.addUser("sallycounter", "Sally Counter", "admin", "/resources/img/user.png");
        this.addUser("lemmiestage", "Lemmie Stage", "admin", "/resources/img/user.png");
        this.addUser("erinoverview", "Erin Overview", "admin", "/resources/img/user.png");
        this.addUser("harryhopeful", "Harry Hopeful", "admin", "/resources/img/user.png");
        this.addUser("garygeeke", "Gary Geeke", "admin", "/resources/img/user.png");
        this.addUser("grantable", "Grant Able", "admin", "/resources/img/user.png");
        this.addUser("robbierecords", "Robbie Records", "admin", "/resources/img/user.png");
        this.addUser("reggiemint", "Reggie Mint", "admin", "/resources/img/user.png");
        this.addUser("peterprofile", "Peter Profile", "admin", "/resources/img/user.png");
        this.addUser("nancynoah", "Nancy Noah", "admin", "/resources/img/user.png");
        this.addUser("sidneyseeker", "Sidney Seeker", "admin", "/resources/img/user.png");
        this.addUser("tomtally", "tomtally", "admin", "/resources/img/user.png");
        this.addUser("juliestitched", "juliestitched", "admin", "/resources/img/user.png");
        this.addUser("designa", "designa", "admin", "/resources/img/user.png");
        this.addUser("angelacummings", "angelacummings", "admin", "/resources/img/user.png");
        this.addUser("jukeskeeper", "jukeskeeper", "admin", "/resources/img/user.png");
        this.addUser("stewFaster", "stewFaster", "admin", "/resources/img/user.png");
    }

    private void addUser(String username, String name, String password, String avatarUrl, Role ... roles) {
        List rolesList = Stream.of(roles).map(Enum::name).collect(Collectors.toList());
        User user = new User();
        user.setUsername(username);
        user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)password));
        user.setRoles(rolesList);
        user.setName(name);
        user.setAvatarUrl(avatarUrl);
        this.userRepository.save((Object)user);
    }

    private void addUser(String username, String name, String password, String avatarUrl) {
        this.addUser(username, name, password, avatarUrl, new Role[]{Role.USER});
    }
}

