/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot;

import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalog;
import org.odpi.openmetadata.accessservices.glossaryview.client.GlossaryViewClient;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaImpl;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.SessionAuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@SpringBootApplication
@ComponentScan(value={"org.odpi.openmetadata.*"})
@Configuration
public class EgeriaUIPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(EgeriaUIPlatform.class);
    @Value(value="${strict.ssl}")
    Boolean strictSSL;

    public static void main(String[] args) {
        SpringApplication.run(EgeriaUIPlatform.class, (String[])args);
    }

    @Bean
    public InitializingBean getInitialize() {
        return () -> {
            if (!this.strictSSL.booleanValue()) {
                HttpHelper.noStrictSSL();
            }
        };
    }

    @Bean
    public AssetCatalog getAssetCatalog(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws InvalidParameterException {
        return new AssetCatalog(serverName, serverUrl);
    }

    @Bean
    public SubjectArea getSubjectArea(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException {
        return new SubjectAreaImpl(serverName, serverUrl);
    }

    @Bean
    public GlossaryViewClient getGlossaryViewClient(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws InvalidParameterException {
        return new GlossaryViewClient(serverName, serverUrl);
    }

    @Bean
    public OpenLineageClient getOpenLineage(@Value(value="${open.lineage.server.url}") String serverUrl, @Value(value="${open.lineage.server.name}") String serverName) throws InvalidParameterException {
        return new OpenLineageClient(serverName, serverUrl);
    }

    @Bean
    public AuthService getAuthService(@Value(value="${authentication.mode}") String authenticationMode) {
        if (null == authenticationMode || authenticationMode.isEmpty() || "token".equals(authenticationMode)) {
            return new TokenAuthService();
        }
        return new SessionAuthService();
    }
}

