/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.settings;

import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.settings.OmasSettings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.view.RedirectView;

@RestController
public class SettingsController {
    @Value(value="${theme:default}")
    String theme;
    @Value(value="${omas.server.name}")
    String serverName;
    @Value(value="${omas.server.url}")
    String serverUrl;

    @GetMapping(path={"/css/theme"})
    public RedirectView getThemeCss() {
        return new RedirectView("/themes/" + this.theme + "/css/style.css", true);
    }

    @GetMapping(path={"/js/global"})
    public String getRootPath(HttpServletRequest request) {
        return "window.MyAppGlobals = { rootPath: '" + request.getContextPath() + "/' };";
    }

    @GetMapping(value={"/api/omas/settings"})
    public OmasSettings getOmasSettings() {
        return new OmasSettings(this.serverName, this.serverUrl);
    }
}

