/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.subjectarea;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.SecureController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subject-area/glossaries"})
@DependsOn(value={"securityConfig"})
public class SubjectAreaGlossaryController
extends SecureController {
    private final SubjectArea subjectArea;
    private static String className = SubjectAreaGlossaryController.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);
    private final SubjectAreaGlossary subjectAreaGlossary;

    public SubjectAreaGlossaryController(SubjectArea subjectArea) {
        this.subjectArea = subjectArea;
        this.subjectAreaGlossary = subjectArea.getSubjectAreaGlossary();
    }

    @PostMapping
    public SubjectAreaOMASAPIResponse createGlossary(@RequestBody Glossary suppliedGlossary, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Glossary glossary = this.subjectAreaGlossary.createGlossary(userId, suppliedGlossary);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(glossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @GetMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getGlossary(@PathVariable String guid, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Glossary glossary = this.subjectAreaGlossary.getGlossaryByGuid(userId, guid);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(glossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @GetMapping
    public SubjectAreaOMASAPIResponse findGlossary(@RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String userId = this.getUser(request);
        try {
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            List glossaries = this.subjectAreaGlossary.findGlossary(userId, searchCriteria, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            GlossariesResponse glossariesResponse = new GlossariesResponse();
            glossariesResponse.setGlossaries(glossaries);
            response = glossariesResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @GetMapping(path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getGlossaryRelationships(@PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String userId = this.getUser(request);
        try {
            List lines = this.subjectAreaGlossary.getGlossaryRelationships(userId, guid, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @PutMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateGlossary(@PathVariable String guid, @RequestBody Glossary glossary, @RequestParam(value="isReplace", required=false) Boolean isReplace, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isReplace == null) {
                isReplace = false;
            }
            Glossary updatedGlossary = isReplace != false ? this.subjectAreaGlossary.replaceGlossary(userId, guid, glossary) : this.subjectAreaGlossary.updateGlossary(userId, guid, glossary);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(updatedGlossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @DeleteMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteGlossary(@PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge, HttpServletRequest request) {
        if (isPurge == null) {
            isPurge = false;
        }
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isPurge.booleanValue()) {
                this.subjectAreaGlossary.purgeGlossary(userId, guid);
                response = new VoidResponse();
            } else {
                Glossary glossary = this.subjectAreaGlossary.deleteGlossary(userId, guid);
                GlossaryResponse glossaryResponse = new GlossaryResponse();
                glossaryResponse.setGlossary(glossary);
                response = glossaryResponse;
            }
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @PostMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreGlossary(@PathVariable String guid, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Glossary glossary = this.subjectAreaGlossary.restoreGlossary(userId, guid);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(glossary);
            response = glossaryResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }
}

