/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.subjectarea;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectArea;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.SecureController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subject-area/terms"})
public class SubjectAreaTermController
extends SecureController {
    private final SubjectArea subjectArea;
    private static String className = SubjectAreaTermController.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);
    private final SubjectAreaTerm subjectAreaTerm;
    private final String user = "demo";

    public SubjectAreaTermController(SubjectArea subjectArea) {
        this.subjectArea = subjectArea;
        this.subjectAreaTerm = subjectArea.getSubjectAreaTerm();
    }

    @PostMapping
    public SubjectAreaOMASAPIResponse createTerm(@RequestBody Term suppliedTerm, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Term term = this.subjectAreaTerm.createTerm(userId, suppliedTerm);
            TermResponse termResponse = new TermResponse();
            termResponse.setTerm(term);
            response = termResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @GetMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getTerm(@PathVariable String guid, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Term term = this.subjectAreaTerm.getTermByGuid(userId, guid);
            TermResponse termResponse = new TermResponse();
            termResponse.setTerm(term);
            response = termResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @GetMapping(path={"/"})
    public SubjectAreaOMASAPIResponse findTerm(@RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String userId = this.getUser(request);
        try {
            if (offset == null) {
                offset = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            List terms = this.subjectAreaTerm.findTerm(userId, searchCriteria, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            TermsResponse termsResponse = new TermsResponse();
            termsResponse.setTerms(terms);
            response = termsResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @GetMapping(path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getTermRelationships(@PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty, HttpServletRequest request) {
        SubjectAreaOMASAPIResponse response;
        String userId = this.getUser(request);
        try {
            if (offset == null) {
                offset = 0;
            }
            if (pageSize == null) {
                pageSize = 0;
            }
            List lines = this.subjectAreaTerm.getTermRelationships(userId, guid, asOfTime, offset.intValue(), pageSize.intValue(), sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @PutMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateTerm(@PathVariable String guid, @RequestBody Term term, @RequestParam(value="isReplace", required=false) Boolean isReplace, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isReplace == null) {
                isReplace = false;
            }
            Term updatedTerm = isReplace != false ? this.subjectAreaTerm.replaceTerm(userId, guid, term) : this.subjectAreaTerm.updateTerm(userId, guid, term);
            TermResponse termResponse = new TermResponse();
            termResponse.setTerm(updatedTerm);
            response = termResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @DeleteMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTerm(@PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge, HttpServletRequest request) {
        if (isPurge == null) {
            isPurge = false;
        }
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            if (isPurge.booleanValue()) {
                this.subjectAreaTerm.purgeTerm(userId, guid);
                response = new VoidResponse();
            } else {
                Term term = this.subjectAreaTerm.deleteTerm(userId, guid);
                TermResponse termResponse = new TermResponse();
                termResponse.setTerm(term);
                response = termResponse;
            }
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }

    @PostMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTerm(@PathVariable String guid, HttpServletRequest request) {
        String userId = this.getUser(request);
        SubjectAreaOMASAPIResponse response = null;
        try {
            Term term = this.subjectAreaTerm.restoreTerm(userId, guid);
            TermResponse termResponse = new TermResponse();
            termResponse.setTerm(term);
            response = termResponse;
        }
        catch (SubjectAreaCheckedException e) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)e);
        }
        return response;
    }
}

