/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.ffdc;

import java.text.MessageFormat;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ViewServiceErrorCode {
    USER_NOT_AUTHORIZED(400, "VIEW-SERVICE-400-001 ", "User {0} is not authorized to issue the {1} request for open metadata view service {3} on server {4}", "The system is unable to process the request.", "Verify the access rights of the user."),
    PROPERTY_SERVER_ERROR(400, "VIEW-SERVICE-400-002 ", "An unexpected error was returned by the property server during {1} request for open metadata view service {2} on server {3}; message was {0}", "The system is unable to process the request.", "Verify the access rights of the user."),
    SERVER_NOT_AVAILABLE(404, "VIEW-SERVICE-404-001 ", "The Metadata Server {0} is not available", "The system is unable to connect to the Metadata Server.", "Check that the Metadata Server URL is correct in the configuration and the open metadata and governance (OMAG) server is running.  Retry the request when the OMAG Server is available."),
    CLIENT_SIDE_REST_API_ERROR(503, "VIEW-SERVICE-503-001 ", "A client-side exception was received from API call {0} to repository {1}.  The error message was {2}", "The server has issued a call to the open metadata view service REST API in a remote server and has received an exception from the local client libraries.", "Look for errors in the local server's console to understand and correct the source of the error."),
    SERVICE_NOT_INITIALIZED(503, "VIEW-SERVICE-503-002 ", "The view service {0} has not been initialized and can not support REST API call {1}", "The server has received a call to one of its open metadata view services but is unable to process it because the view  service is not active.", "If the server is supposed to have this access service activated, correct the server configuration and restart the server.");

    private int httpErrorCode;
    private String errorMessageId;
    private String errorMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private ViewServiceErrorCode(int newHTTPErrorCode, String newErrorMessageId, String newErrorMessage, String newSystemAction, String newUserAction) {
        this.httpErrorCode = newHTTPErrorCode;
        this.errorMessageId = newErrorMessageId;
        this.errorMessage = newErrorMessage;
        this.systemAction = newSystemAction;
        this.userAction = newUserAction;
    }

    public int getHTTPErrorCode() {
        return this.httpErrorCode;
    }

    public String getErrorMessageId() {
        return this.errorMessageId;
    }

    public String getUnformattedErrorMessage() {
        return this.errorMessage;
    }

    public String getFormattedErrorMessage(String ... params) {
        log.debug(String.format("<== ViewServiceErrorCode.getMessage(%s)", Arrays.toString(params)));
        MessageFormat mf = new MessageFormat(this.errorMessage);
        String result = mf.format(params);
        log.debug(String.format("==> ViewServiceErrorCode.getMessage(%s): %s", Arrays.toString(params), result));
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String toString() {
        return "ViewServiceErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", systemAction='" + this.systemAction + '\'' + ", userAction='" + this.userAction + '\'' + '}';
    }

    static {
        log = LoggerFactory.getLogger(ViewServiceErrorCode.class);
    }
}

