/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OpenLineageService {
    public static final String EDGES_LABEL = "edges";
    public static final String NODES_LABEL = "nodes";
    private final OpenLineageClient openLineageClient;
    private static final Logger LOG = LoggerFactory.getLogger(OpenLineageService.class);

    @Autowired
    public OpenLineageService(OpenLineageClient openLineageClient) {
        this.openLineageClient = openLineageClient;
    }

    public Map<String, List> getUltimateSource(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_SOURCE, guid, "", includeProcesses);
            return this.processResponse(response);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get ultimate source lineage for guid {}", (Object)guid);
            throw new RuntimeException("ultimate source lineage error", e);
        }
    }

    public Map<String, List> getEndToEndLineage(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.END_TO_END, guid, "", includeProcesses);
            return this.processResponse(response);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get end to end lineage for guid {}", (Object)guid);
            throw new RuntimeException("end2end lineage error", e);
        }
    }

    public Map<String, List> getUltimateDestination(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_DESTINATION, guid, "", includeProcesses);
            return this.processResponse(response);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get ultimate destination lineage for guid {}", (Object)guid);
            throw new RuntimeException("ultimate destination lineage error", e);
        }
    }

    public Map<String, List> getGlossaryLineage(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.GLOSSARY, guid, "", includeProcesses);
            return this.processResponse(response);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get glossary lineage for guid {}", (Object)guid);
            throw new RuntimeException("glossary lineage error", e);
        }
    }

    public Map<String, List> getSourceAndDestination(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.SOURCE_AND_DESTINATION, guid, "", includeProcesses);
            return this.processResponse(response);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get source and destination lineage for guid {}", (Object)guid);
            throw new RuntimeException("source and destination lineage error ", e);
        }
    }

    private Map<String, List> processResponse(LineageVerticesAndEdges response) {
        HashMap<String, List> graphData = new HashMap<String, List>();
        List<Object> listEdges = new ArrayList();
        List<Object> listNodes = new ArrayList();
        LOG.debug("Received response from open lineage service: {}", (Object)response);
        if (response == null || CollectionUtils.isEmpty((Collection)response.getLineageVertices())) {
            graphData.put(EDGES_LABEL, listEdges);
            graphData.put(NODES_LABEL, listNodes);
        }
        listNodes = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageVertices).map(Collection::stream).orElseGet(Stream::empty).map(arg_0 -> this.createNode(arg_0)).collect(Collectors.toList());
        listEdges = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageEdges).map(Collection::stream).orElseGet(Stream::empty).map(e -> new Edge(e.getSourceNodeID(), e.getDestinationNodeID())).collect(Collectors.toList());
        graphData.put(EDGES_LABEL, listEdges);
        graphData.put(NODES_LABEL, listNodes);
        return graphData;
    }

    private Node createNode(LineageVertex currentNode) {
        String displayName = currentNode.getDisplayName();
        Node node = new Node(currentNode.getNodeID(), displayName);
        node.setGroup(currentNode.getNodeType());
        node.setProperties(currentNode.getProperties());
        return node;
    }
}

