define(["exports","../../../@polymer/polymer/lib/utils/async.js","../../../@polymer/polymer/lib/utils/debounce.js","../../../@polymer/polymer/lib/utils/flush.js","../../../@polymer/polymer/lib/utils/templatize.js","../../../@polymer/iron-a11y-announcer/iron-a11y-announcer.js","../../../@polymer/iron-a11y-keys-behavior/iron-a11y-keys-behavior.js","../../../@polymer/polymer/lib/utils/flattened-nodes-observer.js","./vaadin-combo-box-placeholder.js"],function(_exports,_async,_debounce,_flush,_templatize,_ironA11yAnnouncer,_ironA11yKeysBehavior,_flattenedNodesObserver,_vaadinComboBoxPlaceholder){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
});_exports.ComboBoxMixin=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * @polymerMixin
 */const ComboBoxMixin=subclass=>class VaadinComboBoxMixinElement extends subclass{static get properties(){return{/**
       * True if the dropdown is open, false otherwise.
       */opened:{type:Boolean,notify:!0,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */,reflectToAttribute:!0,observer:"_openedChanged"},/**
       * Set true to prevent the overlay from opening automatically.
       */autoOpenDisabled:Boolean,/**
       * Set to true to disable this element.
       */disabled:{type:Boolean,value:!1,reflectToAttribute:!0},/**
       * When present, it specifies that the element field is read-only.
       */readonly:{type:Boolean,value:!1,reflectToAttribute:!0},/**
       * Custom function for rendering the content of every item.
       * Receives three arguments:
       *
       * - `root` The `<vaadin-combo-box-item>` internal container DOM element.
       * - `comboBox` The reference to the `<vaadin-combo-box>` element.
       * - `model` The object with the properties related with the rendered
       *   item, contains:
       *   - `model.index` The index of the rendered item.
       *   - `model.item` The item.
       */renderer:Function,/**
       * A full set of items to filter the visible options from.
       * The items can be of either `String` or `Object` type.
       */items:{type:Array,observer:"_itemsChanged"},/**
       * If `true`, the user can input a value that is not present in the items list.
       * `value` property will be set to the input value in this case.
       * Also, when `value` is set programmatically, the input value will be set
       * to reflect that value.
       */allowCustomValue:{type:Boolean,value:!1},/**
       * A subset of items, filtered based on the user input. Filtered items
       * can be assigned directly to omit the internal filtering functionality.
       * The items can be of either `String` or `Object` type.
       */filteredItems:{type:Array},/**
       * The `String` value for the selected item of the combo box. Provides
       * the value for `iron-form`.
       *
       * When there’s no item selected, the value is an empty string.
       *
       * Use `selectedItem` property to get the raw selected item from
       * the `items` array.
       */value:{type:String,observer:"_valueChanged",notify:!0,value:""},/**
       * Used to detect user value changes and fire `change` events.
       */_lastCommittedValue:String,/*
       * When set to `true`, "loading" attribute is added to host and the overlay element.
       */loading:{type:Boolean,value:!1,reflectToAttribute:!0},_focusedIndex:{type:Number,value:-1},/**
       * Filtering string the user has typed into the input field.
       */filter:{type:String,value:"",notify:!0},/**
       * The selected item from the `items` array.
       */selectedItem:{type:Object,notify:!0},/**
       * Path for label of the item. If `items` is an array of objects, the
       * `itemLabelPath` is used to fetch the displayed string label for each
       * item.
       *
       * The item label is also used for matching items when processing user
       * input, i.e., for filtering and selecting items.
       *
       * When using item templates, the property is still needed because it is used
       * for filtering, and for displaying the selected item value in the input box.
       */itemLabelPath:{type:String,value:"label",observer:"_itemLabelPathChanged"},/**
       * Path for the value of the item. If `items` is an array of objects, the
       * `itemValuePath:` is used to fetch the string value for the selected
       * item.
       *
       * The item value is used in the `value` property of the combo box,
       * to provide the form value.
       */itemValuePath:{type:String,value:"value"},/**
       * Path for the id of the item. If `items` is an array of objects,
       * the `itemIdPath` is used to compare and identify the same item
       * in `selectedItem` and `filteredItems` (items given by the
       * `dataProvider` callback).
       */itemIdPath:String,/**
       * The name of this element.
       */name:{type:String},/**
       * Set to true if the value is invalid.
       */invalid:{type:Boolean,reflectToAttribute:!0,notify:!0,value:!1},_toggleElement:Object,_clearElement:Object,_inputElementValue:String,_closeOnBlurIsPrevented:Boolean,_previousDocumentPointerEvents:String,_itemTemplate:Object}}static get observers(){return["_filterChanged(filter, itemValuePath, itemLabelPath)","_itemsOrPathsChanged(items.*, itemValuePath, itemLabelPath)","_filteredItemsChanged(filteredItems.*, itemValuePath, itemLabelPath)","_templateOrRendererChanged(_itemTemplate, renderer)","_loadingChanged(loading)","_selectedItemChanged(selectedItem, itemLabelPath)","_toggleElementChanged(_toggleElement)"]}constructor(){super();this._boundOnFocusout=this._onFocusout.bind(this);this._boundOverlaySelectedItemChanged=this._overlaySelectedItemChanged.bind(this);this._boundClose=this.close.bind(this);this._boundOnOpened=this._onOpened.bind(this);this._boundOnKeyDown=this._onKeyDown.bind(this);this._boundOnClick=this._onClick.bind(this);this._boundOnOverlayTouchAction=this._onOverlayTouchAction.bind(this);this._boundOnTouchend=this._onTouchend.bind(this)}ready(){super.ready();this.addEventListener("focusout",this._boundOnFocusout);this._lastCommittedValue=this.value;_ironA11yAnnouncer.IronA11yAnnouncer.requestAvailability();// 2.0 does not support 'overlay.selection-changed' syntax in listeners
this.$.overlay.addEventListener("selection-changed",this._boundOverlaySelectedItemChanged);this.addEventListener("vaadin-combo-box-dropdown-closed",this._boundClose);this.addEventListener("vaadin-combo-box-dropdown-opened",this._boundOnOpened);this.addEventListener("keydown",this._boundOnKeyDown);this.addEventListener("click",this._boundOnClick);this.$.overlay.addEventListener("vaadin-overlay-touch-action",this._boundOnOverlayTouchAction);this.addEventListener("touchend",this._boundOnTouchend);this._observer=new _flattenedNodesObserver.FlattenedNodesObserver(this,info=>{this._setTemplateFromNodes(info.addedNodes)});const bringToFrontListener=e=>{const overlay=this.$.overlay,dropdown=overlay&&overlay.$.dropdown;// Check dropdown.$ because overlay is lazily instantiated
if(dropdown&&dropdown.$&&this.$.overlay.$.dropdown.$.overlay.bringToFront){requestAnimationFrame(()=>{dropdown.$.overlay.bringToFront()})}};this.addEventListener("mousedown",bringToFrontListener);this.addEventListener("touchstart",bringToFrontListener)}/**
   * Manually invoke existing renderer.
   */render(){if(this.$.overlay._selector){this.$.overlay._selector.querySelectorAll("vaadin-combo-box-item").forEach(item=>item._render())}}_setTemplateFromNodes(nodes){this._itemTemplate=nodes.filter(node=>node.localName&&"template"===node.localName)[0]||this._itemTemplate}_removeNewRendererOrTemplate(template,oldTemplate,renderer,oldRenderer){if(template!==oldTemplate){this._itemTemplate=void 0}else if(renderer!==oldRenderer){this.renderer=void 0}}_templateOrRendererChanged(template,renderer){if(template&&renderer){this._removeNewRendererOrTemplate(template,this._oldTemplate,renderer,this._oldRenderer);throw new Error("You should only use either a renderer or a template for combo box items")}this._oldTemplate=template;this._oldRenderer=renderer}/**
   * Opens the dropdown list.
   */open(){// Prevent _open() being called when input is disabled or read-only
if(!this.disabled&&!this.readonly){this.opened=!0}}/**
   * Closes the dropdown list.
   */close(){this.opened=!1}_openedChanged(value,old){// Prevent _close() being called when opened is set to its default value (false).
if(old===void 0){return}if(this.opened){this._openedWithFocusRing=this.hasAttribute("focus-ring")||this.focusElement&&this.focusElement.hasAttribute("focus-ring");// For touch devices, we don't want to popup virtual keyboard unless input is explicitly focused by the user.
if(!this.hasAttribute("focused")&&!this.$.overlay.touchDevice){this.focus()}}else{this._onClosed();if(this._openedWithFocusRing&&this.hasAttribute("focused")){this.focusElement.setAttribute("focus-ring","")}}}_onOverlayTouchAction(event){// On touch devices, blur the input on touch start inside the overlay, in order to hide
// the virtual keyboard. But don't close the overlay on this blur.
this._closeOnBlurIsPrevented=!0;this.inputElement.blur();this._closeOnBlurIsPrevented=!1}_onClick(e){this._closeOnBlurIsPrevented=!0;const path=e.composedPath(),isClearElement=-1!==path.indexOf(this._clearElement)||"clear-button"===path[0].getAttribute("part");if(isClearElement){this._clear();this.focus()}else if(-1!==path.indexOf(this.inputElement)){if(-1<path.indexOf(this._toggleElement)&&this.opened){this.close()}else if(-1<path.indexOf(this._toggleElement)||!this.autoOpenDisabled){this.open()}}this._closeOnBlurIsPrevented=!1}/**
   * Keyboard navigation
   */_onKeyDown(e){if(this._isEventKey(e,"down")){this._closeOnBlurIsPrevented=!0;this._onArrowDown();this._closeOnBlurIsPrevented=!1;// prevent caret from moving
e.preventDefault()}else if(this._isEventKey(e,"up")){this._closeOnBlurIsPrevented=!0;this._onArrowUp();this._closeOnBlurIsPrevented=!1;// prevent caret from moving
e.preventDefault()}else if(this._isEventKey(e,"enter")){this._onEnter(e)}else if(this._isEventKey(e,"esc")){this._onEscape(e)}}_isEventKey(e,k){return _ironA11yKeysBehavior.IronA11yKeysBehavior.keyboardEventMatchesKeys(e,k)}_getItemLabel(item){return this.$.overlay.getItemLabel(item)}_getItemValue(item){let value=item&&this.itemValuePath?this.get(this.itemValuePath,item):void 0;if(value===void 0){value=item?item.toString():""}return value}_onArrowDown(){if(this.opened){if(this.$.overlay._items){this._focusedIndex=Math.min(this.$.overlay._items.length-1,this._focusedIndex+1);this._prefillFocusedItemLabel()}}else{this.open()}}_onArrowUp(){if(this.opened){if(-1<this._focusedIndex){this._focusedIndex=Math.max(0,this._focusedIndex-1)}else{if(this.$.overlay._items){this._focusedIndex=this.$.overlay._items.length-1}}this._prefillFocusedItemLabel()}else{this.open()}}_prefillFocusedItemLabel(){if(-1<this._focusedIndex){// Reset the input value asyncronously to prevent partial value changes
// announce. Makes OSX VoiceOver to announce the complete value instead.
this._inputElementValue="";// 1ms delay needed for OSX VoiceOver to realise input value was reset
setTimeout(()=>{this._inputElementValue=this._getItemLabel(this.$.overlay._focusedItem);this._markAllSelectionRange()},1)}}_setSelectionRange(start,end){// vaadin-text-field does not implement setSelectionRange, hence we need the native input
const input=this._nativeInput||this.inputElement;// Setting selection range focuses and/or moves the caret in some browsers,
// and there's no need to modify the selection range if the input isn't focused anyway.
// This affects Safari. When the overlay is open, and then hiting tab, browser should focus
// the next focusable element instead of the combo-box itself.
// Checking the focused property here is enough instead of checking the activeElement.
if(this.hasAttribute("focused")&&input&&input.setSelectionRange){try{input.setSelectionRange(start,end)}catch(ignore){// IE11 randomly fails when running tests in Sauce.
}}}_markAllSelectionRange(){if(this._inputElementValue!==void 0){this._setSelectionRange(0,this._inputElementValue.length)}}_clearSelectionRange(){if(this._inputElementValue!==void 0){const pos=this._inputElementValue?this._inputElementValue.length:0;this._setSelectionRange(pos,pos)}}_closeOrCommit(){if(this.autoOpenDisabled&&!this.opened){this._commitValue()}else{this.close()}}_onEnter(e){// should close on enter when custom values are allowed, input field is cleared, or when an existing
// item is focused with keyboard. If auto open is disabled, under the same conditions, commit value.
if((this.opened||this.autoOpenDisabled)&&(this.allowCustomValue||""===this._inputElementValue||-1<this._focusedIndex)){this._closeOrCommit();// Do not submit the surrounding form.
e.preventDefault();// Do not trigger global listeners
e.stopPropagation()}}_onEscape(e){if(this.autoOpenDisabled){this._focusedIndex=-1;this.cancel()}else if(this.opened){this._stopPropagation(e);if(-1<this._focusedIndex){this._focusedIndex=-1;this._revertInputValue()}else{this.cancel()}}}_toggleElementChanged(toggleElement){if(toggleElement){// Don't blur the input on toggle mousedown
toggleElement.addEventListener("mousedown",e=>e.preventDefault());// Unfocus previously focused element if focus is not inside combo box (on touch devices)
toggleElement.addEventListener("click",e=>{if(this.$.overlay.touchDevice&&!this.hasAttribute("focused")){document.activeElement.blur()}})}}/**
   * Clears the current value.
   */_clear(){this.selectedItem=null;if(this.allowCustomValue){this.value=""}this._detectAndDispatchChange()}/**
   * Reverts back to original value.
   */cancel(){this._revertInputValueToValue();// In the next _detectAndDispatchChange() call, the change detection should not pass
this._lastCommittedValue=this.value;this._closeOrCommit()}_onOpened(){// Pre P2 iron-list used a debouncer to render. Now that we synchronously render items,
// we need to flush the DOM to make sure it doesn't get flushed in the middle of _render call
// because that will cause problems to say the least.
(0,_flush.flush)();// With iron-list v1.3.9, calling `notifyResize()` no longer renders
// the items synchronously. It is required to have the items rendered
// before we update the overlay and the list positions and sizes.
this.$.overlay.ensureItemsRendered();this.$.overlay._selector.toggleScrollListener(!0);// Ensure metrics are up-to-date
this.$.overlay.updateViewportBoundaries();// Force iron-list to create reusable nodes. Otherwise it will only start
// doing that in scroll listener, which is especially slow in Edge.
this.$.overlay._selector._increasePoolIfNeeded();setTimeout(()=>this._resizeDropdown(),1);// Defer scroll position adjustment to prevent freeze in Edge
window.requestAnimationFrame(()=>this.$.overlay.adjustScrollPosition());// _detectAndDispatchChange() should not consider value changes done before opening
this._lastCommittedValue=this.value}_onClosed(){// Happens when the overlay is closed by clicking outside
if(this.opened){this.close()}this._commitValue()}_commitValue(){if(this.$.overlay._items&&-1<this._focusedIndex){const focusedItem=this.$.overlay._items[this._focusedIndex];if(this.selectedItem!==focusedItem){this.selectedItem=focusedItem}// make sure input field is updated in case value doesn't change (i.e. FOO -> foo)
this._inputElementValue=this._getItemLabel(this.selectedItem)}else if(""===this._inputElementValue||this._inputElementValue===void 0){this.selectedItem=null;if(this.allowCustomValue){this.value=""}}else{if(this.allowCustomValue// to prevent a repetitive input value being saved after pressing ESC and Tab.
&&!(this.filteredItems&&this.filteredItems.filter(item=>this._getItemLabel(item)===this._inputElementValue).length)){const e=new CustomEvent("custom-value-set",{detail:this._inputElementValue,composed:!0,cancelable:!0,bubbles:!0});this.dispatchEvent(e);if(!e.defaultPrevented){const customValue=this._inputElementValue;this._selectItemForValue(customValue);this.value=customValue}}else{this._inputElementValue=this.selectedItem?this._getItemLabel(this.selectedItem):this.value||""}}this._detectAndDispatchChange();this._clearSelectionRange();if(!this.dataProvider){this.filter=""}}get _propertyForValue(){return"value"}/**
   *  Filtering and items handling
   */_inputValueChanged(e){// Handle only input events from our inputElement.
if(-1!==e.composedPath().indexOf(this.inputElement)){this._inputElementValue=this.inputElement[this._propertyForValue];this._filterFromInput(e)}}_filterFromInput(e){if(!this.opened&&!e.__fromClearButton&&!this.autoOpenDisabled){this.open()}if(this.filter===this._inputElementValue){// Filter and input value might get out of sync, while keyboard navigating for example.
// Afterwards, input value might be changed to the same value as used in filtering.
// In situation like these, we need to make sure all the filter changes handlers are run.
this._filterChanged(this.filter,this.itemValuePath,this.itemLabelPath)}else{this.filter=this._inputElementValue}}_itemLabelPathChanged(itemLabelPath,oldItemLabelPath){if("string"!==typeof itemLabelPath){console.error("You should set itemLabelPath to a valid string")}}_filterChanged(filter,itemValuePath,itemLabelPath){if(filter===void 0){return}if(this.items){this.filteredItems=this._filterItems(this.items,filter)}else{// With certain use cases (e. g., external filtering), `items` are
// undefined. Filtering is unnecessary per se, but the filteredItems
// observer should still be invoked to update focused item.
this._filteredItemsChanged({path:"filteredItems",value:this.filteredItems},itemValuePath,itemLabelPath)}}_loadingChanged(loading){if(loading){this._focusedIndex=-1}}_revertInputValue(){if(""!==this.filter){this._inputElementValue=this.filter}else{this._revertInputValueToValue()}this._clearSelectionRange()}_revertInputValueToValue(){if(this.allowCustomValue&&!this.selectedItem){this._inputElementValue=this.value}else{this._inputElementValue=this._getItemLabel(this.selectedItem)}}_resizeDropdown(){this.$.overlay.$.dropdown.notifyResize()}_updateHasValue(hasValue){if(hasValue){this.setAttribute("has-value","")}else{this.removeAttribute("has-value")}}_selectedItemChanged(selectedItem,itemLabelPath){if(null===selectedItem||selectedItem===void 0){if(this.filteredItems){if(!this.allowCustomValue){this.value=""}this._updateHasValue(""!==this.value);this._inputElementValue=this.value}}else{const value=this._getItemValue(selectedItem);if(this.value!==value){this.value=value;if(this.value!==value){// The value was changed to something else in value-changed listener,
// so prevent from resetting it to the previous value.
return}}this._updateHasValue(!0);this._inputElementValue=this._getItemLabel(selectedItem);// Could not be defined in 1.x because ready is called after all prop-setters
if(this.inputElement){this.inputElement[this._propertyForValue]=this._inputElementValue}}this.$.overlay._selectedItem=selectedItem;if(this.filteredItems&&this.$.overlay._items){this._focusedIndex=this.filteredItems.indexOf(selectedItem)}}_valueChanged(value,oldVal){if(""===value&&oldVal===void 0){// initializing, no need to do anything (#554)
return}if(this._isValidValue(value)){let item;if(this._getItemValue(this.selectedItem)!==value){this._selectItemForValue(value)}else{item=this.selectedItem}if(!item&&this.allowCustomValue){this._inputElementValue=value}this._updateHasValue(""!==this.value)}else{this.selectedItem=null}// In the next _detectAndDispatchChange() call, the change detection should pass
this._lastCommittedValue=void 0}_detectAndDispatchChange(){if(this.value!==this._lastCommittedValue){this.dispatchEvent(new CustomEvent("change",{bubbles:!0}));this._lastCommittedValue=this.value}}_itemsChanged(items,oldItems){this._ensureItemsOrDataProvider(()=>{this.items=oldItems})}_itemsOrPathsChanged(e,itemValuePath,itemLabelPath){if(e.value===void 0){return}if("items"===e.path||"items.splices"===e.path){this.filteredItems=this.items?this.items.slice(0):this.items;const valueIndex=this._indexOfValue(this.value,this.items);this._focusedIndex=valueIndex;const item=-1<valueIndex&&this.items[valueIndex];if(item){this.selectedItem=item}}}_filteredItemsChanged(e,itemValuePath,itemLabelPath){if(e.value===void 0){return}if("filteredItems"===e.path||"filteredItems.splices"===e.path){this._setOverlayItems(this.filteredItems);this._focusedIndex=this.opened||this.autoOpenDisabled?this.$.overlay.indexOfLabel(this.filter):this._indexOfValue(this.value,this.filteredItems);if(this.opened){this._repositionOverlay()}}}_filterItems(arr,filter){if(!arr){return arr}const filteredItems=arr.filter(item=>{filter=filter?filter.toString().toLowerCase():"";// Check if item contains input value.
return-1<this._getItemLabel(item).toString().toLowerCase().indexOf(filter)});return!filteredItems.length&&this.autoOpenDisabled?arr:filteredItems}_selectItemForValue(value){const valueIndex=this._indexOfValue(value,this.filteredItems),previouslySelectedItem=this.selectedItem;this.selectedItem=0<=valueIndex?this.filteredItems[valueIndex]:this.dataProvider&&this.selectedItem===void 0?void 0:null;if(null===this.selectedItem&&null===previouslySelectedItem){this._selectedItemChanged(this.selectedItem)}}_setOverlayItems(items){this.$.overlay.set("_items",items)}_repositionOverlay(){// async needed to reposition correctly after filtering
// (especially when aligned on top of input)
this.__repositionOverlayDebouncer=_debounce.Debouncer.debounce(this.__repositionOverlayDebouncer,// Long debounce: sizing updates invoke multiple styling rounds,
// which is very slow in Edge
_async.timeOut.after(500),()=>{const selector=this.$.overlay._selector;if(!selector._isClientFull()){// Due to the mismatch of the Y position of the item rendered
// at the top of the scrolling list with some specific scroll
// position values (2324, 3486, 6972, 60972, 95757 etc.)
// iron-list loops the increasing of the pool and adds
// too many items to the DOM.
// Adjusting scroll position to equal the current scrollTop value
// to avoid looping.
selector._resetScrollPosition(selector._physicalTop)}this._resizeDropdown();this.$.overlay.updateViewportBoundaries();this.$.overlay.ensureItemsRendered();selector.notifyResize();(0,_flush.flush)()})}_indexOfValue(value,items){if(items&&this._isValidValue(value)){for(let i=0;i<items.length;i++){if(this._getItemValue(items[i])===value){return i}}}return-1}/**
   * Checks if the value is supported as an item value in this control.
   *
   * @return {boolean}
   */_isValidValue(value){return value!==void 0&&null!==value}_overlaySelectedItemChanged(e){// stop this private event from leaking outside.
e.stopPropagation();if(e.detail.item instanceof _vaadinComboBoxPlaceholder.ComboBoxPlaceholder){// Placeholder items should not be selectable.
return}if(this.opened){this._focusedIndex=this.filteredItems.indexOf(e.detail.item);this.close()}else if(this.selectedItem!==e.detail.item){this.selectedItem=e.detail.item;this._detectAndDispatchChange()}}_onFocusout(event){// Fixes the problem with `focusout` happening when clicking on the scroll bar on Edge
const dropdown=this.$.overlay.$.dropdown;if(dropdown&&dropdown.$&&event.relatedTarget===dropdown.$.overlay){event.composedPath()[0].focus();return}if(!this._closeOnBlurIsPrevented){this._closeOrCommit()}}_onTouchend(event){if(!this._clearElement||event.composedPath()[0]!==this._clearElement){return}event.preventDefault();this._clear()}/**
   * Returns true if `value` is valid, and sets the `invalid` flag appropriately.
   *
   * @return {boolean} True if the value is valid and sets the `invalid` flag appropriately
   */validate(){return!(this.invalid=!this.checkValidity())}/**
   * Returns true if the current input value satisfies all constraints (if any)
   *
   * You can override the `checkValidity` method for custom validations.
   */checkValidity(){if(this.inputElement.validate){return this.inputElement.validate()}}get _instanceProps(){return{item:!0,index:!0,selected:!0,focused:!0}}_ensureTemplatized(){if(!this._TemplateClass){const tpl=this._itemTemplate||this._getRootTemplate();if(tpl){this._TemplateClass=(0,_templatize.templatize)(tpl,this,{instanceProps:this._instanceProps,forwardHostProp:function(prop,value){const items=this.$.overlay._selector.querySelectorAll("vaadin-combo-box-item");Array.prototype.forEach.call(items,item=>{if(item._itemTemplateInstance){item._itemTemplateInstance.set(prop,value);item._itemTemplateInstance.notifyPath(prop,value,!0)}})}})}}}_getRootTemplate(){return Array.prototype.filter.call(this.children,elem=>"TEMPLATE"===elem.tagName)[0]}_preventInputBlur(){if(this._toggleElement){this._toggleElement.addEventListener("click",this._preventDefault)}if(this._clearElement){this._clearElement.addEventListener("click",this._preventDefault)}}_restoreInputBlur(){if(this._toggleElement){this._toggleElement.removeEventListener("click",this._preventDefault)}if(this._clearElement){this._clearElement.removeEventListener("click",this._preventDefault)}}_preventDefault(e){e.preventDefault()}_stopPropagation(e){e.stopPropagation()}/**
   * Fired when the value changes.
   *
   * @event value-changed
   * @param {Object} detail
   *  @param {String} detail.value the combobox value
   */ /**
   * Fired when selected item changes.
   *
   * @event selected-item-changed
   * @param {Object} detail
   *  @param {Object|String} detail.value the selected item. Type is the same as the type of `items`.
   */ /**
   * Fired when the user sets a custom value.
   * @event custom-value-set
   * @param {String} detail the custom value
   */ /**
   * Fired when value changes.
   * To comply with https://developer.mozilla.org/en-US/docs/Web/Events/change
   * @event change
   */};_exports.ComboBoxMixin=ComboBoxMixin});