define(["exports","../../../@polymer/iron-a11y-keys-behavior/iron-a11y-keys-behavior.js","../../../@polymer/iron-resizable-behavior/iron-resizable-behavior.js","./vaadin-date-picker-helper.js","../../../@polymer/polymer/lib/utils/gestures.js","../../../@polymer/polymer/lib/legacy/class.js"],function(_exports,_ironA11yKeysBehavior,_ironResizableBehavior,_vaadinDatePickerHelper,_gestures,_class){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
});_exports.DatePickerMixin=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * @polymerMixin
 */const DatePickerMixin=subclass=>class VaadinDatePickerMixin extends(0,_class.mixinBehaviors)([_ironResizableBehavior.IronResizableBehavior],subclass){static get properties(){return{/**
       * The current selected date.
       */_selectedDate:{type:Date},_focusedDate:Date,/**
       * The value for this element.
       *
       * Supported date formats:
       * - ISO 8601 `"YYYY-MM-DD"` (default)
       * - 6-digit extended ISO 8601 `"+YYYYYY-MM-DD"`, `"-YYYYYY-MM-DD"`
       *
       * @type {String}
       */value:{type:String,observer:"_valueChanged",notify:!0,value:""},/**
       * Set to true to mark the input as required.
       */required:{type:Boolean,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */},/**
       * The name of this element.
       */name:{type:String},/**
       * Date which should be visible when there is no value selected.
       *
       * The same date formats as for the `value` property are supported.
       */initialPosition:String,/**
       * The label for this element.
       */label:String,/**
       * Set true to open the date selector overlay.
       */opened:{type:Boolean,reflectToAttribute:!0,notify:!0,observer:"_openedChanged"},/**
       * Set true to prevent the overlay from opening automatically.
       */autoOpenDisabled:Boolean,/**
       * Set true to display ISO-8601 week numbers in the calendar. Notice that
       * displaying week numbers is only supported when `i18n.firstDayOfWeek`
       * is 1 (Monday).
       */showWeekNumbers:{type:Boolean},_fullscreen:{value:!1,observer:"_fullscreenChanged"},_fullscreenMediaQuery:{value:"(max-width: 420px), (max-height: 420px)"},// An array of ancestor elements whose -webkit-overflow-scrolling is forced from value
// 'touch' to value 'auto' in order to prevent them from clipping the dropdown. iOS only.
_touchPrevented:Array,/**
       * The object used to localize this component.
       * To change the default localization, replace the entire
       * _i18n_ object or just the property you want to modify.
       *
       * The object has the following JSON structure and default values:

          {
            // An array with the full names of months starting
            // with January.
            monthNames: [
              'January', 'February', 'March', 'April', 'May',
              'June', 'July', 'August', 'September',
              'October', 'November', 'December'
            ],

            // An array of weekday names starting with Sunday. Used
            // in screen reader announcements.
            weekdays: [
              'Sunday', 'Monday', 'Tuesday', 'Wednesday',
              'Thursday', 'Friday', 'Saturday'
            ],

            // An array of short weekday names starting with Sunday.
            // Displayed in the calendar.
            weekdaysShort: [
              'Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'
            ],

            // An integer indicating the first day of the week
            // (0 = Sunday, 1 = Monday, etc.).
            firstDayOfWeek: 0,

            // Used in screen reader announcements along with week
            // numbers, if they are displayed.
            week: 'Week',

            // Translation of the Calendar icon button title.
            calendar: 'Calendar',

            // Translation of the Clear icon button title.
            clear: 'Clear',

            // Translation of the Today shortcut button text.
            today: 'Today',

            // Translation of the Cancel button text.
            cancel: 'Cancel',

            // A function to format given `Object` as
            // date string. Object is in the format `{ day: ..., month: ..., year: ... }`
            // Note: The argument month is 0-based. This means that January = 0 and December = 11.
            formatDate: d => {
              // returns a string representation of the given
              // object in 'MM/DD/YYYY' -format
            },

            // A function to parse the given text to an `Object` in the format `{ day: ..., month: ..., year: ... }`.
            // Must properly parse (at least) text formatted by `formatDate`.
            // Setting the property to null will disable keyboard input feature.
            // Note: The argument month is 0-based. This means that January = 0 and December = 11.
            parseDate: text => {
              // Parses a string in 'MM/DD/YY', 'MM/DD' or 'DD' -format to
              // an `Object` in the format `{ day: ..., month: ..., year: ... }`.
            }

            // A function to format given `monthName` and
            // `fullYear` integer as calendar title string.
            formatTitle: (monthName, fullYear) => {
              return monthName + ' ' + fullYear;
            }
          }

       *
       * @default {English/US}
       */i18n:{type:Object,value:()=>{return{monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],weekdays:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],weekdaysShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],firstDayOfWeek:0,week:"Week",calendar:"Calendar",clear:"Clear",today:"Today",cancel:"Cancel",formatDate:d=>{const yearStr=(d.year+"").replace(/\d+/,y=>"0000".substr(y.length)+y);return[d.month+1,d.day,yearStr].join("/")},parseDate:text=>{const parts=text.split("/"),today=new Date;let date,month=today.getMonth(),year=today.getFullYear();if(3===parts.length){year=parseInt(parts[2]);if(3>parts[2].length&&0<=year){year+=50>year?2e3:1900}month=parseInt(parts[0])-1;date=parseInt(parts[1])}else if(2===parts.length){month=parseInt(parts[0])-1;date=parseInt(parts[1])}else if(1===parts.length){date=parseInt(parts[0])}if(date!==void 0){return{day:date,month,year}}},formatTitle:(monthName,fullYear)=>{return monthName+" "+fullYear}}}},/**
       * The earliest date that can be selected. All earlier dates will be disabled.
       *
       * Supported date formats:
       * - ISO 8601 `"YYYY-MM-DD"` (default)
       * - 6-digit extended ISO 8601 `"+YYYYYY-MM-DD"`, `"-YYYYYY-MM-DD"`
       *
       * @type {String}
       */min:{type:String,observer:"_minChanged"},/**
       * The latest date that can be selected. All later dates will be disabled.
       *
       * Supported date formats:
       * - ISO 8601 `"YYYY-MM-DD"` (default)
       * - 6-digit extended ISO 8601 `"+YYYYYY-MM-DD"`, `"-YYYYYY-MM-DD"`
       *
       * @type {String}
       */max:{type:String,observer:"_maxChanged"},/**
       * The earliest date that can be selected. All earlier dates will be disabled.
       */_minDate:{type:Date,// null does not work here because minimizer passes undefined to overlay (#351)
value:""},/**
       * The latest date that can be selected. All later dates will be disabled.
       */_maxDate:{type:Date,value:""},_noInput:{type:Boolean,computed:"_isNoInput(_fullscreen, _ios, i18n, i18n.*)"},_ios:{type:Boolean,value:navigator.userAgent.match(/iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/)},_webkitOverflowScroll:{type:Boolean,value:""===document.createElement("div").style.webkitOverflowScrolling},_ignoreAnnounce:{value:!0},_focusOverlayOnOpen:Boolean,_overlayInitialized:Boolean}}static get observers(){return["_updateHasValue(value)","_selectedDateChanged(_selectedDate, i18n.formatDate)","_focusedDateChanged(_focusedDate, i18n.formatDate)","_announceFocusedDate(_focusedDate, opened, _ignoreAnnounce)"]}ready(){super.ready();this._boundOnScroll=this._onScroll.bind(this);this._boundFocus=this._focus.bind(this);this._boundUpdateAlignmentAndPosition=this._updateAlignmentAndPosition.bind(this);const isClearButton=e=>{const path=e.composedPath(),inputIndex=path.indexOf(this._inputElement);return 1===path.slice(0,inputIndex).filter(el=>el.getAttribute&&"clear-button"===el.getAttribute("part")).length};(0,_gestures.addListener)(this,"tap",e=>{// FIXME(platosha): use preventDefault in the text field clear button,
// then the following composedPath check could be simplified down
// to `if (!e.defaultPrevented)`.
// https://github.com/vaadin/vaadin-text-field/issues/352
if(!isClearButton(e)&&(!this.autoOpenDisabled||this._noInput)){this.open()}});this.addEventListener("touchend",e=>{if(!isClearButton(e)){e.preventDefault()}});this.addEventListener("keydown",this._onKeydown.bind(this));this.addEventListener("input",this._onUserInput.bind(this));this.addEventListener("focus",e=>this._noInput&&e.target.blur());this.addEventListener("blur",e=>{if(!this.opened){if(this.autoOpenDisabled){const parsedDate=this._getParsedDate();if(this._isValidDate(parsedDate)){this._selectedDate=parsedDate}}if(""===this._inputElement.value&&this.__dispatchChange){this.validate();this.value="";this.__dispatchChange=!1}else{this.validate()}}})}_initOverlay(){this.$.overlay.removeAttribute("disable-upgrade");this._overlayInitialized=!0;this.$.overlay.addEventListener("opened-changed",e=>this.opened=e.detail.value);this._overlayContent.addEventListener("close",this._close.bind(this));this._overlayContent.addEventListener("focus-input",this._focusAndSelect.bind(this));this.$.overlay.addEventListener("vaadin-overlay-escape-press",this._boundFocus);// Keep focus attribute in focusElement for styling
this._overlayContent.addEventListener("focus",()=>this.focusElement._setFocused(!0));this.$.overlay.addEventListener("vaadin-overlay-close",this._onVaadinOverlayClose.bind(this));const bringToFrontListener=e=>{if(this.$.overlay.bringToFront){requestAnimationFrame(()=>{this.$.overlay.bringToFront()})}};this.addEventListener("mousedown",bringToFrontListener);this.addEventListener("touchstart",bringToFrontListener)}/**
   * @protected
   */disconnectedCallback(){super.disconnectedCallback();if(this._overlayInitialized){this.$.overlay.removeEventListener("vaadin-overlay-escape-press",this._boundFocus)}this.opened=!1}/**
   * Opens the dropdown.
   */open(){if(!this.disabled&&!this.readonly){this.opened=!0}}_close(e){if(e){e.stopPropagation()}this._focus();this.close()}/**
   * Closes the dropdown.
   */close(){if(this._overlayInitialized||this.autoOpenDisabled){this.$.overlay.close()}}get _inputElement(){return this._input()}get _nativeInput(){if(this._inputElement){// vaadin-text-field's input is focusElement
// iron-input's input is inputElement
return this._inputElement.focusElement?this._inputElement.focusElement:this._inputElement.inputElement?this._inputElement.inputElement:window.unwrap?window.unwrap(this._inputElement):this._inputElement}}_parseDate(str){// Parsing with RegExp to ensure correct format
var parts=/^([-+]\d{1}|\d{2,4}|[-+]\d{6})-(\d{1,2})-(\d{1,2})$/.exec(str);if(!parts){return}var date=new Date(0,0);// Wrong date (1900-01-01), but with midnight in local time
date.setFullYear(parseInt(parts[1],10));date.setMonth(parseInt(parts[2],10)-1);date.setDate(parseInt(parts[3],10));return date}_isNoInput(fullscreen,ios,i18n){return!this._inputElement||fullscreen||ios||!i18n.parseDate}_formatISO(date){if(!(date instanceof Date)){return""}const pad=(num,fmt="00")=>(fmt+num).substr((fmt+num).length-fmt.length);let yearSign="",yearFmt="0000",yearAbs=date.getFullYear();if(0>yearAbs){yearAbs=-yearAbs;yearSign="-";yearFmt="000000"}else if(1e4<=date.getFullYear()){yearSign="+";yearFmt="000000"}const year=yearSign+pad(yearAbs,yearFmt),month=pad(date.getMonth()+1),day=pad(date.getDate());return[year,month,day].join("-")}_openedChanged(opened){if(opened&&!this._overlayInitialized){this._initOverlay()}if(this._overlayInitialized){this.$.overlay.opened=opened}if(opened){this._updateAlignmentAndPosition()}}_selectedDateChanged(selectedDate,formatDate){if(selectedDate===void 0||formatDate===void 0){return}if(this.__userInputOccurred){this.__dispatchChange=!0}const value=this._formatISO(selectedDate);this.__keepInputValue||this._applyInputValue(selectedDate);if(value!==this.value){this.validate();this.value=value}this.__userInputOccurred=!1;this.__dispatchChange=!1;this._ignoreFocusedDateChange=!0;this._focusedDate=selectedDate;this._ignoreFocusedDateChange=!1}_focusedDateChanged(focusedDate,formatDate){if(focusedDate===void 0||formatDate===void 0){return}this.__userInputOccurred=!0;if(!this._ignoreFocusedDateChange&&!this._noInput){this._applyInputValue(focusedDate)}}_updateHasValue(value){if(value){this.setAttribute("has-value","")}else{this.removeAttribute("has-value")}}__getOverlayTheme(theme,overlayInitialized){if(overlayInitialized){return theme}}_handleDateChange(property,value,oldValue){if(!value){this[property]="";return}var date=this._parseDate(value);if(!date){this.value=oldValue;return}if(!_vaadinDatePickerHelper.DatePickerHelper._dateEquals(this[property],date)){this[property]=date;this.value&&this.validate()}}_valueChanged(value,oldValue){if(this.__dispatchChange){this.dispatchEvent(new CustomEvent("change",{bubbles:!0}))}this._handleDateChange("_selectedDate",value,oldValue)}_minChanged(value,oldValue){this._handleDateChange("_minDate",value,oldValue)}_maxChanged(value,oldValue){this._handleDateChange("_maxDate",value,oldValue)}_updateAlignmentAndPosition(){if(!this._overlayInitialized){return}if(!this._fullscreen){const inputRect=this._inputElement.getBoundingClientRect(),bottomAlign=inputRect.top>window.innerHeight/2,rightAlign=inputRect.left+this.clientWidth/2>window.innerWidth/2;if(rightAlign){const viewportWidth=Math.min(window.innerWidth,document.documentElement.clientWidth);this.$.overlay.setAttribute("right-aligned","");this.$.overlay.style.removeProperty("left");this.$.overlay.style.right=viewportWidth-inputRect.right+"px"}else{this.$.overlay.removeAttribute("right-aligned");this.$.overlay.style.removeProperty("right");this.$.overlay.style.left=inputRect.left+"px"}if(bottomAlign){const viewportHeight=Math.min(window.innerHeight,document.documentElement.clientHeight);this.$.overlay.setAttribute("bottom-aligned","");this.$.overlay.style.removeProperty("top");this.$.overlay.style.bottom=viewportHeight-inputRect.top+"px"}else{this.$.overlay.removeAttribute("bottom-aligned");this.$.overlay.style.removeProperty("bottom");this.$.overlay.style.top=inputRect.bottom+"px"}}this.$.overlay.setAttribute("dir",getComputedStyle(this._inputElement).getPropertyValue("direction"));this._overlayContent._repositionYearScroller()}_fullscreenChanged(){if(this._overlayInitialized&&this.$.overlay.opened){this._updateAlignmentAndPosition()}}_onOverlayOpened(){this._openedWithFocusRing=this.hasAttribute("focus-ring")||this.focusElement&&this.focusElement.hasAttribute("focus-ring");var parsedInitialPosition=this._parseDate(this.initialPosition),initialPosition=this._selectedDate||this._overlayContent.initialPosition||parsedInitialPosition||new Date;if(parsedInitialPosition||_vaadinDatePickerHelper.DatePickerHelper._dateAllowed(initialPosition,this._minDate,this._maxDate)){this._overlayContent.initialPosition=initialPosition}else{this._overlayContent.initialPosition=_vaadinDatePickerHelper.DatePickerHelper._getClosestDate(initialPosition,[this._minDate,this._maxDate])}this._overlayContent.scrollToDate(this._overlayContent.focusedDate||this._overlayContent.initialPosition);// Have a default focused date
this._ignoreFocusedDateChange=!0;this._overlayContent.focusedDate=this._overlayContent.focusedDate||this._overlayContent.initialPosition;this._ignoreFocusedDateChange=!1;window.addEventListener("scroll",this._boundOnScroll,!0);this.addEventListener("iron-resize",this._boundUpdateAlignmentAndPosition);if(this._webkitOverflowScroll){this._touchPrevented=this._preventWebkitOverflowScrollingTouch(this.parentElement)}if(this._focusOverlayOnOpen){this._overlayContent.focus();this._focusOverlayOnOpen=!1}else{this._focus()}if(this._noInput&&this.focusElement){this.focusElement.blur()}this.updateStyles();this._ignoreAnnounce=!1}// A hack needed for iOS to prevent dropdown from being clipped in an
// ancestor container with -webkit-overflow-scrolling: touch;
_preventWebkitOverflowScrollingTouch(element){var result=[];while(element){if("touch"===window.getComputedStyle(element).webkitOverflowScrolling){var oldInlineValue=element.style.webkitOverflowScrolling;element.style.webkitOverflowScrolling="auto";result.push({element:element,oldInlineValue:oldInlineValue})}element=element.parentElement}return result}_selectParsedOrFocusedDate(){// Select the parsed input or focused date
this._ignoreFocusedDateChange=!0;if(this.i18n.parseDate){const inputValue=this._inputValue||"",parsedDate=this._getParsedDate(inputValue);if(this._isValidDate(parsedDate)){this._selectedDate=parsedDate}else{this.__keepInputValue=!0;this._selectedDate=null;this.__keepInputValue=!1}}else if(this._focusedDate){this._selectedDate=this._focusedDate}this._ignoreFocusedDateChange=!1}_onOverlayClosed(){this._ignoreAnnounce=!0;window.removeEventListener("scroll",this._boundOnScroll,!0);this.removeEventListener("iron-resize",this._boundUpdateAlignmentAndPosition);if(this._touchPrevented){this._touchPrevented.forEach(prevented=>prevented.element.style.webkitOverflowScrolling=prevented.oldInlineValue);this._touchPrevented=[]}this.updateStyles();this._selectParsedOrFocusedDate();if(this._nativeInput&&this._nativeInput.selectionStart){this._nativeInput.selectionStart=this._nativeInput.selectionEnd}// No need to revalidate the value after `_selectedDateChanged`
// Needed in case the value was not changed: open and close dropdown.
if(!this.value){this.validate()}}/**
   * Returns true if `value` is valid, and sets the `invalid` flag appropriately.
   *
   * @param {string} value Value to validate. Optional, defaults to user's input value.
   * @return {boolean} True if the value is valid and sets the `invalid` flag appropriately
   */validate(){// Note (Yuriy): Workaround `this._inputValue` is used in order
// to avoid breaking change on custom `checkValidity`.
// Can be removed with next major.
return!(this.invalid=!this.checkValidity(this._inputValue))}/**
   * Returns true if the current input value satisfies all constraints (if any)
   *
   * Override the `checkValidity` method for custom validations.
   *
   * @param {string} value Value to validate. Optional, defaults to the selected date.
   * @return {boolean} True if the value is valid
   */checkValidity(){const inputValid=!this._inputValue||this._selectedDate&&this._inputValue===this._getFormattedDate(this.i18n.formatDate,this._selectedDate),minMaxValid=!this._selectedDate||_vaadinDatePickerHelper.DatePickerHelper._dateAllowed(this._selectedDate,this._minDate,this._maxDate);let inputValidity=!0;if(this._inputElement){if(this._inputElement.checkValidity){// vaadin native input elements have the checkValidity method
this._inputElement.__forceCheckValidity=!0;inputValidity=this._inputElement.checkValidity();this._inputElement.__forceCheckValidity=!1}else if(this._inputElement.validate){// iron-form-elements have the validate API
inputValidity=this._inputElement.validate()}}return inputValid&&minMaxValid&&inputValidity}_onScroll(e){if(e.target===window||!this._overlayContent.contains(e.target)){this._updateAlignmentAndPosition()}}_focus(){if(this._noInput){this._overlayInitialized&&this._overlayContent.focus()}else{this._inputElement.focus()}}_focusAndSelect(){this._focus();this._setSelectionRange(0,this._inputValue.length)}_applyInputValue(date){this._inputValue=date?this._getFormattedDate(this.i18n.formatDate,date):""}_getFormattedDate(formatDate,date){return formatDate(_vaadinDatePickerHelper.DatePickerHelper._extractDateParts(date))}_setSelectionRange(a,b){if(this._nativeInput&&this._nativeInput.setSelectionRange){this._nativeInput.setSelectionRange(a,b)}}/**
   * Keyboard Navigation
   */_eventKey(e){for(var keys=["down","up","enter","esc","tab"],i=0,k;i<keys.length;i++){k=keys[i];if(_ironA11yKeysBehavior.IronA11yKeysBehavior.keyboardEventMatchesKeys(e,k)){return k}}}_isValidDate(d){return d&&!isNaN(d.getTime())}_onKeydown(e){if(this._noInput){// The input element cannot be readonly as it would conflict with
// the required attribute. Both are not allowed on an input element.
// Therefore we prevent default on most keydown events.
var allowedKeys=[9// tab
];if(-1===allowedKeys.indexOf(e.keyCode)){e.preventDefault()}}switch(this._eventKey(e)){case"down":case"up":// prevent scrolling the page with arrows
e.preventDefault();if(this.opened){this._overlayContent.focus();this._overlayContent._onKeydown(e)}else{this._focusOverlayOnOpen=!0;this.open()}break;case"enter":{const parsedDate=this._getParsedDate(),isValidDate=this._isValidDate(parsedDate);if(this.opened){if(this._overlayInitialized&&this._overlayContent.focusedDate&&isValidDate){this._selectedDate=this._overlayContent.focusedDate}this.close()}else{if(!isValidDate&&""!==this._inputElement.value){this.validate()}else{const oldValue=this.value;this._selectParsedOrFocusedDate();if(oldValue===this.value){this.validate()}}}break}case"esc":if(this.opened){this._focusedDate=this._selectedDate;this._close()}else if(this.autoOpenDisabled){// Do not restore selected date if Esc was pressed after clearing input field
if(""===this._inputElement.value){this._selectedDate=null}this._applyInputValue(this._selectedDate)}else{this._focusedDate=this._selectedDate;this._selectParsedOrFocusedDate()}break;case"tab":if(this.opened){e.preventDefault();// Clear the selection range (remains visible on IE)
this._setSelectionRange(0,0);if(e.shiftKey){this._overlayContent.focusCancel()}else{this._overlayContent.focus();this._overlayContent.revealDate(this._focusedDate)}}break;}}_getParsedDate(inputValue=this._inputValue){const dateObject=this.i18n.parseDate&&this.i18n.parseDate(inputValue),parsedDate=dateObject&&this._parseDate(dateObject.year+"-"+(dateObject.month+1)+"-"+dateObject.day);return parsedDate}_onUserInput(e){if(!this.opened&&this._inputElement.value&&!this.autoOpenDisabled){this.open()}this._userInputValueChanged();if(e.__fromClearButton){this.validate();this.__dispatchChange=!0;this.value="";this.__dispatchChange=!1}}_userInputValueChanged(value){if(this.opened&&this._inputValue){const parsedDate=this._getParsedDate();if(this._isValidDate(parsedDate)){this._ignoreFocusedDateChange=!0;if(!_vaadinDatePickerHelper.DatePickerHelper._dateEquals(parsedDate,this._focusedDate)){this._focusedDate=parsedDate}this._ignoreFocusedDateChange=!1}}}_announceFocusedDate(_focusedDate,opened,_ignoreAnnounce){if(opened&&!_ignoreAnnounce){this._overlayContent.announceFocusedDate()}}get _overlayContent(){return this.$.overlay.content.querySelector("#overlay-content")}/**
   * Fired when the user commits a value change.
   *
   * @event change
   */};_exports.DatePickerMixin=DatePickerMixin});