define(["exports","../../../@polymer/polymer/polymer-element.js","../../../@polymer/polymer/lib/mixins/gesture-event-listeners.js","../../../@polymer/iron-media-query/iron-media-query.js","../../vaadin-themable-mixin/vaadin-themable-mixin.js","../../vaadin-themable-mixin/vaadin-theme-property-mixin.js","../../vaadin-control-state-mixin/vaadin-control-state-mixin.js","./vaadin-date-picker-overlay.js","./vaadin-date-picker-overlay-content.js","./vaadin-date-picker-mixin.js","./vaadin-date-picker-text-field.js","../../vaadin-element-mixin/vaadin-element-mixin.js","../../../@polymer/polymer/lib/utils/html-tag.js","../../../@polymer/polymer/lib/utils/render-status.js"],function(_exports,_polymerElement,_gestureEventListeners,_ironMediaQuery,_vaadinThemableMixin,_vaadinThemePropertyMixin,_vaadinControlStateMixin,_vaadinDatePickerOverlay,_vaadinDatePickerOverlayContent,_vaadinDatePickerMixin,_vaadinDatePickerTextField,_vaadinElementMixin,_htmlTag,_renderStatus){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
});_exports.DatePickerElement=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 *
 * `<vaadin-date-picker>` is a date selection field which includes a scrollable
 * month calendar view.
 * ```html
 * <vaadin-date-picker label="Birthday"></vaadin-date-picker>
 * ```
 * ```js
 * datePicker.value = '2016-03-02';
 * ```
 * When the selected `value` is changed, a `value-changed` event is triggered.
 *
 *
 * ### Styling
 *
 * The following shadow DOM parts are available for styling:
 *
 * Part name | Description | Theme for Element
 * ----------------|----------------|----------------
 * `text-field` | Input element | vaadin-date-picker
 * `clear-button` | Clear button | vaadin-date-picker
 * `toggle-button` | Toggle button | vaadin-date-picker
 * `overlay-content` | The overlay element | vaadin-date-picker
 * `overlay-header` | Fullscreen mode header | vaadin-date-picker-overlay-content
 * `label` | Fullscreen mode value/label | vaadin-date-picker-overlay-content
 * `clear-button` | Fullscreen mode clear button | vaadin-date-picker-overlay-content
 * `toggle-button` | Fullscreen mode toggle button | vaadin-date-picker-overlay-content
 * `years-toggle-button` | Fullscreen mode years scroller toggle | vaadin-date-picker-overlay-content
 * `months` | Months scroller | vaadin-date-picker-overlay-content
 * `years` | Years scroller | vaadin-date-picker-overlay-content
 * `toolbar` | Footer bar with buttons | vaadin-date-picker-overlay-content
 * `today-button` | Today button | vaadin-date-picker-overlay-content
 * `cancel-button` | Cancel button | vaadin-date-picker-overlay-content
 * `month` | Month calendar | vaadin-date-picker-overlay-content
 * `year-number` | Year number | vaadin-date-picker-overlay-content
 * `year-separator` | Year separator | vaadin-date-picker-overlay-content
 * `month-header` | Month title | vaadin-month-calendar
 * `weekdays` | Weekday container | vaadin-month-calendar
 * `weekday` | Weekday element | vaadin-month-calendar
 * `week-numbers` | Week numbers container | vaadin-month-calendar
 * `week-number` | Week number element | vaadin-month-calendar
 * `date` | Date element | vaadin-month-calendar
 *
 * See [ThemableMixin – how to apply styles for shadow parts](https://github.com/vaadin/vaadin-themable-mixin/wiki)
 *
 * The following state attributes are available for styling:
 *
 * Attribute    | Description | Part name
 * -------------|-------------|------------
 * `invalid` | Set when the element is invalid | :host
 * `opened` | Set when the date selector overlay is opened | :host
 * `readonly` | Set when the element is readonly | :host
 * `disabled` | Set when the element is disabled | :host
 * `today` | Set on the date corresponding to the current day | date
 * `focused` | Set on the focused date | date
 * `disabled` | Set on the date out of the allowed range | date
 * `selected` | Set on the selected date | date
 *
 * If you want to replace the default input field with a custom implementation, you should use the
 * [`<vaadin-date-picker-light>`](#vaadin-date-picker-light) element.
 *
 * In addition to `<vaadin-date-picker>` itself, the following internal
 * components are themable:
 *
 * - `<vaadin-text-field>`
 * - `<vaadin-date-picker-overlay>`
 * - `<vaadin-date-picker-overlay-content>`
 * - `<vaadin-month-calendar>`
 *
 * Note: the `theme` attribute value set on `<vaadin-date-picker>` is
 * propagated to the internal themable components listed above.
 *
 * @extends PolymerElement
 * @mixes ElementMixin
 * @mixes ControlStateMixin
 * @mixes ThemableMixin
 * @mixes ThemePropertyMixin
 * @mixes DatePickerMixin
 * @mixes GestureEventListeners
 * @demo demo/index.html
 */class DatePickerElement extends(0,_vaadinElementMixin.ElementMixin)((0,_vaadinControlStateMixin.ControlStateMixin)((0,_vaadinThemableMixin.ThemableMixin)((0,_vaadinThemePropertyMixin.ThemePropertyMixin)((0,_vaadinDatePickerMixin.DatePickerMixin)((0,_gestureEventListeners.GestureEventListeners)(_polymerElement.PolymerElement)))))){static get template(){return _htmlTag.html`
    <style>
      :host {
        display: inline-block;
      }

      :host([hidden]) {
        display: none !important;
      }

      :host([opened]) {
        pointer-events: auto;
      }

      [part="text-field"] {
        width: 100%;
        min-width: 0;
      }
    </style>


    <vaadin-date-picker-text-field id="input" role="application" autocomplete="off" on-focus="_focus" value="{{_userInputValue}}" invalid="[[invalid]]" label="[[label]]" name="[[name]]" placeholder="[[placeholder]]" required="[[required]]" disabled="[[disabled]]" readonly="[[readonly]]" error-message="[[errorMessage]]" clear-button-visible="[[clearButtonVisible]]" aria-label\$="[[label]]" part="text-field" theme\$="[[theme]]">
      <slot name="prefix" slot="prefix"></slot>
      <div part="toggle-button" slot="suffix" on-tap="_toggle" role="button" aria-label\$="[[i18n.calendar]]" aria-expanded\$="[[_getAriaExpanded(opened)]]"></div>
    </vaadin-date-picker-text-field>

    <vaadin-date-picker-overlay id="overlay" fullscreen\$="[[_fullscreen]]" theme\$="[[__getOverlayTheme(theme, _overlayInitialized)]]" on-vaadin-overlay-open="_onOverlayOpened" on-vaadin-overlay-close="_onOverlayClosed" disable-upgrade="">
      <template>
        <vaadin-date-picker-overlay-content id="overlay-content" i18n="[[i18n]]" fullscreen\$="[[_fullscreen]]" label="[[label]]" selected-date="{{_selectedDate}}" slot="dropdown-content" focused-date="{{_focusedDate}}" show-week-numbers="[[showWeekNumbers]]" min-date="[[_minDate]]" max-date="[[_maxDate]]" role="dialog" on-date-tap="_close" part="overlay-content" theme\$="[[__getOverlayTheme(theme, _overlayInitialized)]]">
        </vaadin-date-picker-overlay-content>
      </template>
    </vaadin-date-picker-overlay>

    <iron-media-query query="[[_fullscreenMediaQuery]]" query-matches="{{_fullscreen}}">
    </iron-media-query>
`}static get is(){return"vaadin-date-picker"}static get version(){return"4.2.0"}static get properties(){return{/**
       * Set to true to display the clear icon which clears the input.
       */clearButtonVisible:{type:Boolean,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */},/**
       * Set to true to disable this element.
       */disabled:{type:Boolean,value:!1,reflectToAttribute:!0},/**
       * The error message to display when the input is invalid.
       */errorMessage:String,/**
       * A placeholder string in addition to the label. If this is set, the label will always float.
       */placeholder:String,/**
       * Set to true to make this element read-only.
       */readonly:{type:Boolean,value:!1,reflectToAttribute:!0},/**
       * This property is set to true when the control value invalid.
       */invalid:{type:Boolean,reflectToAttribute:!0,notify:!0,value:!1},_userInputValue:String}}static get observers(){return["_userInputValueChanged(_userInputValue)","_setClearButtonLabel(i18n.clear)"]}ready(){super.ready();// In order to have synchronized invalid property, we need to use the same validate logic.
(0,_renderStatus.afterNextRender)(this,()=>this._inputElement.validate=()=>{});this._inputElement.addEventListener("change",e=>{// For change event on text-field blur, after the field is cleared,
// we schedule change event to be dispatched on date-picker blur.
if(""===this._inputElement.value&&!e.__fromClearButton){this.__dispatchChange=!0}})}_onVaadinOverlayClose(e){if(this._openedWithFocusRing&&this.hasAttribute("focused")){this.focusElement.setAttribute("focus-ring","")}else if(!this.hasAttribute("focused")){this.focusElement.blur()}if(e.detail.sourceEvent&&-1!==e.detail.sourceEvent.composedPath().indexOf(this)){e.preventDefault()}}_toggle(e){e.stopPropagation();this[this._overlayInitialized&&this.$.overlay.opened?"close":"open"]()}_input(){return this.$.input}set _inputValue(value){this._inputElement.value=value}get _inputValue(){return this._inputElement.value}_getAriaExpanded(opened){return(!!opened).toString()}/**
   * Focussable element used by vaadin-control-state-mixin
   */get focusElement(){return this._input()||this}_setClearButtonLabel(i18nClear){// FIXME(platosha): expose i18n API in <vaadin-text-field>
// https://github.com/vaadin/vaadin-text-field/issues/348
this._inputElement.shadowRoot.querySelector("[part=\"clear-button\"]").setAttribute("aria-label",i18nClear)}}_exports.DatePickerElement=DatePickerElement;customElements.define(DatePickerElement.is,DatePickerElement)});