define(["exports","../../../@polymer/polymer/polymer-element.js","../../../@polymer/polymer/lib/utils/flattened-nodes-observer.js","../../vaadin-themable-mixin/vaadin-themable-mixin.js","../../vaadin-element-mixin/vaadin-dir-mixin.js","./vaadin-radio-button.js","../../../@polymer/polymer/lib/utils/html-tag.js"],function(_exports,_polymerElement,_flattenedNodesObserver,_vaadinThemableMixin,_vaadinDirMixin,_vaadinRadioButton,_htmlTag){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
});_exports.RadioGroupElement=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * `<vaadin-radio-group>` is a Web Component for grouping vaadin-radio-buttons.
 *
 * ```html
 * <vaadin-radio-group>
 *   <vaadin-radio-button name="foo">Foo</vaadin-radio-button>
 *   <vaadin-radio-button name="bar">Bar</vaadin-radio-button>
 *   <vaadin-radio-button name="baz">Baz</vaadin-radio-button>
 * </vaadin-radio-group>
 * ```
 *
 * ### Styling
 *
 * The following shadow DOM parts are available for styling:
 *
 * Part name | Description
 * ----------------|----------------
 * `label` | The label element
 * `group-field` | The element that wraps radio-buttons
 *
 * The following state attributes are available for styling:
 *
 * Attribute  | Description | Part name
 * -----------|-------------|------------
 * `disabled`   | Set when the radio group and its children are disabled. | :host
 * `readonly` | Set to a readonly radio group | :host
 * `invalid` | Set when the element is invalid | :host
 * `has-label` | Set when the element has a label | :host
 * `has-value` | Set when the element has a value | :host
 * `focused` | Set when the element contains focus | :host
 *
 * See [ThemableMixin – how to apply styles for shadow parts](https://github.com/vaadin/vaadin-themable-mixin/wiki)
 *
 * @extends PolymerElement
 * @mixes ThemableMixin
 * @element vaadin-radio-group
 * @demo demo/index.html
 */class RadioGroupElement extends(0,_vaadinThemableMixin.ThemableMixin)((0,_vaadinDirMixin.DirMixin)(_polymerElement.PolymerElement)){static get template(){return _htmlTag.html`
    <style>
      :host {
        display: inline-flex;

        /* Prevent horizontal overflow in IE 11 instead of wrapping radios */
        max-width: 100%;
      }

      :host::before {
        content: "\\2003";
        width: 0;
        display: inline-block;
      }

      :host([hidden]) {
        display: none !important;
      }

      .vaadin-group-field-container {
        display: flex;
        flex-direction: column;

        /* Prevent horizontal overflow in IE 11 instead of wrapping radios */
        width: 100%;
      }

      [part="label"]:empty {
        display: none;
      }
    </style>

    <div class="vaadin-group-field-container">
      <label part="label">[[label]]</label>

      <div part="group-field">
        <slot id="slot"></slot>
      </div>

      <div part="error-message" id="[[_errorId]]" aria-live="assertive" aria-hidden\$="[[_getErrorMessageAriaHidden(invalid, errorMessage, _errorId)]]">[[errorMessage]]</div>
    </div>
`}static get is(){return"vaadin-radio-group"}static get properties(){return{/**
       * The current disabled state of the radio group. True if group and all internal radio buttons are disabled.
       */disabled:{type:Boolean,reflectToAttribute:!0,observer:"_disabledChanged"},/**
       * This attribute indicates that the user cannot modify the value of the control.
       */readonly:{type:Boolean,reflectToAttribute:!0,observer:"_readonlyChanged"},/**
       * This property is set to true when the value is invalid.
       */invalid:{type:Boolean,reflectToAttribute:!0,notify:!0,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */},/**
       * Specifies that the user must fill in a value.
       */required:{type:Boolean,reflectToAttribute:!0},/**
       * Error to show when the input value is invalid.
       */errorMessage:{type:String,value:""},_errorId:{type:String},_checkedButton:{type:Object},/**
       * String used for the label element.
       */label:{type:String,value:"",observer:"_labelChanged"},/**
       * Value of the radio group.
       */value:{type:String,notify:!0,observer:"_valueChanged"}}}ready(){super.ready();this._addListeners();this._observer=new _flattenedNodesObserver.FlattenedNodesObserver(this,info=>{const checkedChangedListener=e=>{if(e.target.checked){this._changeSelectedButton(e.target)}};// reverse() is used to set the last checked radio button value to radio group value
this._filterRadioButtons(info.addedNodes).reverse().forEach(button=>{button.addEventListener("checked-changed",checkedChangedListener);if(this.disabled){button.disabled=!0}if(button.checked){this._changeSelectedButton(button)}});this._filterRadioButtons(info.removedNodes).forEach(button=>{button.removeEventListener("checked-changed",checkedChangedListener);if(button.checked){this.value=void 0}})});if(this._radioButtons.length){this._setFocusable(0)}this.setAttribute("role","radiogroup");const uniqueId=RadioGroupElement._uniqueId=1+RadioGroupElement._uniqueId||0;this._errorId=`${this.constructor.is}-error-${uniqueId}`}get _radioButtons(){return this._filterRadioButtons(this.querySelectorAll("*"))}_setFocused(focused){if(focused){this.setAttribute("focused","")}else{this.removeAttribute("focused")}}_filterRadioButtons(nodes){return Array.from(nodes).filter(child=>child instanceof _vaadinRadioButton.RadioButtonElement)}_disabledChanged(disabled){this.setAttribute("aria-disabled",disabled);this._updateDisableButtons()}_updateDisableButtons(){this._radioButtons.forEach(button=>{if(this.disabled){button.disabled=!0}else if(this.readonly){// it's not possible to set readonly to radio buttons, but we can
// unchecked ones instead.
button.disabled=button!==this._checkedButton&&this.readonly}else{button.disabled=!1}})}_readonlyChanged(newV,oldV){(newV||oldV)&&this._updateDisableButtons()}_addListeners(){this.addEventListener("keydown",e=>{// if e.target is vaadin-radio-group then assign to checkedRadioButton currently checked radio button
var checkedRadioButton=e.target==this?this._checkedButton:e.target;const horizontalRTL="rtl"===this.getAttribute("dir")&&"vertical"!==this.theme;// LEFT, UP - select previous radio button
if(37===e.keyCode||38===e.keyCode){e.preventDefault();this._selectIncButton(horizontalRTL,checkedRadioButton)}// RIGHT, DOWN - select next radio button
if(39===e.keyCode||40===e.keyCode){e.preventDefault();this._selectIncButton(!horizontalRTL,checkedRadioButton)}});this.addEventListener("focusin",()=>this._setFocused(this._containsFocus()));// Need to check e.composed as a workaround for https://bugzilla.mozilla.org/show_bug.cgi?id=1472887
// otherwise FF runs validation on keyboard focus
this.addEventListener("focusout",e=>{e.composed&&this.validate();this._setFocused(!1)})}_selectIncButton(next,checkedRadioButton){if(next){this._selectNextButton(checkedRadioButton)}else{this._selectPreviousButton(checkedRadioButton)}}_selectButton(element,setFocusRing){if(this._containsFocus()){element.focus();if(setFocusRing){element.setAttribute("focus-ring","")}}this._changeSelectedButton(element,setFocusRing)}_containsFocus(){const root=this.getRootNode(),activeElement=root._activeElement!==void 0?root._activeElement:root.activeElement;// Safari 9 needs polyfilled `_activeElement` to return correct node
return this.contains(activeElement)}_hasEnabledButtons(){return!this._radioButtons.every(button=>button.disabled)}_selectNextButton(element){if(!this._hasEnabledButtons()){return}var nextButton=element.nextElementSibling||this.firstElementChild;if(nextButton.disabled){this._selectNextButton(nextButton)}else{this._selectButton(nextButton,!0)}}_selectPreviousButton(element){if(!this._hasEnabledButtons()){return}var previousButton=element.previousElementSibling||this.lastElementChild;if(previousButton.disabled){this._selectPreviousButton(previousButton)}else{this._selectButton(previousButton,!0)}}_changeSelectedButton(button,fireChangeEvent){if(this._checkedButton===button){return}this._checkedButton=button;if(this._checkedButton){this.value=this._checkedButton.value}this._radioButtons.forEach(button=>{if(button===this._checkedButton){if(fireChangeEvent){button.click()}else{button.checked=!0}}else{button.checked=!1}});this.validate();this.readonly&&this._updateDisableButtons();button&&this._setFocusable(this._radioButtons.indexOf(button))}_valueChanged(newV,oldV){if(oldV&&(""===newV||null===newV||newV===void 0)){this._changeSelectedButton(null);this.removeAttribute("has-value");return}if(!this._checkedButton||newV!=this._checkedButton.value){const newCheckedButton=this._radioButtons.filter(button=>button.value==newV)[0];if(newCheckedButton){this._selectButton(newCheckedButton);this.setAttribute("has-value","")}else{console.warn(`No <vaadin-radio-button> with value ${newV} found.`)}}}/**
   * Returns true if `value` is valid.
   * `<iron-form>` uses this to check the validity or all its elements.
   *
   * @return {boolean} True if the value is valid.
   */validate(){return!(this.invalid=!this.checkValidity())}/**
   * Returns true if the current input value satisfies all constraints (if any)
   * @returns {boolean}
   */checkValidity(){return!this.required||!!this.value}_setFocusable(idx){const items=this._radioButtons;items.forEach(e=>e.tabindex=e===items[idx]?0:-1)}_labelChanged(label){if(label){this.setAttribute("has-label","")}else{this.removeAttribute("has-label")}}_getActiveErrorId(invalid,errorMessage,errorId){return errorMessage&&invalid?errorId:void 0}_getErrorMessageAriaHidden(invalid,errorMessage,errorId){return(!this._getActiveErrorId(invalid,errorMessage,errorId)).toString()}}_exports.RadioGroupElement=RadioGroupElement;customElements.define(RadioGroupElement.is,RadioGroupElement)});