define(["../../node_modules/@polymer/polymer/polymer-element.js","../shared-styles.js","../common/vis-graph.js","../../node_modules/@vaadin/vaadin-radio-button/vaadin-radio-button.js","../../node_modules/@vaadin/vaadin-radio-button/vaadin-radio-group.js","../../node_modules/@vaadin/vaadin-tabs/vaadin-tabs.js","../../node_modules/@vaadin/vaadin-select/vaadin-select.js","../../node_modules/@vaadin/vaadin-dropdown-menu/vaadin-dropdown-menu.js","../../node_modules/@vaadin/vaadin-item/vaadin-item.js","../../node_modules/@vaadin/vaadin-list-box/vaadin-list-box.js","../../node_modules/@polymer/polymer/lib/legacy/class.js","../common/item.js"],function(_polymerElement,_sharedStyles,_visGraph,_vaadinRadioButton,_vaadinRadioGroup,_vaadinTabs,_vaadinSelect,_vaadinDropdownMenu,_vaadinItem,_vaadinListBox,_class,_item){"use strict";/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */class AssetLineageView extends(0,_class.mixinBehaviors)([_item.ItemViewBehavior],_polymerElement.PolymerElement){constructor(){super()}static get template(){return _polymerElement.html`
    <style include="shared-styles">
        :host {
          display: flex;
          flex-direction: column;
          margin:var(--egeria-view-margin);
          min-height: var(--egeria-view-min-height);
          max-height: var(--egeria-view-min-height);
        }
        
        #container {
          background-color: var( --egeria-background-color );
          display: flex;
          flex-direction: column;
          flex-grow: 1;
        }
        #useCases {
            color: var(--egeria-primary-color);
            width: fit-content;
            margin: auto;
        }
    </style>
    
    <app-route route="{{route}}" pattern="/:usecase/:guid" data="{{routeData}}" tail="{{tail}}"></app-route>
     
    <token-ajax id="tokenAjax" last-response="{{graphData}}"></token-ajax>
    <token-ajax id="tokenAjaxDetails" last-response="{{item}}" ></token-ajax>
    <div>
        <vaadin-tabs id ="useCases"  selected="[[ _getUseCase(routeData.usecase) ]]" >
          <vaadin-tab value="ultimateSource" >
            <a href="[[rootPath]]#/asset-lineage/ultimateSource/[[routeData.guid]]" tabindex="-1" rel="noopener"> 
                Ultimate Source
            </a>
          </vaadin-tab>
          <vaadin-tab value="endToEnd">
            <a href="[[rootPath]]#/asset-lineage/endToEnd/[[routeData.guid]]" tabindex="-1"  rel="noopener"> 
                End to End Lineage
            </a>
          </vaadin-tab>
          <vaadin-tab value="ultimateDestination">
            <a href="[[rootPath]]#/asset-lineage/ultimateDestination/[[routeData.guid]]" tabindex="-1"  rel="noopener"> 
                Ultimate Destination
            </a>
          </vaadin-tab>
          <vaadin-tab value="glossaryLineage">
            <a href="[[rootPath]]#/asset-lineage/glossaryLineage/[[routeData.guid]]" tabindex="-1" rel="noopener"> 
                Glossary Lineage
            </a>
          </vaadin-tab>
          <vaadin-tab value="sourceAndDestination">
            <a href="[[rootPath]]#/asset-lineage/sourceAndDestination/[[routeData.guid]]" tabindex="-1" rel="noopener"> 
                Source and Destination
            </a>
          </vaadin-tab>
        </vaadin-tabs>
        <div> 
            <vaadin-select id="processMenu" value="true" >
              <template>
                <vaadin-list-box>
                  <vaadin-item value="true" selected>With ETL Jobs</vaadin-item>
                  <vaadin-item value="false">Without ETL Jobs</vaadin-item>
                </vaadin-list-box>
                </template>
            </vaadin-select>
            <vaadin-select id="glossaryTermMenu" value="true" 
                hidden = "[[_hideIncludeGlossaryTerms(routeData.usecase)]]" >
              <template>
                <vaadin-list-box>
                  <vaadin-item value="true" selected>With Glossary Term</vaadin-item>
                  <vaadin-item value="false">Without Glossary Term</vaadin-item>
                </vaadin-list-box>  
              </template>
            </vaadin-select>
        </div>
    </div>

    <div id="container">
        <vis-graph id="visgraph" data=[[graphData]]></vis-graph>
    </div>
    `}ready(){super.ready();this.$.processMenu.addEventListener("value-changed",()=>this._reload(this.$.useCases.items[this.$.useCases.selected].value,this.$.processMenu.value));this.$.glossaryTermMenu.addEventListener("value-changed",()=>this._reload(this.$.useCases.items[this.$.useCases.selected].value,this.$.processMenu.value))}static get properties(){return{usecases:{type:Array,value:["ultimateSource","endToEnd","ultimateDestination","glossaryLineage","sourceAndDestination"]},graphData:{type:Object,observer:"_graphDataChanged"},graphInteraction:{type:Object,value:{tooltipDelay:200,hideEdgesOnDrag:!0/* ignoreName */ /* skipSlots */}},graphLayout:{type:Object,value:{hierarchical:{enabled:!0,levelSeparation:300,direction:"LR"}}},groups:{type:Object,value:{GlossaryTerm:{color:"#f0e442",shape:"circle"},Column:{color:"#009e73"},RelationalColumn:{color:"#0072b2"},TabularColumn:{color:"#cc79a7"},RelationalTable:{shape:"box",color:"#007836"},Process:{shape:"parallelogram",color:"#b276b2"},condensedNode:{color:"#faa43a"}}}}}connectedCallback(){super.connectedCallback();this.$.visgraph.options.groups=this.groups;this.$.visgraph.options.interaction=this.graphInteraction;this.$.visgraph.options.layout=this.graphLayout;this.$.visgraph.options.physics=/* ignoreName */!1/* skipSlots */ /* skipSlots */}static get observers(){return["_routeChanged(route)"]}_routeChanged(route){if("/asset-lineage"===this.route.prefix){this.$.tokenAjaxDetails.url="/api/assets/"+this.routeData.guid;this.$.tokenAjaxDetails._go();this._reload(this.routeData.usecase,this.$.processMenu.value)}}_graphDataChanged(data,newData){console.debug("oldData"+JSON.stringify(data));console.debug("newData"+JSON.stringify(newData));if(null===data||data===void 0){if(null!=newData){data=newData}else{data={nodes:[],edges:[]}}}for(var i=0;i<data.nodes.length;i++){const egeriaColor=getComputedStyle(this).getPropertyValue("--egeria-primary-color");data.nodes[i].title=JSON.stringify(data.nodes[i].properties,"","<br>");if(null==data.nodes[i].properties){continue}let displayName;if(data.nodes[i].id===this.routeData.guid){data.nodes[i].group="";data.nodes[i].color=egeriaColor;data.nodes[i].font={color:"white"}}if(null!=data.nodes[i].properties.tableDisplayName){displayName=data.nodes[i].properties.tableDisplayName}else if(null!=data.nodes[i].properties["vertex--tableDisplayName"]){displayName=data.nodes[i].properties["vertex--tableDisplayName"]}if(null!=displayName){data.nodes[i].label+=" \n Table : "+displayName}}if(!this._hideIncludeGlossaryTerms(this.routeData.usecase)&&"false"===this.$.glossaryTermMenu.value){for(var filteredNodes=[],nodesToRemove=[],filteredEdges=[],i=0;i<data.nodes.length;i++){if("GlossaryTerm"!==data.nodes[i].group){filteredNodes.push(data.nodes[i])}else{nodesToRemove.push(data.nodes[i])}}for(var j=0,edgeRemoved;j<data.edges.length;j++){edgeRemoved=!1;for(var i=0;i<nodesToRemove.length;i++){if(data.edges[j].from===nodesToRemove[i].id){for(var k=0;k<data.edges.length;k++){if(data.edges[k].to===nodesToRemove[i].id){edgeRemoved=!0;filteredEdges.push({to:data.edges[j].to,from:data.edges[k].from,label:data.edges[k].label})}}}}if(!1===edgeRemoved){filteredEdges.push(data.edges[j])}}data.nodes=filteredNodes;data.edges=filteredEdges}this.$.visgraph.importNodesAndEdges(data.nodes,data.edges)}_ultimateSource(guid,includeProcesses){if(null===includeProcesses||includeProcesses===void 0){includeProcesses="true"}this.$.visgraph.options.groups=this.groups;this.$.tokenAjax.url="/api/lineage/entities/"+guid+"/ultimate-source?includeProcesses="+includeProcesses;this.$.tokenAjax._go()}_endToEndLineage(guid,includeProcesses){if(null===includeProcesses||includeProcesses===void 0){includeProcesses="true"}this.$.visgraph.options.groups=this.groups;this.$.tokenAjax.url="/api/lineage/entities/"+guid+"/end2end?includeProcesses="+includeProcesses;this.$.tokenAjax._go()}_ultimateDestination(guid,includeProcesses){if(null===includeProcesses||includeProcesses===void 0){includeProcesses="true"}this.$.visgraph.options.groups=this.groups;this.$.tokenAjax.url="/api/lineage/entities/"+guid+"/ultimate-destination?includeProcesses="+includeProcesses;this.$.tokenAjax._go()}_glossaryLineage(guid,includeProcesses){if(null===includeProcesses||includeProcesses===void 0){includeProcesses="true"}this.$.visgraph.options.groups=this.groups;this.$.tokenAjax.url="/api/lineage/entities/"+guid+"/glossary-lineage?includeProcesses="+includeProcesses;this.$.tokenAjax._go()}_sourceAndDestination(guid,includeProcesses){if(null===includeProcesses||includeProcesses===void 0){includeProcesses="true"}this.$.visgraph.options.groups=this.groups;this.$.tokenAjax.url="/api/lineage/entities/"+guid+"/source-and-destination?includeProcesses="+includeProcesses;this.$.tokenAjax._go()}_reload(usecase,includeProcesses){switch(usecase){case"ultimateSource":this._ultimateSource(this.routeData.guid,includeProcesses);break;case"endToEnd":this._endToEndLineage(this.routeData.guid,includeProcesses);break;case"ultimateDestination":this._ultimateDestination(this.routeData.guid,includeProcesses);break;case"glossaryLineage":this._glossaryLineage(this.routeData.guid,includeProcesses);break;case"sourceAndDestination":this._sourceAndDestination(this.routeData.guid,includeProcesses);break;}}_getUseCase(usecase){return this.usecases.indexOf(usecase)}_hideIncludeGlossaryTerms(usecase){return!("ultimateDestination"===usecase||"ultimateSource"===usecase)}}window.customElements.define("asset-lineage-view",AssetLineageView)});