define(["../../node_modules/@polymer/polymer/lib/legacy/class.js","../../node_modules/@polymer/app-localize-behavior/app-localize-behavior.js","../../node_modules/@polymer/polymer/polymer-element.js","../shared-styles.js","../token-ajax.js"],function(_class,_appLocalizeBehavior,_polymerElement,_sharedStyles,_tokenAjax){"use strict";/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */ /**
*
* DetailsPanel implements a web component for presentation of details of the focus or view type
*
* It should present to the user a summary of the key characteristics of the focus or view type. This includes:
*
*  For entity types:
*    * type name
*    * description
*    * attributes (listing names of types)
*    * relationships (listing attribute names and types and providing a link to the relationship details)
*    * classifications (listing attribute names and types and providing a link to the classification details)
*
*  For relationship types:
*    * type name
*    * description
*    * attributes (listing names of types)
*    * ends (listing entity types and providing a link to the entity details)
*
*  For classification types:
*
*    * type name
*    * description
*    * attributes (listing names of types)
*    * valid entity types (listing entity types and providing a link to the entity details)
*
* The details panel reacts to events that indicate a change of focus (an entity type's details should be shown)
* or a change of view (a relationship or classification details should be shown).
* Because the details panel also includes links to entity, relationship and classification types (as outlined above)
* the details panel also generates events requesting changeFocus or changeView.
*
* When the UI is first loaded there will be no type information, and until a focus or view type is selected there is
* no particular type to display - therefore following initial load and until a focus/view type is selected, the details
* panel will be blank.
*
*/class RexDetailsPanel extends _polymerElement.PolymerElement{static get template(){return _polymerElement.html`

            <style include="rex-styles">

                .linkable {
                    background-color: #CCCCCC;
                    color: black;
                    cursor: pointer;
                    padding: 0px;
                    width: 200px;
                    border: none;
                    text-align: left;
                    outline: none;
                    font-size: 12px;
                }

                .collapsible {
                    background-color: #CCCCCC;
                    color: black;
                    cursor: pointer;
                    padding: 5px;
                    width: 300px;
                    border: none;
                    text-align: left;
                    outline: none;
                    font-size: 12px;
                }

                .content {
                    padding: 10px 0px 10px 10px;
                    display: none;
                    overflow: hidden;
                    background-color: #CCCCCC;
                }

                 .highlight {
                    background-color: #EEEEEE;
                    color: black;
                    padding: 5px;
                    width: 300px;
                    border: 2px;
                    text-align: left;
                    outline: none;
                    font-size: 12px;
                 }

                </style>

                <body>

                    <div style="height:250px; position:relative; padding:0px 20px 20px; ">
                    <div id="detailsDiv" style="position:relative; padding:0px 20px 20px;">
                        Entity or Relationship details will be displayed here when an instance is selected
                    </div>
              </body>

        `}static get properties(){return{// Reference to TypeManager element which this DetailsPanel depends on.
// The TypeManager is created in the DOM of the parent and is passed in
// once we are all initialised. This avoids any direct dependency from DetailsPanel
// on TypeManager.
typeManager:Object,// Reference to InstanceRetriever element which this DetailsPanel depends on.
// The InstanceRetriever is created in the DOM of the parent and is passed in
// once we are all initialised. This avoids any direct dependency from DetailsPanel
// on InstanceRetriever.
instanceRetriever:Object}}/*
     * Element is ready
     */ready(){// Call super.ready() first to initialise node hash...
super.ready()}// Inter-component event handlers
/*
     *  Inbound event: root-entity-loaded
     *
     *  This function is called when a new root has been loaded.
     */inEvtRootEntityLoaded(e){}/*
     *  Inbound event: focus-entity-changed
     */inEvtFocusEntityChanged(guid){// Check whether this is a known entity.
var expEntity=this.instanceRetriever.getFocusEntity();if(null===expEntity){// entity is not known - there is nothing useful to switch to so leave the details panel as is
return}// The entity is known
this.clearDetails();this.displayEntityDetails(expEntity)}/*
     *  Inbound event: focus-entity-cleared
     */inEvtFocusEntityCleared(){// Clear the details pane - nothing is selected
this.clearDetails()}/*
     *  Inbound event: focus-relationship-cleared
     */inEvtFocusRelationshipCleared(){// Clear the details pane - nothing is selected
this.clearDetails()}/*
     *  Outbound event: change-focus
     */outEvtChangeFocus(typeName){var customEvent=new CustomEvent("change-focus",{bubbles:// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
,composed:!0,detail:{source:"details-panel",focusType:typeName}});this.dispatchEvent(customEvent)}/*
     *  Outbound event: change-focus
     */outEvtChangeView(cat,typeName){var customEvent=new CustomEvent("change-view",{bubbles:!0,composed:!0,detail:{source:"details-panel",viewCategory:cat,viewType:typeName}});this.dispatchEvent(customEvent)}/*
     *  Inbound event: focus-relationship-changed
     */inEvtFocusRelationshipChanged(guid){// Check whether this is a known relationship.
var expRelationship=this.instanceRetriever.getFocusRelationship();if(null===expRelationship){// relationship is not known - there is nothing useful to switch to so leave the details panel as is
return}// The relationship is known
this.clearDetails();this.displayRelationshipDetails(expRelationship)}inEvtGraphCleared(){this.clearDetails()}// Component logic
// Clear down the details panel
// In the UI, once a type has become the focus or view type there will always be a type selected,
// so there is no need to reinstate the introductory text about selecting a type - it is sufficient
// to simply clear the details text.
clearDetails(){var details=this.$.detailsDiv;details.innerHTML=""}// ENTITY DETAILS
/* The desirable order of entity details is as follows:
     * GUID (not interesting but it is the guaranteed unique id of the instance)
     * Version
     * Status (and status-on-delete iff deleted)
     * Properties
     *   type-defined attribute properties - as name : value
     * Classifications
     * Type information (collapsible)
     *   typeName
     *   typeGUID
     *   typeVersion
     * Home
     *   metadatCollectionName
     *   metadataCollectionId
     * Control Properties
     *   createdBy/createdTime
     *   updatedBy/updateTime
     *   maintainedBy
     * Additional fields:
     *   instanceURL
     *   instanceLicense
     *   instanceProvenanceType
     *   replicatedBy
     */displayEntityDetails(expEntity){var entity=expEntity.entityDetail,entityDigest=expEntity.entityDigest,label=entityDigest.label,gen=entityDigest.gen,typeCategory="Entity",details=this.$.detailsDiv;details.innerHTML="";// Add type header
details.innerHTML="Entity: "+label+"  [added in gen "+gen+"]";// GUID
this.entityAddGUID(details,entity);// Type
this.entityAddTypeName(details,entity);// Version
this.entityAddVersion(details,entity);// Status
this.entityAddStatus(details,entity);// Properties
this.entityAddInstanceProperties(details,entity);// Classifications
this.entityAddClassifications(details,entity);// Home
this.entityAddHome(details,entity);// Control properties
this.entityAddControlInformation(details,entity);// Detailed Type
this.entityAddDetailedTypeInformation(details,entity)}entityAddGUID(details,entity){var guid=entity.guid,textnode=document.createTextNode("GUID : "+guid),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}entityAddVersion(details,entity){var version=entity.version,textnode=document.createTextNode("Version : "+version),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}entityAddStatus(details,entity){var currentStatus=entity.status,textnode=document.createTextNode("Status : "+currentStatus),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);// statusOnDelete - displayed IFF current status is DELETED
if("DELETED"===currentStatus){var statusOnDelete=entity.statusOnDelete,textnode=document.createTextNode("statusOnDelete : "+statusOnDelete),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}}entityAddInstanceProperties(details,entity){var textnode=document.createTextNode("Properties:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var properties=entity.properties;if(properties!==void 0){this.displayProperties(properties,listnode)}else{var itemnode=document.createElement("li");itemnode.innerHTML="list is empty";listnode.append(itemnode)}}entityProxyAddUniqueProperties(details,entityProxy){var textnode=document.createTextNode("Unique Properties:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var properties=entityProxy.uniqueProperties;if(properties!==void 0){this.displayProperties(properties,listnode)}else{var itemnode=document.createElement("li");itemnode.innerHTML="list is empty";listnode.append(itemnode)}}displayProperties(props,listelement){var propertyNamesUnsorted=props.propertyNames,propertyNamesSorted=propertyNamesUnsorted.sort();propertyNamesSorted.forEach(propName=>{var itemnode=document.createElement("li");listelement.appendChild(itemnode);// property category
var ipCat=props.instanceProperties[propName].instancePropertyCategory;// Handle at least the following property categories
// PRIMITIVE
// ENUM
// MAP
// ARRAY
switch(ipCat){case"PRIMITIVE":var ppCat=props.instanceProperties[propName].primitiveDefCategory,ppvalue=props.instanceProperties[propName].primitiveValue;itemnode.innerHTML=propName+" : "+ppvalue;break;case"ENUM":var epOrd=props.instanceProperties[propName].ordinal,epSymName=props.instanceProperties[propName].symbolicName;itemnode.innerHTML=propName+" : "+epSymName;break;case"MAP":var propMap=props.instanceProperties[propName].mapValues;// InstanceProperties
// recurse -
itemnode.innerHTML=propName+" :";var listnode=document.createElement("ul");itemnode.appendChild(listnode);this.displayProperties(propMap,listnode);break;case"ARRAY":var propArray=props.instanceProperties[propName].arrayValues;// InstanceProperties
// recurse -
itemnode.innerHTML=propName+" :";var listnode=document.createElement("ul");itemnode.appendChild(listnode);this.displayProperties(propArray,listnode);break;default:var value="<not supported yet>";itemnode.innerHTML=propName+" : "+value;break;}})}entityAddClassifications(details,entity){var textnode=document.createTextNode("Classifications:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);// Present a list of all classifications in alpha order.
var classificationList=entity.classifications;if(classificationList!==void 0){var classificationNamesUnsorted=[],c=0,listnode=document.createElement("ul");details.appendChild(listnode);classificationList.forEach(cls=>{classificationNamesUnsorted[c]=cls.name;c++});var classificationNamesSorted=classificationNamesUnsorted.sort();classificationNamesSorted.forEach(clsName=>{var itemnode=document.createElement("li");itemnode.innerHTML=clsName;// Append a collapsible section that shows the classification properties and origin....
// TODO It would be good to include classification props and origin
listnode.appendChild(itemnode)})}else{// Create an explicitly empty list - keep similar formatting to non-empty case
var listnode=document.createElement("ul");details.appendChild(listnode);var itemnode=document.createElement("li");itemnode.innerHTML="list is empty";listnode.appendChild(itemnode)}}entityAddTypeName(details,entity){var typeName=entity.type.typeDefName,textnode=document.createTextNode("Type: "+typeName),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}entityAddDetailedTypeInformation(details,entity){var typeName=entity.type.typeDefName,button=document.createElement("button");// Collapsible section on type information
button.className="collapsible";button.innerHTML="Detailed type information";var div=document.createElement("div");div.className="content";var textnode=document.createTextNode("typeName : "+typeName),paranode=document.createElement("p");paranode.appendChild(textnode);div.appendChild(paranode);var typeGUID=entity.type.typeDefGUID,textnode=document.createTextNode("typeGUID : "+typeGUID),paranode=document.createElement("p");paranode.appendChild(textnode);div.appendChild(paranode);var typeVersion=entity.type.typeVersion,textnode=document.createTextNode("typeVersion : "+typeVersion),paranode=document.createElement("p");paranode.appendChild(textnode);div.appendChild(paranode);details.append(button);details.append(div);button.addEventListener("click",function(){this.classList.toggle("active");var content=this.nextElementSibling;if("block"===content.style.display){content.style.display="none"}else{content.style.display="block"}})}entityAddHome(details,entity){var textnode=document.createTextNode("Home Repository:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);// metadataCollectionName
var metadataCollectionName=entity.metadataCollectionName,itemnode=document.createElement("li");itemnode.innerHTML="metadataCollectionName : "+metadataCollectionName;listnode.appendChild(itemnode);// metadataCollectionId
var metadataCollectionId=entity.metadataCollectionId,itemnode=document.createElement("li");itemnode.innerHTML="metadataCollectionId : <br>  "+metadataCollectionId;listnode.appendChild(itemnode)}entityAddControlInformation(details,entity){var textnode=document.createTextNode("OMRS Control Properties:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);// createdBy
var createdBy=entity.createdBy,itemnode=document.createElement("li");itemnode.innerHTML="createdBy : "+createdBy;listnode.appendChild(itemnode);// createTime - Date
var createTime=entity.createTime,itemnode=document.createElement("li");itemnode.innerHTML="createTime : "+createTime;listnode.appendChild(itemnode);// updatedBy
var updatedBy=entity.updatedBy,itemnode=document.createElement("li");itemnode.innerHTML="updatedBy : "+updatedBy;listnode.appendChild(itemnode);// updateTime - Date
var updateTime=entity.updateTime,itemnode=document.createElement("li");itemnode.innerHTML="updateTime : "+updateTime;listnode.appendChild(itemnode);// maintainedBy - List<String>
var maintainerList=entity.maintainedBy,maintainersNode=document.createElement("li");maintainersNode.innerHTML="maintainedBy : ";listnode.appendChild(maintainersNode);// list
var maintainersSubList=document.createElement("ul");maintainersNode.appendChild(maintainersSubList);if(maintainerList!==void 0){// add each maintainer
maintainerList.forEach(maintainer=>{var itemnode=document.createElement("li");itemnode.innerHTML=maintainer;maintainersSubList.append(itemnode)})}else{var itemnode=document.createElement("li");itemnode.innerHTML="list is empty";maintainersSubList.append(itemnode)}// instanceURL
var instanceURL=entity.instanceURL,itemnode=document.createElement("li");itemnode.innerHTML="instanceURL : "+instanceURL;listnode.appendChild(itemnode);// instanceLicense
var instanceLicense=entity.instanceLicense,itemnode=document.createElement("li");itemnode.innerHTML="instanceLicense : "+instanceLicense;listnode.appendChild(itemnode);// instanceProvenanceType - enum
var instanceProvenanceType=entity.instanceProvenanceType,itemnode=document.createElement("li");itemnode.innerHTML="instanceProvenanceType : "+instanceProvenanceType;listnode.appendChild(itemnode);// replicatedBy
var replicatedBy=entity.replicatedBy,itemnode=document.createElement("li");itemnode.innerHTML="replicatedBy : "+replicatedBy;listnode.appendChild(itemnode)}entityAddRelationships(details,typeName){var textnode=document.createTextNode("Relationships:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var eex=this.typeManager.getEntityType(typeName),relationshipEntries={},inheritedRelNames=eex.inheritedRelationshipNames;// Present a list of all relationships in alpha order, with inherited relationships in italics.
if(inheritedRelNames!==void 0){inheritedRelNames.forEach(inheritedRelName=>{relationshipEntries[inheritedRelName]={};relationshipEntries[inheritedRelName].inherited=!0})}// Local relationships
var relationshipNames=eex.relationshipNames;if(relationshipNames!==void 0){relationshipNamesSorted=relationshipNames.sort();relationshipNamesSorted.forEach(relationshipName=>{relationshipEntries[relationshipName]={};relationshipEntries[relationshipName].inherited=/* ignoreName */!1/* skipSlots */ /* skipSlots */})}var relationshipNamesUnsorted=Object.keys(relationshipEntries),relationshipNamesSorted=relationshipNamesUnsorted.sort();relationshipNamesSorted.forEach(relName=>{var itemnode=document.createElement("li");this.appendRelationshipLink(itemnode,relName,relationshipEntries[relName].inherited);listnode.appendChild(itemnode)})}entityAddClassificationsOld(details,typeName){var textnode=document.createTextNode("Classifications:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var eex=this.typeManager.getEntityType(typeName),classificationEntries={},inheritedClsNames=eex.inheritedClassificationNames;// Present a list of all classifications in alpha order, with inherited classifications in italics.
if(inheritedClsNames!==void 0){inheritedClsNames.forEach(inheritedClsName=>{classificationEntries[inheritedClsName]={};classificationEntries[inheritedClsName].inherited=!0})}// Local classifications
var classificationNames=eex.classificationNames;if(classificationNames!==void 0){classificationNamesSorted=classificationNames.sort();classificationNamesSorted.forEach(classificationName=>{classificationEntries[classificationName]={};classificationEntries[classificationName].inherited=!1})}var classificationNamesUnsorted=Object.keys(classificationEntries),classificationNamesSorted=classificationNamesUnsorted.sort();classificationNamesSorted.forEach(clsName=>{var itemnode=document.createElement("li");this.appendClassificationLink(itemnode,clsName,!0===classificationEntries[clsName].inherited);listnode.appendChild(itemnode)})}// RELATIONSHIP DETAILS
/* The desirable order of relationship details is as follows:
     * GUID (not interesting but it is the guaranteed unique id of the instance)
     * Version
     * Status (and status-on-delete iff deleted)
     * Properties
     *   type-defined attribute properties - as name : value
     * Entity Proxies for ends of relationship
     * Type information (collapsible)
     *   typeName
     *   typeGUID
     *   typeVersion
     * Home
     *   metadatCollectionName
     *   metadataCollectionId
     * Control Properties
     *   createdBy/createdTime
     *   updatedBy/updateTime
     *   maintainedBy
     * Additional fields:
     *   instanceURL
     *   instanceLicense
     *   instanceProvenanceType
     *   replicatedBy
     */displayRelationshipDetails(expRelationship){var relationship=expRelationship.relationship,relationshipDigest=expRelationship.relationshipDigest,label=relationshipDigest.label,gen=relationshipDigest.gen,typeCategory="Relationship",details=this.$.detailsDiv;details.innerHTML="";// Add type header
details.innerHTML="Relationship: "+label+"  [added in gen "+gen+"]";// GUID
this.relationshipAddGUID(details,relationship);// Type
this.relationshipAddTypeName(details,relationship);// Version
this.relationshipAddVersion(details,relationship);// Status
this.relationshipAddStatus(details,relationship);// Properties
this.relationshipAddInstanceProperties(details,relationship);// Relationship Ends
this.relationshipAddEnds(details,relationship);// Home
this.relationshipAddHome(details,relationship);// Control properties
this.relationshipAddControlInformation(details,relationship);// Detailed Type
this.relationshipAddDetailedTypeInformation(details,relationship)}relationshipAddGUID(details,relationship){// GUID - long
var guid=relationship.guid,textnode=document.createTextNode("GUID : "+guid),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}relationshipAddVersion(details,relationship){// version - long
var version=relationship.version,textnode=document.createTextNode("Version : "+version),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}relationshipAddStatus(details,relationship){// currentStatus - enum; use the getter name not the name of the property
var currentStatus=relationship.status,textnode=document.createTextNode("Status : "+currentStatus),paranode=document.createElement("p");//('Details Panel: relationship status is '+currentStatus);
paranode.appendChild(textnode);details.appendChild(paranode);// statusOnDelete - enum -  used IFF current status is DELETED
if("DELETED"===currentStatus){var statusOnDelete=relatiosnhip.statusOnDelete,textnode=document.createTextNode("statusOnDelete : "+statusOnDelete),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}}relationshipAddInstanceProperties(details,relationship){var textnode=document.createTextNode("Properties:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var properties=relationship.properties;if(properties!==void 0){this.displayProperties(properties,listnode)}else{var itemnode=document.createElement("li");itemnode.innerHTML="list is empty";listnode.append(itemnode)}}// For each entity proxy we want to see GUID, version, status, properties, typeName, metadataCollectionId, metadataCollectionName
// If the user wants to see entity control information they can click on the entity.
// properties are under uniqueProperties.instanceProperties
relationshipAddEnds(details,relationship){var textnode=document.createTextNode("Relationship Ends:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);// End 1
var entityOneProxy=relationship.entityOneProxy,textnode=document.createTextNode("Entity One:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);this.displayEntityProxy(details,entityOneProxy);// End 2
var entityTwoProxy=relationship.entityTwoProxy,textnode=document.createTextNode("Entity Two:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);this.displayEntityProxy(details,entityTwoProxy)}displayEntityProxy(details,entityProxy){var proxyBox=document.createElement("div");proxyBox.className="highlight";details.appendChild(proxyBox);// GUID
this.entityAddGUID(proxyBox,entityProxy);// TypeName
this.entityAddTypeName(proxyBox,entityProxy);// Version
this.entityAddVersion(proxyBox,entityProxy);// Status
this.entityAddStatus(proxyBox,entityProxy);// Properties
this.entityProxyAddUniqueProperties(proxyBox,entityProxy);// Home
this.entityAddHome(proxyBox,entityProxy)}relationshipAddTypeName(details,relationship){var typeName=relationship.type.typeDefName,textnode=document.createTextNode("Type: "+typeName),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}relationshipAddDetailedTypeInformation(details,relationship){var typeName=relationship.type.typeDefName,button=document.createElement("button");// Collapsible section on type information
button.className="collapsible";button.innerHTML="Detailed type information";var div=document.createElement("div");div.className="content";var textnode=document.createTextNode("typeName : "+typeName),paranode=document.createElement("p");paranode.appendChild(textnode);div.appendChild(paranode);var typeGUID=relationship.type.typeDefGUID,textnode=document.createTextNode("typeGUID : "+typeGUID),paranode=document.createElement("p");paranode.appendChild(textnode);div.appendChild(paranode);var typeVersion=relationship.type.typeVersion,textnode=document.createTextNode("typeVersion : "+typeVersion),paranode=document.createElement("p");paranode.appendChild(textnode);div.appendChild(paranode);details.append(button);details.append(div);button.addEventListener("click",function(){this.classList.toggle("active");var content=this.nextElementSibling;if("block"===content.style.display){content.style.display="none"}else{content.style.display="block"}})}relationshipAddHome(details,relationship){var textnode=document.createTextNode("Home Repository:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);// metadataCollectionName
var metadataCollectionName=relationship.metadataCollectionName,itemnode=document.createElement("li");itemnode.innerHTML="metadataCollectionName : "+metadataCollectionName;listnode.appendChild(itemnode);// metadataCollectionId
var metadataCollectionId=relationship.metadataCollectionId,itemnode=document.createElement("li");itemnode.innerHTML="metadataCollectionId : <br>  "+metadataCollectionId;listnode.appendChild(itemnode)}relationshipAddControlInformation(details,relationship){var textnode=document.createTextNode("OMRS Control Properties:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);// createdBy
var createdBy=relationship.createdBy,itemnode=document.createElement("li");itemnode.innerHTML="createdBy : "+createdBy;listnode.appendChild(itemnode);// createTime - Date
var createTime=relationship.createTime,itemnode=document.createElement("li");itemnode.innerHTML="createTime : "+createTime;listnode.appendChild(itemnode);// updatedBy
var updatedBy=relationship.updatedBy,itemnode=document.createElement("li");itemnode.innerHTML="updatedBy : "+updatedBy;listnode.appendChild(itemnode);// updateTime - Date
var updateTime=relationship.updateTime,itemnode=document.createElement("li");itemnode.innerHTML="updateTime : "+updateTime;listnode.appendChild(itemnode);// maintainedBy - List<String>
var maintainerList=relationship.maintainedBy,maintainersNode=document.createElement("li");maintainersNode.innerHTML="maintainedBy : ";listnode.appendChild(maintainersNode);// list
var maintainersSubList=document.createElement("ul");maintainersNode.appendChild(maintainersSubList);if(maintainerList!==void 0){// add each maintainer
maintainerList.forEach(maintainer=>{var itemnode=document.createElement("li");itemnode.innerHTML=maintainer;maintainersSubList.append(itemnode)})}else{var itemnode=document.createElement("li");itemnode.innerHTML="list is empty";maintainersSubList.append(itemnode)}// instanceURL
var instanceURL=relationship.instanceURL,itemnode=document.createElement("li");itemnode.innerHTML="instanceURL : "+instanceURL;listnode.appendChild(itemnode);// instanceLicense
var instanceLicense=relationship.instanceLicense,itemnode=document.createElement("li");itemnode.innerHTML="instanceLicense : "+instanceLicense;listnode.appendChild(itemnode);// instanceProvenanceType - enum
var instanceProvenanceType=relationship.instanceProvenanceType,itemnode=document.createElement("li");itemnode.innerHTML="instanceProvenanceType : "+instanceProvenanceType;listnode.appendChild(itemnode);// replicatedBy
var replicatedBy=relationship.replicatedBy,itemnode=document.createElement("li");itemnode.innerHTML="replicatedBy : "+replicatedBy;listnode.appendChild(itemnode)}// CLASSIFICATION DETAILS
/*
     * The user may have already selected a focus type - or not.
     * If so, include a back link to the focus type; if not then just present the relationship details (no back link)
     *
     */displayClassificationDetails(typeName){var typeCategory="Classification",details=this.$.detailsDiv;details.innerHTML="";if(this.focusType!==void 0){var para=document.createElement("div");para.innerHTML="Return to focus entity type: ";details.append(para);var button=document.createElement("button");button.className="linkable";button.innerHTML=this.focusType;button.addEventListener("click",()=>this.entityLinkHandler(this.focusType));para.append(button)}var textnode=document.createTextNode("Classification Type: "+typeName),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);this.classificationAddDescription(details,typeName);this.classificationAddAttributes(details,typeName);this.classificationAddEntities(details,typeName)}classificationAddDescription(details,typeName){var textnode=document.createTextNode("Description:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var cex=this.typeManager.getClassificationType(typeName),description=cex.classificationDef.description,textnode=document.createTextNode(description),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}classificationAddAttributes(details,typeName){var textnode=document.createTextNode("Attributes:");details.appendChild(textnode);var cex=this.typeManager.getClassificationType(typeName),attributeEntries={},localProps=cex.classificationDef.propertiesDefinition;if(localProps!==void 0){var localPropsSorted=localProps.sort();localPropsSorted.forEach(localProp=>{attributeEntries[localProp.attributeName]={};attributeEntries[localProp.attributeName].inherited=!1;attributeEntries[localProp.attributeName].attributeTypeName=localProp.attributeType.name})}var attributeNamesUnsorted=Object.keys(attributeEntries);if(0<attributeNamesUnsorted.length){var listnode=document.createElement("ul");details.appendChild(listnode);var attributeNamesSorted=attributeNamesUnsorted.sort();attributeNamesSorted.forEach(attrName=>{var itemnode=document.createElement("li"),attrNameNode=document.createTextNode(attrName);if(!0===attributeEntries[attrName].inherited){// display in italics
var element=document.createElement("i");itemnode.appendChild(element);element.appendChild(attrNameNode)}else{itemnode.appendChild(attrNameNode)}var separatorNode=document.createTextNode(" : ");itemnode.appendChild(separatorNode);var attrTypeName=attributeEntries[attrName].attributeTypeName;if(this.typeManager.getEnumType(attrTypeName)!==void 0){this.appendEnumLink(itemnode,attrTypeName)}else{var attrTypeNode=document.createTextNode(attrTypeName);itemnode.appendChild(attrTypeNode)}listnode.appendChild(itemnode)})}else{var nonenode=document.createTextNode(" <none>");details.appendChild(nonenode)}}classificationAddEntities(details,typeName){var textnode=document.createTextNode("Valid entity types:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var validEntityEntries=[],cex=this.typeManager.getClassificationType(typeName),validEntities=cex.classificationDef.validEntityDefs;if(validEntities!==void 0){validEntities.forEach(validEntity=>{validEntityEntries.push(validEntity.name)})}var validEntityEntriesSorted=validEntityEntries.sort();validEntityEntriesSorted.forEach(validEntity=>{var itemnode=document.createElement("li");this.appendEntityLink(itemnode,validEntity);listnode.appendChild(itemnode)})}// Enum details are displayed in the detail area with a back button to return to the current focus type, if any
displayEnumDetails(typeName){var typeCategory="Enum",details=this.$.detailsDiv;details.innerHTML="";if(this.focusType!==void 0){var para=document.createElement("div");para.innerHTML="Return to focus entity type: ";details.append(para);var button=document.createElement("button");button.className="linkable";button.innerHTML=this.focusType;button.addEventListener("click",()=>this.entityLinkHandler(this.focusType));para.append(button)}var textnode=document.createTextNode("Enum Type: "+typeName),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);this.enumAddDescription(details,typeName);this.enumAddValues(details,typeName)}enumAddDescription(details,typeName){var textnode=document.createTextNode("Description:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var eex=this.typeManager.getEnumType(typeName),description=eex.description,textnode=document.createTextNode(description),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}enumAddValues(details,typeName){var listnode=document.createElement("ul");details.appendChild(listnode);// Find the enum elements...
var eex=this.typeManager.getEnumType(typeName),elements=eex.elementDefs;elements.forEach(element=>{var ordinal=element.ordinal,value=element.value,description=element.description,itemnode=document.createElement("li"),element=document.createTextNode(ordinal+" : "+value+" : "+description);itemnode.appendChild(element);listnode.appendChild(itemnode)})}//
// UTILITY FUNCTIONS
//
appendEntityLink(itemnode,itemName){var button=document.createElement("button");button.className="linkable";button.innerHTML="Type: "+itemName;itemnode.appendChild(button);button.addEventListener("click",()=>this.entityLinkHandler(itemName))}appendRelationshipLink(itemnode,itemName,inherited){var button=document.createElement("button");button.className="collapsible";if(inherited){button.innerHTML="<i>"+itemName+"</i>"}else{button.innerHTML=itemName}var div=document.createElement("div");div.className="content";this.relationshipAddAttributes(div,itemName);var paranode=document.createElement("p");div.appendChild(paranode);var detailButton=document.createElement("button");detailButton.className="linkable";detailButton.innerHTML="More Details";div.appendChild(detailButton);detailButton.addEventListener("click",()=>this.relationshipLinkHandler(itemName));itemnode.append(button);itemnode.append(div);button.addEventListener("click",function(){this.classList.toggle("active");var content=this.nextElementSibling;if("block"===content.style.display){content.style.display="none"}else{content.style.display="block"}})}appendClassificationLink(itemnode,itemName,inherited){var button=document.createElement("button");button.className="collapsible";if(inherited){button.innerHTML="<i>"+itemName+"</i>"}else{button.innerHTML=itemName}var div=document.createElement("div");div.className="content";this.classificationAddAttributes(div,itemName);var paranode=document.createElement("p");div.appendChild(paranode);var detailButton=document.createElement("button");detailButton.className="linkable";detailButton.innerHTML="More Details";div.appendChild(detailButton);detailButton.addEventListener("click",()=>this.classificationLinkHandler(itemName));itemnode.append(button);itemnode.append(div);button.addEventListener("click",function(){this.classList.toggle("active");var content=this.nextElementSibling;if("block"===content.style.display){content.style.display="none"}else{content.style.display="block"}})}appendEnumLink(itemnode,itemName){var button=document.createElement("button");button.className="linkable";button.innerHTML=itemName;itemnode.appendChild(button);button.addEventListener("click",()=>this.enumLinkHandler(itemName))}entityLinkHandler(typeName){// Generate the outbound change focus event...
this.outEvtChangeFocus(typeName)}relationshipLinkHandler(typeName){// Generate the outbound change view event...
this.outEvtChangeView("Relationship",typeName)}classificationLinkHandler(typeName){// Generate the outbound change view event...
this.outEvtChangeView("Classification",typeName)}enumLinkHandler(typeName){// Generate the outbound change view event...
this.outEvtChangeView("Enum",typeName)}}window.customElements.define("rex-details-panel",RexDetailsPanel)});