define(["../../node_modules/@polymer/paper-input/paper-input.js","../../node_modules/@polymer/paper-material/paper-material.js","../../node_modules/@polymer/iron-form/iron-form.js","../../node_modules/@polymer/iron-a11y-keys/iron-a11y-keys.js","../../node_modules/@polymer/paper-button/paper-button.js","../../node_modules/@polymer/paper-styles/paper-styles.js","../../node_modules/@polymer/paper-dropdown-menu/paper-dropdown-menu.js","../../node_modules/@polymer/paper-listbox/paper-listbox.js","../../node_modules/@polymer/paper-item/paper-item.js","../../node_modules/@polymer/paper-menu-button/paper-menu-button.js","../../node_modules/@polymer/paper-input/paper-input-behavior.js","../../node_modules/@polymer/paper-dialog/paper-dialog.js","../../node_modules/@polymer/paper-dialog-behavior/paper-dialog-behavior.js","../../node_modules/@polymer/iron-ajax/iron-ajax.js","../../node_modules/@vaadin/vaadin-grid/vaadin-grid.js","../../node_modules/@vaadin/vaadin-grid/vaadin-grid-selection-column.js","../../node_modules/@vaadin/vaadin-grid/vaadin-grid-sort-column.js","../../node_modules/@vaadin/vaadin-text-field/vaadin-text-field.js","../../node_modules/@vaadin/vaadin-button/vaadin-button.js","../../node_modules/@polymer/polymer/polymer-element.js","./subject-area-header.js","./subject-area-home.js","./grid-component/grid-controller.js"],function(_paperInput,_paperMaterial,_ironForm,_ironA11yKeys,_paperButton,_paperStyles,_paperDropdownMenu,_paperListbox,_paperItem,_paperMenuButton,_paperInputBehavior,_paperDialog,_paperDialogBehavior,_ironAjax,_vaadinGrid,_vaadinGridSelectionColumn,_vaadinGridSortColumn,_vaadinTextField,_vaadinButton,_polymerElement,_subjectAreaHeader,_subjectAreaHome,_gridController){"use strict";/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */ /**
*
* SubjectAreaComponent is the top level web component for the subject area expert. It controls all
* interactions between the bigger components.
* It instantiates components and passed them the appropriate properties.
* It listens for events so that it can set the appropriate properties and drive the next action.
* It collects error events so it can call the error component to display the error - not implemented.
* It does not issue rest calls itself.
*
* The idea is push down as much processing as possible into the children components to simplify the top level component.
*/class SubjectAreaComponent extends _polymerElement.PolymerElement{static get template(){return _polymerElement.html`
      <style include="shared-styles">
        :host {
          display: block;
          padding: 10px 20px;
        }
        .container {
          margin: auto;
          height: calc(100vh - 130px);
          background-color: white;
        }
      </style>
      <dom-module id='subject-area-component'>
          <!--header contains the dropdown to choose the view  -->
          <div>
              <subject-area-header id='header' selectedProject='[[selectedProject]]' selectedGlossary='[[selectedGlossary]]' language='[[language]]'></subject-area-header>
          </div>
          <div class='container'>
            <template is="dom-if" if="[[homeView]]" restamp="true">
                  <subject-area-home id='subjectAreaHome' enabledGlossary='[[enabledGlossary]]' refresh='[[refreshHome]]' language='[[language]]' selectedProject='[[selectedProject]]' selectedGlossary='[[selectedGlossary]]'></subject-area-home>
            </template>
            <template is="dom-if" if="[[glossaryGridView]]" restamp="true">
                  <grid-controller name='Glossary' refresh='[[refreshGlossaryGrid]]' selectedProject='[[selectedProject]]' language='[[language]]'></grid-controller>
            </template>
            <template is="dom-if" if="[[projectGridView]]" restamp="true">
                  <grid-controller name='Project' refresh='[[refreshProjectGrid]] language='[[language]]''></grid-controller>
            </template>
            <template is="dom-if" if="[[termGridView]]" restamp="true">
               <!--   <grid-controller name='Term' refresh='[[refreshTermGrid]] language='[[language]]''></grid-controller> -->
               TODO - work in progress
            </template>
              <template is="dom-if" if="[[NoGridView]]" restamp="true">

              </template>
          </div>
           <div>
             <subject-area-errors id='errorMessages' currentError=[[currentError]] ></subject-area-errors>
           </div>
      </dom-module>
  `}static get properties(){return{// language
language:{type:String,value:"en"},//  selected project
selectedProject:{type:Object,notify:!0/* ignoreName */ /* skipSlots */,observer:"_selectedProjectChanged"},//  selected glossary
selectedGlossary:{type:Object,notify:!0,observer:"_selectedGlossaryChanged"},//  selected view
selectedView:{type:String,notify:!0},// views
homeView:{type:String,computed:"computeHomeView(selectedView)",notify:!0},refreshHome:{type:Boolean,notify:!0},refreshGlossaryGrid:{type:Boolean,notify:!0},refreshProjectGrid:{type:Boolean,notify:!0},refreshTermGrid:{type:Boolean,notify:!0},projectGridView:{type:String,computed:"computeProjectGridView(selectedView)",notify:!0//   observer: '_projectGridViewChanged'
},glossaryGridView:{type:String,computed:"computeGlossaryGridView(selectedView)",notify:!0//  observer: '_glossaryGridViewChanged'
},termGridView:{type:String,computed:"computeTermGridView(selectedView)",notify:!0},noGridView:{type:String,computed:"computeNoGridView(selectedView)",notify:!0},enabledGlossary:{type:Boolean,notify:!0,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */},currentError:{type:Object,notify:!0}}}ready(){super.ready();this.$.header.addEventListener("viewSelectionEvent",e=>{this._handleViewSelected(e)});this.addEventListener("rest-error-event",e=>{this._handleRestError(e)});this.addEventListener("projectSelectionEvent",e=>{this._handleProjectSelected(e)});this.addEventListener("glossarySelectionEvent",e=>{this._handleGlossarySelected(e)})}_selectedProjectChanged(newValue){console.log("_selectedProjectChanged - component");this.shadowRoot.getElementById("subjectAreaHome").selectedProject=newValue}_selectedGlossaryChanged(newValue){console.log("_selectedGlossaryChanged - component");this.shadowRoot.getElementById("subjectAreaHome").selectedGlossary=newValue}_handleGlossarySelected(event){console.log("subject-area-component _handleGlossarySelected... "+event);this.selectedGlossary=event.detail;// refresh the view
this.refreshGlossaryGrid=!0;// refresh the header
this.$.header.selectedGlossary=event.detail}_handleProjectSelected(event){console.log("subject-area-component _handleProjectSelected... "+event);this.selectedProject=event.detail;// refresh the view
this.refreshProjectGrid=!0;// refresh the header
this.$.header.selectedProject=event.detail;this.shadowRoot.getElementById("subjectAreaHome").enabledGlossary=!0}_handleViewSelected(event){console.log("subject-area-component _handleViewSelected... "+event.detail);this.selectedView=event.detail}computeHomeView(view){return this.computeActualView(view,"home")}computeGlossaryGridView(view){return this.computeActualView(view,"ggrid")}computeProjectGridView(view){return this.computeActualView(view,"pgrid")}computeTermGridView(view){return this.computeActualView(view,"tgrid")}computeNoGridView(view){return this.computeActualView(view,"ngrid")}_handleRestError(event){console.log("subject-area-component  _handleGlossaryGridRestError... "+event.detail);this.error=event.detail}//  _handleModelInstancesChanged(e) {
//       console.log("subject-area-component  _handleModelInstancesChanged");
//  }
computeActualView(view,viewName){var actualView;if(viewName==view){actualView=!0}return actualView}}window.customElements.define("subject-area-component",SubjectAreaComponent)});