define(["../../node_modules/@polymer/polymer/polymer-element.js","../../node_modules/@polymer/polymer/lib/legacy/class.js","../../node_modules/@polymer/app-localize-behavior/app-localize-behavior.js","../../node_modules/@polymer/paper-input/paper-input.js","../../node_modules/@polymer/paper-material/paper-material.js","../../node_modules/@polymer/iron-form/iron-form.js","../../node_modules/@polymer/iron-a11y-keys/iron-a11y-keys.js","../../node_modules/@polymer/paper-button/paper-button.js","../../node_modules/@polymer/paper-styles/paper-styles.js","../../node_modules/@polymer/paper-input/paper-input-behavior.js","../shared-styles.js"],function(_polymerElement,_class,_appLocalizeBehavior,_paperInput,_paperMaterial,_ironForm,_ironA11yKeys,_paperButton,_paperStyles,_paperInputBehavior,_sharedStyles){"use strict";/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */ /**
*
* Subject Area Header is the header piece that is common across subject area content
*/class SubjectAreaHeader extends(0,_class.mixinBehaviors)([_appLocalizeBehavior.AppLocalizeBehavior],_polymerElement.PolymerElement){static get template(){return _polymerElement.html`
      <style include="shared-styles">
        :host {
          padding: 10px 20px;
          display: inline;
        }
        .headerSelects {
          float: right
        }
      </style>
          <div>
             <paper-dropdown-menu id='viewSelector' label="View"   on-iron-select="_itemSelected">>
                <paper-listbox slot="dropdown-content"  attr-for-selected="name" id="viewlistbox" selected="home">
                           <paper-item name="home">Home</paper-item>
                           <paper-item name="ggrid">Glossary Grid</paper-item>
                           <paper-item name="pgrid">Project Grid</paper-item>
                           <paper-item name="tgrid">Term Grid</paper-item>
                           <paper-item name="ngrid"></paper-item>
                       </paper-listbox>
             </paper-dropdown-menu>
             <div class='headerSelects'>
             <span> [[localize('subject-area_header_project_select')]]</span>
             <span id='selectedProject'><strong>[[selectedProjectLabel]]</strong></span>
             <span> [[localize('subject-area_header_glossary_select')]]</span>
             <span id='selectedGlossary'><strong>[[selectedGlossaryLabel]]</strong></span>
             </div>
          </div>
  `}static get properties(){return{//  selected view
selectedView:{type:Object,notify:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
},//  selected project
selectedProject:{type:Object,notify:!0},//  selected glossary
selectedGlossary:{type:Object,notify:!0},//  selected project
selectedProjectName:{type:String,notify:!0,computed:"_computeProjectName(selectedProject)"},//  selected glossary
selectedGlossaryName:{type:String,notify:!0,computed:"_computeGlossaryName(selectedGlossary)"},//  selected project label
selectedProjectLabel:{type:String,notify:!0,value:"<No project selected>",computed:"_computeProjectLabel(selectedProjectName)"},//  selected glossary label
selectedGlossaryLabel:{type:String,notify:!0,value:"<No glossary selected>",computed:"_computeGlossaryLabel(selectedGlossaryName)"}}}attached(){this.loadResources(// The specified file only contains the flattened translations for that language:
"locales/subject-area/header_"+this.language+".json",//e.g. for es {"hi": "hola"}
this.language,!0)}ready(){super.ready()}_computeProjectName(selected){return this._computeSelectedName(selected)}_computeGlossaryName(selected){return this._computeSelectedName(selected)}_computeSelectedName(selected){var selectedName;if(selected&&selected.name){selectedName=selected.name}return selectedName}_computeProjectLabel(name){if(name){return name}else{return this.localize("subject-area_header_no_selected_project_label")}}_computeGlossaryLabel(name){if(name){return name}else{return this.localize("subject-area_header_no_selected_glossary_label")}}/*
      *driven when an item is selected. Issue a custom event to pass up the selected item.
      */_itemSelected(e){var selectedItem=e.target.selectedItem,selectedItemName=selectedItem.attributes.name.nodeValue;if(selectedItem&&selectedItem.attributes&&selectedItem.attributes.name){console.log("selected item is "+selectedItem.attributes.name.nodeValue);if("ggrid"==selectedItemName&&!this.selectedProjectName){alert(this.localize("subject-area_header_msg_select_project_for_glossary"))}else if("ggrid"==selectedItemName&&!this.selectedProjectName){alert(this.localize("subject-area_header_msg_choose_home_project_select"))}else if("pgrid"==selectedItemName||"home"==selectedItemName){// home and project do not need anything selected prior to using.
this.dispatchEvent(new CustomEvent("viewSelectionEvent",{bubbles:!0,// bubble up
composed:!0,// allow the event to go through shadow dom boundaries
detail:selectedItemName}))}else if(!this.selectedProjectName||!this.selectedGlossaryName){alert(this.localize("subject-area_header_msg_choose_home"))}else{// we have selected project and a selected glossary so send the event.
this.dispatchEvent(new CustomEvent("viewSelectionEvent",{bubbles:!0,// bubble up
composed:!0,// allow the event to go through shadow dom boundaries
detail:selectedItemName}))}}}}window.customElements.define("subject-area-header",SubjectAreaHeader)});