define(["../node_modules/@polymer/polymer/polymer-element.js","../node_modules/@polymer/iron-ajax/iron-ajax.js","./spinner.js"],function(_polymerElement,_ironAjax,_spinner){"use strict";/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */class TokenAjax extends _polymerElement.PolymerElement{static get template(){return _polymerElement.html`
        <style>
        :host {
            /*display: none;*/
        }
        
        </style>
        <iron-localstorage id="storage" name="my-app-storage" value="{{token}}"></iron-localstorage>
        <iron-ajax id="ajax" url="[[url]]"
                   handle-as="json"
                   last-response="{{lastResponse}}"
                   on-error="_handleErrorResponse"
                   body="[[body]]"
                   loading="{{loading}}"
                   method="[[method]]"
                   on-loading-changed="_onLoadingChanged"
                   headers="{{headers}}"
                   >
        </iron-ajax>
        <spinner-overlay id="backdrop" with-backdrop scroll-action="lock" 
            always-on-top 
            no-cancel-on-outside-click
            no-cancel-on-esc-key>       
        </spinner-overlay>
    `}connectedCallback(){super.connectedCallback();this.$.storage.reload()}static get properties(){return{token:{type:String,notify:!0/* ignoreName */ /* skipSlots */,observer:"_tokenUpdated"},loading:{type:Boolean,notify:!0},url:String,lastResponse:{notify:!0},method:{type:String,value:"GET"},body:{type:Object},headers:{type:Object,value:{"content-type":"application/json"},notify:!0},/**
             * If true, automatically performs an Ajax request when either `url` or
             * `params` changes.
             */auto:{type:Boolean,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */}}}static get observers(){return[// Observer method name, followed by a list of dependencies, in parenthesis
"_requestOptionsChanged(auto)","_loadingChanged(loading)"]}_go(){this.$.storage.reload();//console.debug('_go with token:'+this.token);
if("undefined"!==typeof this.token){this.$.ajax.headers["content-type"]="application/json";this.$.ajax.headers["x-auth-token"]=this.token;this._rootPathUrl();this.$.ajax.generateRequest()}else{console.debug("No token set to token-ajax: no _go")}}/**
     *
     * enforcing url starts with rootPath, except a relative url
     */_rootPathUrl(){if(this.$.ajax.url.startsWith("/")&&!this.$.ajax.url.startsWith(this.rootPath)){this.$.ajax.url=this.rootPath+this.$.ajax.url.substring(1)}}_tokenUpdated(){this.$.ajax.headers["x-auth-token"]=this.token}_requestOptionsChanged(auto){if(this.auto){this._go()}}_handleErrorResponse(evt){var status=evt.detail.request.xhr.status,resp=evt.detail.request.xhr.response;// Token is not valid, log out.
if(299<status)if(401===status||403===status||"io.jsonwebtoken.ExpiredJwtException"==resp.exception){this.dispatchEvent(new CustomEvent("logout",{bubbles:!0,composed:!0,detail:{greeted:"Bye!",status:status}}))}else{console.log("Error Response:"+resp);window.dispatchEvent(new CustomEvent("show-feedback",{bubbles:!0,composed:!0,detail:{message:"We are experiencing an unexpected error. Please try again later!",level:"error"}}))}this.$.backdrop.close()}_onLoadingChanged(){//console.debug('cn-loading changed... ' + this.loading);
}_loadingChanged(loading){//console.debug('loading changed... ' + this.loading);
if(this.loading){this.$.backdrop.open()}else{this.$.backdrop.close()}}}window.customElements.define("token-ajax",TokenAjax)});