/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthenticationExceptionHandler;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.LoginFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoginFilter
extends AbstractAuthenticationProcessingFilter {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private final AuthService authenticationService;
    private final AuthenticationExceptionHandler authenticationExceptionHandler;
    private final Set<String> appRoles;
    Logger log = LoggerFactory.getLogger(this.getClass());

    private LoginFilter(LoginFilterBuilder builder) {
        super((RequestMatcher)new AntPathRequestMatcher(LoginFilterBuilder.access$000((LoginFilterBuilder)builder)));
        this.setAuthenticationManager(LoginFilterBuilder.access$100((LoginFilterBuilder)builder));
        this.authenticationService = LoginFilterBuilder.access$200((LoginFilterBuilder)builder);
        this.authenticationExceptionHandler = LoginFilterBuilder.access$300((LoginFilterBuilder)builder);
        this.appRoles = LoginFilterBuilder.access$400((LoginFilterBuilder)builder);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        Authentication authentication = this.getAuthenticationManager().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        return authentication;
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        this.log.info("UNSUCCESSFUL Authentication");
        if (this.authenticationExceptionHandler.isBadCredentials(failed)) {
            this.log.warn("Bad credentials for user: {}", (Object)request.getParameter("username"));
            response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
        } else {
            this.log.warn("ERROR AUTHENTICATION for user: {}", (Object)request.getParameter("username"), (Object)failed);
            response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authentication) throws IOException {
        this.log.info("SUCCESSFUL Authentication for user {}", (Object)request.getParameter("username"));
        if (!this.checkRoles(authentication) || authentication.getAuthorities().isEmpty()) {
            this.log.warn("NO roles for user: {}", (Object)request.getParameter("username"));
            response.sendError(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase());
        } else {
            this.authenticationService.addAuthentication(request, response, authentication);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
    }

    private boolean checkRoles(Authentication authentication) {
        return authentication.getAuthorities().stream().map(r -> r.getAuthority()).anyMatch(this.appRoles::contains);
    }
}

