/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenSettings;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.UserAuthentication;
import org.springframework.security.core.Authentication;
import org.springframework.util.ObjectUtils;

public class SessionAuthService
extends TokenSettings
implements AuthService {
    public static final String USER_ATTRIBUTE_NAME = "user";

    public void addAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        TokenUser tokenUser = this.getTokenUser(authentication);
        request.getSession().setAttribute(USER_ATTRIBUTE_NAME, (Object)this.toJSON(tokenUser));
        String token = this.createTokenForUser(tokenUser, this.tokenSecret);
        response.addHeader("x-auth-token", token);
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        TokenUser user;
        Object userJSON = request.getSession().getAttribute(USER_ATTRIBUTE_NAME);
        if (!ObjectUtils.isEmpty((Object)userJSON) && (user = this.fromJSON(String.valueOf(userJSON))) != null) {
            return new UserAuthentication(user);
        }
        return null;
    }
}

