/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenSettings;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.UserAuthentication;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.redis.TokenRedisClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.util.ObjectUtils;

public class RedisAuthService
extends TokenSettings
implements AuthService {
    @Autowired
    TokenRedisClient tokenRedisClient;
    @Value(value="${token.absolute.timeout}")
    Integer tokenAbsoluteTimeout;

    public void addAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        TokenUser tokenUser = this.getTokenUser(authentication);
        String token = this.createTokenForUser(tokenUser, this.tokenSecret);
        response.addHeader("x-auth-token", token);
        this.tokenRedisClient.set(token, this.tokenAbsoluteTimeout.longValue() * 60L, LocalDateTime.now().plusMinutes(this.tokenTimeout).toString());
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("x-auth-token");
        if (!ObjectUtils.isEmpty((Object)token)) {
            this.validateToken(token);
            this.tokenRedisClient.setKeepTTL(token, LocalDateTime.now().plusMinutes(this.tokenTimeout).toString());
            TokenUser user = this.parseUserFromToken(token, this.tokenSecret);
            if (user != null) {
                return new UserAuthentication(user);
            }
        }
        return null;
    }

    private void validateToken(String token) {
        String tokenValue = this.tokenRedisClient.get(token);
        if (tokenValue == null) {
            throw new JwtException("redis token is expired ");
        }
        LocalDateTime tokenExpire = LocalDateTime.parse(tokenValue);
        if (tokenExpire.isBefore(LocalDateTime.now())) {
            this.tokenRedisClient.del(new String[]{token});
            throw new JwtException("redis token is expired");
        }
    }

    public String createTokenForUser(TokenUser user, String secret) {
        return Jwts.builder().setId(UUID.randomUUID().toString()).setSubject(this.toJSON(user)).signWith(SignatureAlgorithm.HS512, secret).compact();
    }
}

