/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenSettings;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.UserAuthentication;
import org.springframework.security.core.Authentication;

public class TokenAuthService
extends TokenSettings
implements AuthService {
    public void addAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        TokenUser tokenUser = this.getTokenUser(authentication);
        String token = this.createTokenForUser(tokenUser, this.tokenSecret);
        response.addHeader("x-auth-token", token);
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        TokenUser user;
        String token = request.getHeader("x-auth-token");
        if (token != null && !token.isEmpty() && (user = this.parseUserFromToken(token, this.tokenSecret)) != null) {
            return new UserAuthentication(user);
        }
        return null;
    }
}

