/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OpenLineageService {
    public static final String EDGES_LABEL = "edges";
    public static final String NODES_LABEL = "nodes";
    private final OpenLineageClient openLineageClient;
    private static final Logger LOG = LoggerFactory.getLogger(OpenLineageService.class);

    @Autowired
    public OpenLineageService(OpenLineageClient openLineageClient) {
        this.openLineageClient = openLineageClient;
    }

    public Map<String, List> getUltimateSource(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_SOURCE, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get ultimate source lineage for guid {}", (Object)guid);
            throw new RuntimeException("ultimate source lineage error", e);
        }
    }

    public Map<String, List> getEndToEndLineage(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.END_TO_END, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get end to end lineage for guid {}", (Object)guid);
            throw new RuntimeException("end2end lineage error", e);
        }
    }

    public Map<String, List> getUltimateDestination(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_DESTINATION, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get ultimate destination lineage for guid {}", (Object)guid);
            throw new RuntimeException("ultimate destination lineage error", e);
        }
    }

    public Map<String, List> getGlossaryLineage(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.GLOSSARY, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get glossary lineage for guid {}", (Object)guid);
            throw new RuntimeException("glossary lineage error", e);
        }
    }

    public Map<String, List> getSourceAndDestination(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.SOURCE_AND_DESTINATION, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get source and destination lineage for guid {}", (Object)guid);
            throw new RuntimeException("source and destination lineage error ", e);
        }
    }

    private Map<String, List> processResponse(LineageVerticesAndEdges response, String guid) {
        HashMap<String, List> graphData = new HashMap<String, List>();
        List<Object> edges = new ArrayList();
        List<Object> nodes = new ArrayList();
        LOG.debug("Received response from open lineage service: {}", (Object)response);
        if (response == null || CollectionUtils.isEmpty((Collection)response.getLineageVertices())) {
            graphData.put(EDGES_LABEL, edges);
            graphData.put(NODES_LABEL, nodes);
        }
        edges = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageEdges).map(Collection::stream).orElseGet(Stream::empty).map(e -> new Edge(e.getSourceNodeID(), e.getDestinationNodeID())).collect(Collectors.toList());
        nodes = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageVertices).map(Collection::stream).orElseGet(Stream::empty).map(arg_0 -> this.createNode(arg_0)).collect(Collectors.toList());
        List startList = nodes.stream().filter(n -> n.getId().equals(guid)).collect(Collectors.toList());
        if (startList.size() > 0) {
            this.setNodesLevel(startList, new ArrayList<Object>(nodes), new ArrayList(edges));
        }
        graphData.put(EDGES_LABEL, edges);
        graphData.put(NODES_LABEL, nodes);
        return graphData;
    }

    private void setNodesLevel(List<Node> startNodes, List<Node> listNodes, List<Edge> listEdges) {
        ArrayList newStartNodes = new ArrayList();
        ListIterator<Edge> edgeListIterator = listEdges.listIterator();
        while (edgeListIterator.hasNext()) {
            Edge e = edgeListIterator.next();
            for (Node node : startNodes) {
                if (node.getId().equals(e.getFrom())) {
                    listNodes.stream().filter(n -> n.getLevel() == 0 && n.getId().equals(e.getTo())).forEach(item -> {
                        item.setLevel(Integer.valueOf(node.getLevel() + 1));
                        newStartNodes.add(item);
                        edgeListIterator.remove();
                    });
                } else if (node.getId().equals(e.getTo())) {
                    listNodes.stream().filter(n -> n.getLevel() == 0 && n.getId().equals(e.getFrom())).forEach(item -> {
                        item.setLevel(Integer.valueOf(node.getLevel() - 1));
                        newStartNodes.add(item);
                        edgeListIterator.remove();
                    });
                }
                listNodes.removeAll(newStartNodes);
            }
        }
        if (newStartNodes.size() > 0 && listEdges.size() > 0) {
            this.setNodesLevel(newStartNodes, listNodes, listEdges);
        }
    }

    private Node createNode(LineageVertex currentNode) {
        String displayName = currentNode.getDisplayName();
        Node node = new Node(currentNode.getNodeID(), displayName);
        node.setGroup(currentNode.getNodeType());
        node.setProperties(currentNode.getProperties());
        return node;
    }
}

