define(["exports","../../../@polymer/polymer/polymer-legacy.js"],function(_exports,_polymerLegacy){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
});_exports.ArrayDataProviderMixin=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * @polymerMixin
 */const ArrayDataProviderMixin=superClass=>class ArrayDataProviderMixin extends superClass{static get properties(){return{/**
       * An array containing the items which will be stamped to the column template
       * instances.
       *
       * @type {Array<!GridItem> | undefined}
       */items:Array}}static get observers(){return["_itemsChanged(items, items.*, isAttached)"]}/** @private */_itemsChanged(items,splices,isAttached){if(!isAttached){return}if(!Array.isArray(items)){if(items===void 0||null===items){this.size=0}if(this.dataProvider===this._arrayDataProvider){this.dataProvider=void 0}return}this.size=items.length;this.dataProvider=this.dataProvider||this._arrayDataProvider;this.clearCache();this._ensureFirstPageLoaded()}/**
   * @param {GridDataProviderParams} opts
   * @param {GridDataProviderCallback} cb
   * @protected
   */_arrayDataProvider(opts,cb){let items=(Array.isArray(this.items)?this.items:[]).slice(0);if(this._filters&&this._checkPaths(this._filters,"filtering",items)){items=this._filter(items)}this.size=items.length;if(opts.sortOrders.length&&this._checkPaths(this._sorters,"sorting",items)){items=items.sort(this._multiSort.bind(this))}const start=opts.page*opts.pageSize,end=start+opts.pageSize,slice=items.slice(start,end);cb(slice,items.length)}/**
   * Check array of filters/sorters for paths validity, console.warn invalid items
   * @param {!Array<!GridFilter | !GridSorter>} arrayToCheck The array of filters/sorters to check
   * @param {string} action The name of action to include in warning (filtering, sorting)
   * @param {!Array<!GridItem>} items
   * @protected
   */_checkPaths(arrayToCheck,action,items){if(!items.length){return(/* ignoreName */!1/* skipSlots */ /* skipSlots */)}let result=!0;for(var i in arrayToCheck){const path=arrayToCheck[i].path;// skip simple paths
if(!path||-1===path.indexOf(".")){continue}const parentProperty=path.replace(/\.[^\.]*$/,"");// a.b.c -> a.b
if(_polymerLegacy.Base.get(parentProperty,items[0])===void 0){console.warn(`Path "${path}" used for ${action} does not exist in all of the items, ${action} is disabled.`);result=!1}}return result}/**
   * @param {unknown} a
   * @param {unknown} b
   * @return {number}
   * @protected
   */_multiSort(a,b){return this._sorters.map(sort=>{if("asc"===sort.direction){return this._compare(_polymerLegacy.Base.get(sort.path,a),_polymerLegacy.Base.get(sort.path,b))}else if("desc"===sort.direction){return this._compare(_polymerLegacy.Base.get(sort.path,b),_polymerLegacy.Base.get(sort.path,a))}return 0}).reduce((p,n)=>{return p?p:n},0)}/**
   * @param {unknown} value
   * @return {string}
   * @protected
   */_normalizeEmptyValue(value){if(0<=[void 0,null].indexOf(value)){return""}else if(isNaN(value)){return value.toString()}else{return value}}/**
   * @param {unknown} a
   * @param {unknown} b
   * @return {number}
   * @protected
   */_compare(a,b){a=this._normalizeEmptyValue(a);b=this._normalizeEmptyValue(b);if(a<b){return-1}if(a>b){return 1}return 0}/**
   * @param {!Array<!GridItem>} items
   * @return {!Array<!GridItem>}
   * @protected
   */_filter(items){return items.filter((item,index)=>{return 0===this._filters.filter(filter=>{const value=this._normalizeEmptyValue(_polymerLegacy.Base.get(filter.path,item)),filterValueLowercase=this._normalizeEmptyValue(filter.value).toString().toLowerCase();return-1===value.toString().toLowerCase().indexOf(filterValueLowercase)}).length})}};_exports.ArrayDataProviderMixin=ArrayDataProviderMixin});