define(["exports"],function(_exports){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
});_exports.ItemMixin=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * A mixin providing `focused`, `focus-ring`, `active`, `disabled` and `selected`.
 *
 * `focused`, `active` and `focus-ring` are set as only as attributes.
 * @polymerMixin
 */const ItemMixin=superClass=>class VaadinItemMixin extends superClass{static get properties(){return{/**
       * Used for mixin detection because `instanceof` does not work with mixins.
       * e.g. in VaadinListMixin it filters items by using the
       * `element._hasVaadinItemMixin` condition.
       * @type {boolean}
       */_hasVaadinItemMixin:{value:!0},/**
       * If true, the user cannot interact with this element.
       * @type {boolean}
       */disabled:{type:Boolean,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */,observer:"_disabledChanged",reflectToAttribute:!0},/**
       * If true, the item is in selected state.
       * @type {boolean}
       */selected:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_selectedChanged"},/** @private */_value:String}}/**
   * @return {string}
   */get value(){return this._value!==void 0?this._value:this.textContent.trim()}/**
   * @param {string} value
   */set value(value){this._value=value}/** @protected */ready(){super.ready();const attrValue=this.getAttribute("value");if(null!==attrValue){this.value=attrValue}this.addEventListener("focus",e=>this._setFocused(!0),!0);this.addEventListener("blur",e=>this._setFocused(!1),!0);this.addEventListener("mousedown",e=>{this._setActive(this._mousedown=!0);const mouseUpListener=()=>{this._setActive(this._mousedown=!1);document.removeEventListener("mouseup",mouseUpListener)};document.addEventListener("mouseup",mouseUpListener)});this.addEventListener("keydown",e=>this._onKeydown(e));this.addEventListener("keyup",e=>this._onKeyup(e))}/** @protected */disconnectedCallback(){super.disconnectedCallback();// in Firefox and Safari, blur does not fire on the element when it is removed,
// especially between keydown and keyup events, being active at the same time.
// reproducible in `<vaadin-select>` when closing overlay on select.
if(this.hasAttribute("active")){this._setFocused(!1)}}/** @private */_selectedChanged(selected){this.setAttribute("aria-selected",selected)}/** @private */_disabledChanged(disabled){if(disabled){this.selected=!1;this.setAttribute("aria-disabled","true");this.blur()}else{this.removeAttribute("aria-disabled")}}/**
   * @param {boolean} focused
   * @protected
   */_setFocused(focused){if(focused){this.setAttribute("focused","");if(!this._mousedown){this.setAttribute("focus-ring","")}}else{this.removeAttribute("focused");this.removeAttribute("focus-ring");this._setActive(!1)}}/**
   * @param {boolean} active
   * @protected
   */_setActive(active){if(active){this.setAttribute("active","")}else{this.removeAttribute("active")}}/**
   * @param {!KeyboardEvent} event
   * @protected
   */_onKeydown(event){if(/^( |SpaceBar|Enter)$/.test(event.key)&&!event.defaultPrevented){event.preventDefault();this._setActive(!0)}}/**
   * @param {!KeyboardEvent} event
   * @protected
   */_onKeyup(event){if(this.hasAttribute("active")){this._setActive(!1);this.click()}}};_exports.ItemMixin=ItemMixin});