define(["exports","../../../@polymer/polymer/polymer-element.js","../../vaadin-themable-mixin/vaadin-themable-mixin.js","../node_modules/@vaadin/vaadin-list-mixin/vaadin-multi-select-list-mixin.js","../../vaadin-element-mixin/vaadin-element-mixin.js","../../../@polymer/polymer/lib/utils/html-tag.js"],function(_exports,_polymerElement,_vaadinThemableMixin,_vaadinMultiSelectListMixin,_vaadinElementMixin,_htmlTag){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
});_exports.ListBoxElement=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * `<vaadin-list-box>` is a Web Component for creating menus.
 *
 * ```
 *   <vaadin-list-box selected="2">
 *     <vaadin-item>Item 1</vaadin-item>
 *     <vaadin-item>Item 2</vaadin-item>
 *     <vaadin-item>Item 3</vaadin-item>
 *     <vaadin-item>Item 4</vaadin-item>
 *   </vaadin-list-box>
 * ```
 *
 * ### Styling
 *
 * The following shadow DOM parts are available for styling:
 *
 * Part name         | Description
 * ------------------|------------------------
 * `items`           | The items container
 *
 * See [ThemableMixin – how to apply styles for shadow parts](https://github.com/vaadin/vaadin-themable-mixin/wiki)
 *
 * @extends PolymerElement
 * @mixes MultiSelectListMixin
 * @mixes ThemableMixin
 * @mixes ElementMixin
 * @demo demo/index.html
 */class ListBoxElement extends(0,_vaadinElementMixin.ElementMixin)((0,_vaadinMultiSelectListMixin.MultiSelectListMixin)((0,_vaadinThemableMixin.ThemableMixin)(_polymerElement.PolymerElement))){static get template(){return _htmlTag.html`
    <style>
      :host {
        display: flex;
      }

      :host([hidden]) {
        display: none !important;
      }

      [part="items"] {
        height: 100%;
        width: 100%;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
      }
    </style>
    <div part="items">
      <slot></slot>
    </div>
`}static get is(){return"vaadin-list-box"}static get version(){return"1.4.0"}static get properties(){return{// We don't need to define this property since super default is vertical,
// but we don't want it to be modified, or be shown in the API docs.
/** @private */orientation:{readOnly:!0}}}constructor(){super();/**
     * @type {Element | null}
     * @protected
     */this.focused}ready(){super.ready();this.setAttribute("role","list");setTimeout(this._checkImport.bind(this),2e3)}/**
   * @return {!HTMLElement}
   * @protected
   */get _scrollerElement(){return this.shadowRoot.querySelector("[part=\"items\"]")}/** @private */_checkImport(){var item=this.querySelector("vaadin-item");if(item&&!(item instanceof _polymerElement.PolymerElement)){console.warn(`Make sure you have imported the vaadin-item element.`)}}}_exports.ListBoxElement=ListBoxElement;customElements.define(ListBoxElement.is,ListBoxElement)});