define(["require","../node_modules/@polymer/polymer/polymer-element.js","../node_modules/@polymer/polymer/lib/utils/settings.js","../node_modules/@polymer/polymer/lib/legacy/class.js","../node_modules/@polymer/app-localize-behavior/app-localize-behavior.js","../node_modules/@polymer/app-layout/app-drawer/app-drawer.js","../node_modules/@polymer/app-layout/app-drawer-layout/app-drawer-layout.js","../node_modules/@polymer/app-layout/app-header/app-header.js","../node_modules/@polymer/app-layout/app-header-layout/app-header-layout.js","../node_modules/@polymer/app-layout/app-scroll-effects/app-scroll-effects.js","../node_modules/@polymer/app-layout/app-toolbar/app-toolbar.js","../node_modules/@polymer/app-route/app-location.js","../node_modules/@polymer/app-route/app-route.js","../node_modules/@polymer/iron-pages/iron-pages.js","../node_modules/@polymer/iron-selector/iron-selector.js","../node_modules/@polymer/iron-localstorage/iron-localstorage.js","../node_modules/@polymer/paper-icon-button/paper-icon-button.js","../node_modules/@polymer/paper-menu-button/paper-menu-button.js","../node_modules/@polymer/paper-item/paper-item.js","../node_modules/@polymer/paper-dropdown-menu/paper-dropdown-menu.js","../node_modules/@polymer/paper-listbox/paper-listbox.js","../node_modules/@polymer/paper-input/paper-input.js","../node_modules/@polymer/iron-icon/iron-icon.js","../node_modules/@polymer/iron-icons/iron-icons.js","../node_modules/@polymer/iron-form/iron-form.js","./my-icons.js","./token-ajax.js","./toast-feedback.js","./login-view.js","./user-options-menu.js","./shared-styles.js","./common/breadcrumb.js"],function(_require,_polymerElement,_settings,_class,_appLocalizeBehavior,_appDrawer,_appDrawerLayout,_appHeader,_appHeaderLayout,_appScrollEffects,_appToolbar,_appLocation,_appRoute,_ironPages,_ironSelector,_ironLocalstorage,_paperIconButton,_paperMenuButton,_paperItem,_paperDropdownMenu,_paperListbox,_paperInput,_ironIcon,_ironIcons,_ironForm,_myIcons,_tokenAjax,_toastFeedback,_loginView,_userOptionsMenu,_sharedStyles,_breadcrumb){"use strict";_require=babelHelpers.interopRequireWildcard(_require);/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */ // Gesture events like tap and track generated from touch will not be
// preventable, allowing for better scrolling performance.
(0,_settings.setPassiveTouchGestures)(// unflatten -> {"es": {"hi": "hola"}}
// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
// merge so existing resources won't be clobbered
);// Set Polymer's root path to the same value we passed to our service worker
// in `index.html`.
(0,_settings.setRootPath)(MyAppGlobals.rootPath);class MyApp extends(0,_class.mixinBehaviors)([_appLocalizeBehavior.AppLocalizeBehavior],_polymerElement.PolymerElement){static get template(){return _polymerElement.html`
      <style include="shared-styles">
        :host {
           display: block;
        };
        app-drawer-layout:not([narrow]) [drawer-toggle] {
          display: none;
        };
        app-toolbar {
          color: #fff;
          background-color: var(--egeria-primary-color);
        };
        app-header paper-icon-button {
          --paper-icon-button-ink-color: var(--egeria-button-ink-color);
          --iron-icon-fill-color: var(--egeria-button-ink-color);
        };
        .drawer-list a {
          display: block;
          padding: 0 16px;
          text-decoration: none;
          color: var( --egeria-secondary-color );
          line-height: 40px;
        };
        .drawer-list div:not(.iron-selected) a:hover{
            background-color: var(--app-background-color);
        }
        }
        .drawer-list div.iron-selected a {
            color: white;
        }
        .drawer-list-selected,
        .drawer-list div.iron-selected {
          font-weight: bold;
          color: var(--egeria-secondary-color);
          background-color: var(--egeria-primary-color);
        };

        paper-input.custom:hover {
          border: 1px solid #29B6F6;
        };
        paper-input.custom {
          margin-bottom: 14px;
          --primary-text-color: #01579B;
          --paper-input-container-color: black;
          --paper-input-container-focus-color: black;
          --paper-input-container-invalid-color: black;
          border: 1px solid #BDBDBD;
          border-radius: 5px;

          /* Reset some defaults */
          --paper-input-container: { padding: 0;};
          --paper-input-container-underline: { display: none; height: 0;};
          --paper-input-container-underline-focus: { display: none; };

          /* New custom styles */
          --paper-input-container-input: {
            box-sizing: border-box;
            font-size: inherit;
            padding: 4px;
          };
          --paper-input-container-input-focus: {
            background: rgba(0, 0, 0, 0.1);
          };
          --paper-input-container-input-invalid: {
            background: rgba(255, 0, 0, 0.3);
          };
          --paper-input-container-label: {
            top: -8px;
            left: 4px;
            background: white;
            padding: 2px;
            font-weight: bold;
          };
          --paper-input-container-label-floating: {
            width: auto;
         };
         .yellow-button {
            text-transform: none;
            color: #eeff41;
          }
         
      </style>
     
      <iron-localstorage name="my-app-storage" value="{{token}}"></iron-localstorage>

      <app-location route="{{route}}" url-space-regex="^[[rootPath]]" use-hash-as-path query-params="{{queryParams}}"></app-location>

      <app-route route="{{route}}" pattern="/:page" data="{{routeData}}" tail="{{tail}}"></app-route>
        
        <toast-feedback></toast-feedback> 
        
        <paper-dialog id="modal" modal>
          <p>[[modalMessage]]</p>
          <div class="buttons">
            <paper-button dialog-confirm autofocus>OK</paper-button>
          </div>
        </paper-dialog>
        
        <template is="dom-if" if="[[!token]]"  restamp="true">
            <login-view id="loginView" token="{{token}}"></login-view>
        </template>
      
        <template is="dom-if" if="[[token]]"  restamp="true">
            
            <app-drawer-layout id="drawerLayout" flex forceNarrow  narrow="{{narrow}}" fullbleed="">
                <app-drawer id="drawer" slot="drawer"  swipe-open="[[narrow]]">
                  <div id="logo"></div>
                  <iron-selector selected="[[page]]" attr-for-selected="name"
                        class="drawer-list" swlectedClass="drawer-list-selected" role="navigation">
                    <div name="asset-catalog" language="[[language]]"><a href="[[rootPath]]#/asset-catalog/search">Asset Catalog</a></div>
                    <div name="glossary" language="[[language]]"><a href="[[rootPath]]#/glossary">Glossary View</a></div>
                    <div name="asset-lineage"><a href="[[rootPath]]#/asset-lineage">Asset Lineage</a></div>
                    <div name="type-explorer"><a href="[[rootPath]]#/type-explorer">Type Explorer</a></div>
                    <div name="repository-explorer"><a href="[[rootPath]]#/repository-explorer">Repository Explorer</a></div>
                    <div name="about"><a href="[[rootPath]]#/about">About</a></div>
                  </iron-selector>

                </app-drawer>
    
                <!-- Main content-->
                <app-header-layout>    
                  <app-header slot="header" condenses fixed effects="waterfall">
                    <app-toolbar>
                      <paper-icon-button on-tap="_toggleDrawer" id="toggle" icon="menu"></paper-icon-button>
                      <template is="dom-if" if="[[narrow]]" >
                        <img src="./images/logo-white.png" style="vertical-align: middle; max-height: 80%; margin-left: 15pt; margin-right: 15pt; display: inline-block; "/>
                      </template>
                      <div>
                        <template is="dom-if" if="[[!narrow]]" >
                            Open Metadata -
                        </template>
                        [[page]]
                      </div>

                      <div main-title="">

                      </div>
                      <div style="float: right"><user-options></user-options></div>
                    </app-toolbar>
                    <div class="breadcrumb">
                        <bread-crumb id="breadcrumb" items="[[crumbs]]"></bread-crumb>
                    </div>
                  </app-header>
                  
                  <iron-pages selected="[[page]]" attr-for-selected="name" role="main">
                    <asset-view language="[[language]]" name="asset-catalog" route="[[tail]]"></asset-view>
                    <glossary-view language="[[language]]" name="glossary" route="[[tail]]"></glossary-view>
                    <about-view language="[[language]]" name="about"></about-view>
                    <asset-lineage-view language="[[language]]" name="asset-lineage"  route="[[tail]]"></asset-lineage-view>
                    <type-explorer-view language="[[language]]" name="type-explorer"></type-explorer-view>
                    <repository-explorer-view language="[[language]]" name="repository-explorer"  route="[[tail]]"></repository-explorer-view>
                    <my-view404 name="view404"></my-view404>
                  </iron-pages>

                </app-header-layout>
            </app-drawer-layout>

         </template>
    `}static get properties(){return{language:{value:"en"},page:{type:String,reflectToAttribute:!0,observer:"_pageChanged"},token:{type:Object,notify:!0},routeData:Object,pages:{type:Array,value:["asset-catalog","asset-lineage","type-explorer","repository-explorer","about","glossary"]},feedback:{type:Object,notify:!0,observer:"_feedbackChanged"},crumbs:{type:Array},allCrumbs:{type:Object,value:{home:{label:"Home",href:"/#"},"asset-catalog":{label:"Asset Catalog",href:"/asset-catalog/search"},glossary:{label:"Glossary",href:"/glossary"},"asset-lineage":{label:"Asset Lineage",href:"/asset-lineage"},"type-explorer":{label:"Type Explorer",href:"/type-explorer"},"repository-explorer":{label:"Repository Explorer",href:"/repository-explorer"},ultimateSource:{label:"Ultimate Source",href:"/ultimateSource"},ultimateDestination:{label:"Ultimate Destination",href:"/ultimateDestination"},endToEnd:{label:"End To End Lineage",href:"/endToEnd"},sourceAndDestination:{label:"Source and Destination",href:"/sourceAndDestination"},glossaryLineage:{label:"Glossary Lineage",href:"/glossaryLineage"},about:{label:"About",href:"/about"}}}}}static get observers(){return["_routePageChanged(routeData.page)","_updateBreadcrumb(routeData.page)"]}ready(){super.ready();this.addEventListener("logout",this._onLogout);this.addEventListener("open-page",this._onPageChanged);this.addEventListener("show-modal",this._onShowModal);this.addEventListener("set-title",this._onSetTitle);this.addEventListener("push-crumb",this._onPushCrumb)}_getDrawer(){var dL=this.shadowRoot.querySelector("#drawerLayout");if(dL){return dL.drawer}return}_toggleDrawer(){var dL=this.shadowRoot.querySelector("#drawerLayout");if(dL.forceNarrow||!dL.narrow){dL.forceNarrow=!dL.forceNarrow}else{dL.drawer.toggle()}}_onPushCrumb(event){var crumbs=[].concat(this.crumbs);crumbs.push(event.detail);this.crumbs=crumbs}_onShowModal(event){this.modalMessage=event.detail.message;this.$.modal.open()}_updateBreadcrumb(page){if(!page)return;var crumbs=[],allCrumbs=new Map(Object.entries(this.allCrumbs));crumbs.push(allCrumbs.get("home"));var crumb=allCrumbs.get(page);if(crumb){crumbs.push(crumb)}this.crumbs=crumbs}_routePageChanged(page){// Show the corresponding page according to the route.
//
// If no page was found in the route data, page will be an empty string.
// Show 'asset-search' in that case. And if the page doesn't exist, show 'view404'.
if(!page){this.page="asset-catalog"}else if(-1!==this.pages.indexOf(page)){this.page=page}else{this.page="view404"}// Close a non-persistent drawer when the page & route are changed.
var drawer=this._getDrawer();if("login"!=this.page&&drawer&&!drawer.persistent){this._getDrawer().close()}}_onPageChanged(event){this.page=event.detail.page;this.subview=event.detail.subview;this.guid=event.detail.guid}_onLogout(event){//TODO invalidate token from server
console.log("LOGOUT: removing token...");this.token=null}_hasToken(){return"undefined"!==typeof this.token&&null!=this.token}_pageChanged(page){// Import the page component on demand.
//
// Note: `polymer build` doesn't like string concatenation in the import
// statement, so break it up.
console.log(page);switch(page){case"asset-lineage":new Promise((res,rej)=>_require.default(["./asset-lineage/asset-lineage-view.js"],res,rej));break;case"type-explorer":new Promise((res,rej)=>_require.default(["./type-explorer/type-explorer-view.js"],res,rej));break;case"repository-explorer":new Promise((res,rej)=>_require.default(["./repository-explorer/repository-explorer-view.js"],res,rej));break;case"asset-catalog":new Promise((res,rej)=>_require.default(["./asset-catalog/asset-catalog-view.js"],res,rej));break;case"glossary":new Promise((res,rej)=>_require.default(["./glossary/glossary-view.js"],res,rej));break;case"about":new Promise((res,rej)=>_require.default(["./about-view.js"],res,rej));break;case"view404":new Promise((res,rej)=>_require.default(["./error404.js"],res,rej));break;}this._updateBreadcrumb(this.page)}attached(){this.loadResources(// The specified file only contains the flattened translations for that language:
"locales/en.json",//e.g. for es {"hi": "hola"}
"en",!0)}}window.customElements.define("my-app",MyApp)});