define(["../../node_modules/@polymer/polymer/lib/legacy/class.js","../../node_modules/@polymer/app-localize-behavior/app-localize-behavior.js","../../node_modules/@polymer/polymer/polymer-element.js","../shared-styles.js","../token-ajax.js"],function(_class,_appLocalizeBehavior,_polymerElement,_sharedStyles,_tokenAjax){"use strict";/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */ /**
*
* DetailsPanel implements a web component for presentation of details of the focus or view type
*
* It should present to the user a summary of the key characteristics of the focus or view type. This includes:
*
*  For entity types:
*    * type name
*    * description
*    * attributes (listing names of types)
*    * relationships (listing attribute names and types and providing a link to the relationship details)
*    * classifications (listing attribute names and types and providing a link to the classification details)
*
*  For relationship types:
*    * type name
*    * description
*    * attributes (listing names of types)
*    * ends (listing entity types and providing a link to the entity details)
*
*  For classification types:
*
*    * type name
*    * description
*    * attributes (listing names of types)
*    * valid entity types (listing entity types and providing a link to the entity details)
*
* The details panel reacts to events that indicate a change of focus (an entity type's details should be shown)
* or a change of view (a relationship or classification details should be shown).
* Because the details panel also includes links to entity, relationship and classification types (as outlined above)
* the details panel also generates events requesting changeFocus or changeView.
*
* When the UI is first loaded there will be no type information, and until a focus or view type is selected there is
* no particular type to display - therefore following initial load and until a focus/view type is selected, the details
* panel will be blank.
*
*/class DetailsPanel extends _polymerElement.PolymerElement{static get template(){return _polymerElement.html`


            <style include="shared-styles">

                * { font-size: 12px ; font-family: sans-serif; }

                .linkable {
                    background-color: #CCCCCC;
                    color: black;
                    cursor: pointer;
                    padding: 0px;
                    width: 200px;
                    border: none;
                    text-align: left;
                    outline: none;
                    font-size: 12px;
                }

                .collapsible {
                    background-color: #CCCCCC;
                    color: black;
                    cursor: pointer;
                    padding: 5px;
                    width: 300px;
                    border: none;
                    text-align: left;
                    outline: none;
                    font-size: 12px;
                }

                .content {
                    padding: 10px 18px;
                    display: none;
                    overflow: hidden;
                    background-color: #CCCCCC;
                }

                </style>

                <body>

                    <div id="detailsDiv" style="padding:20px;">
                        Type details will be displayed here when a type is selected
                    </div>
              </body>

        `}static get properties(){return{// Reference to TypeManager element which this DetailsPanel depends on.
// The TypeManager is created in the DOM of the parent and is passed in
// once we are all initialised. This avoids any direct dependency from DetailsPanel
// on TypeManager.
typeManager:Object,// The details panel includes links back tot he current focus type, which will always
// be an Entity category type. Whenever a focusChanged event is received it remembers
// new focusType. This creates a cached copy of the focus type name so that the details
// panel component does not need to keep asking the TypeManager.
focusType:String}}/*
     * Element is ready
     */ready(){// Call super.ready() first to initialise node hash...
super.ready();this.focusType=void 0}// Inter-component event handlers
/*
     *  Inbound event: types-loaded
     */inEvtTypesLoaded(e){// New type information is available - clear the cached focus type and the details...
this.focusType=void 0;this.clearDetails()}/*
     *  Inbound event: focus-changed
     */inEvtFocusChanged(focusType){this.focusType=focusType;this.clearDetails();this.displayEntityDetails(focusType)}/*
     *  Inbound event: view-changed
     */inEvtViewChanged(category,viewType){this.clearDetails();if("Relationship"===category){this.displayRelationshipDetails(viewType)}else if("Classification"===category){this.displayClassificationDetails(viewType)}else{this.displayEnumDetails(viewType)}}/*
      *  Outbound event: change-focus
      */outEvtChangeFocus(typeName){var customEvent=new CustomEvent("change-focus",{bubbles:!0/* ignoreName */ /* skipSlots */,composed:!0,detail:{source:"details-panel",focusType:typeName}});this.dispatchEvent(customEvent)}/*
      *  Outbound event: change-view
      */outEvtChangeView(category,typeName){var customEvent=new CustomEvent("change-view",{bubbles:!0,composed:!0,detail:{source:"details-panel",viewCategory:category,viewType:typeName}});this.dispatchEvent(customEvent)}// Component logic
// Clear down the details panel
// In the UI, once a type has become the focus or view type there will always be a type selected,
// so there is no need to reinstate the introductory text about selecting a type - it is sufficient
// to simply clear the details text.
clearDetails(){var details=this.$.detailsDiv;details.innerHTML=""}// ENTITY DETAILS
displayEntityDetails(typeName){var typeCategory="Entity",details=this.$.detailsDiv;details.innerHTML="";// Add type header
var boldnode=document.createElement("strong"),textnode=document.createTextNode(typeCategory+" type: "+typeName);boldnode.appendChild(textnode);var paranode=document.createElement("p");paranode.appendChild(boldnode);details.appendChild(paranode);this.entityAddDescription(details,typeName);this.entityAddAttributes(details,typeName);this.entityAddRelationships(details,typeName);this.entityAddClassifications(details,typeName)}entityAddDescription(details,typeName){var eex=this.typeManager.getEntity(typeName),description=eex.entityDef.description,textnode=document.createTextNode(description),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}entityAddAttributes(details,typeName){var textnode=document.createTextNode("Attributes:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var eex=this.typeManager.getEntity(typeName),attributeEntries={},inheritedProps=eex.inheritedAttributes;if(inheritedProps!==void 0){var inheritedPropsSorted=inheritedProps.sort();inheritedPropsSorted.forEach(inheritedProp=>{attributeEntries[inheritedProp.attributeName]={};attributeEntries[inheritedProp.attributeName].inherited=!0;attributeEntries[inheritedProp.attributeName].attributeTypeName=inheritedProp.attributeType.name})}// Local attributes
var localProps=eex.entityDef.propertiesDefinition;if(localProps!==void 0){var localPropsSorted=localProps.sort();localPropsSorted.forEach(localProp=>{attributeEntries[localProp.attributeName]={};attributeEntries[localProp.attributeName].inherited=/* ignoreName */!1/* skipSlots */ /* skipSlots */;attributeEntries[localProp.attributeName].attributeTypeName=localProp.attributeType.name})}var attributeNamesUnsorted=Object.keys(attributeEntries),attributeNamesSorted=attributeNamesUnsorted.sort();attributeNamesSorted.forEach(attrName=>{var itemnode=document.createElement("li"),attrNameNode=document.createTextNode(attrName);if(!0===attributeEntries[attrName].inherited){// display in italics
var element=document.createElement("i");itemnode.appendChild(element);element.appendChild(attrNameNode)}else{itemnode.appendChild(attrNameNode)}var separatorNode=document.createTextNode(" : ");itemnode.appendChild(separatorNode);// Look up the attributeTypeName in the enums map - if it is found display as a link, otherwise just the primitive type name
var attrTypeName=attributeEntries[attrName].attributeTypeName;if(this.typeManager.getEnum(attrTypeName)!==void 0){this.appendEnumLink(itemnode,attrTypeName)}else{var attrTypeNode=document.createTextNode(attrTypeName);itemnode.appendChild(attrTypeNode)}listnode.appendChild(itemnode)})}entityAddRelationships(details,typeName){var textnode=document.createTextNode("Relationships:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var eex=this.typeManager.getEntity(typeName),relationshipEntries={},inheritedRelNames=eex.inheritedRelationshipNames;// Present a list of all relationships in alpha order, with inherited relationships in italics.
if(inheritedRelNames!==void 0){inheritedRelNames.forEach(inheritedRelName=>{relationshipEntries[inheritedRelName]={};relationshipEntries[inheritedRelName].inherited=!0})}// Local relationships
var relationshipNames=eex.relationshipNames;if(relationshipNames!==void 0){relationshipNamesSorted=relationshipNames.sort();relationshipNamesSorted.forEach(relationshipName=>{relationshipEntries[relationshipName]={};relationshipEntries[relationshipName].inherited=!1})}var relationshipNamesUnsorted=Object.keys(relationshipEntries),relationshipNamesSorted=relationshipNamesUnsorted.sort();relationshipNamesSorted.forEach(relName=>{var itemnode=document.createElement("li");this.appendRelationshipLink(itemnode,relName,relationshipEntries[relName].inherited);listnode.appendChild(itemnode)})}entityAddClassifications(details,typeName){var textnode=document.createTextNode("Classifications:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var eex=this.typeManager.getEntity(typeName),classificationEntries={},inheritedClsNames=eex.inheritedClassificationNames;// Present a list of all classifications in alpha order, with inherited classifications in italics.
if(inheritedClsNames!==void 0){inheritedClsNames.forEach(inheritedClsName=>{classificationEntries[inheritedClsName]={};classificationEntries[inheritedClsName].inherited=!0})}// Local classifications
var classificationNames=eex.classificationNames;if(classificationNames!==void 0){classificationNamesSorted=classificationNames.sort();classificationNamesSorted.forEach(classificationName=>{classificationEntries[classificationName]={};classificationEntries[classificationName].inherited=!1})}var classificationNamesUnsorted=Object.keys(classificationEntries),classificationNamesSorted=classificationNamesUnsorted.sort();classificationNamesSorted.forEach(clsName=>{var itemnode=document.createElement("li");this.appendClassificationLink(itemnode,clsName,!0===classificationEntries[clsName].inherited);listnode.appendChild(itemnode)})}// RELATIONSHIP DETAILS
/*
     * The user may have already selected a focus type - or not.
     * If so, include a back link to the focus type; if not then just present the relationship details (no back link)
     *
     */displayRelationshipDetails(typeName){var typeCategory="Relationship",details=this.$.detailsDiv;details.innerHTML="";if(this.focusType!==void 0){var para=document.createElement("div");para.innerHTML="Return to focus entity type: ";details.append(para);var button=document.createElement("button");button.className="linkable";button.innerHTML=this.focusType;button.addEventListener("click",()=>this.entityLinkHandler(this.focusType));para.append(button)}// Add type header
var boldnode=document.createElement("strong"),textnode=document.createTextNode(typeCategory+" type: "+typeName);boldnode.appendChild(textnode);var paranode=document.createElement("p");paranode.appendChild(boldnode);details.appendChild(paranode);this.relationshipAddDescription(details,typeName);this.relationshipAddAttributes(details,typeName);this.relationshipAddEntities(details,typeName)}relationshipAddDescription(details,typeName){var rex=this.typeManager.getRelationship(typeName),description=rex.relationshipDef.description,textnode=document.createTextNode(description),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}relationshipAddAttributes(details,typeName){var textnode=document.createTextNode("Attributes:");details.appendChild(textnode);var rex=this.typeManager.getRelationship(typeName),attributeEntries={},localProps=rex.relationshipDef.propertiesDefinition;if(localProps!==void 0){var localPropsSorted=localProps.sort();localPropsSorted.forEach(localProp=>{attributeEntries[localProp.attributeName]={};attributeEntries[localProp.attributeName].inherited=!1;attributeEntries[localProp.attributeName].attributeTypeName=localProp.attributeType.name})}var attributeNamesUnsorted=Object.keys(attributeEntries);if(0<attributeNamesUnsorted.length){var listnode=document.createElement("ul");details.appendChild(listnode);var attributeNamesSorted=attributeNamesUnsorted.sort();attributeNamesSorted.forEach(attrName=>{var itemnode=document.createElement("li"),attrNameNode=document.createTextNode(attrName);if(!0===attributeEntries[attrName].inherited){// display in italics
var element=document.createElement("i");itemnode.appendChild(element);element.appendChild(attrNameNode)}else{itemnode.appendChild(attrNameNode)}var separatorNode=document.createTextNode(" : ");itemnode.appendChild(separatorNode);var attrTypeName=attributeEntries[attrName].attributeTypeName;if(this.typeManager.getEnum(attrTypeName)!==void 0){this.appendEnumLink(itemnode,attrTypeName)}else{var attrTypeNode=document.createTextNode(attrTypeName);itemnode.appendChild(attrTypeNode)}listnode.appendChild(itemnode)})}else{var nonenode=document.createTextNode(" <none>");details.appendChild(nonenode)}}relationshipAddEntities(details,typeName){var rex=this.typeManager.getRelationship(typeName),textnode=document.createTextNode("Entity @ end1:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);// Display the type for end1
var end1=rex.relationshipDef.endDef1;if(end1!==void 0){// Type name
var entityTypeName=end1.entityType.name,typenode=document.createElement("li");this.appendEntityLink(typenode,entityTypeName);listnode.appendChild(typenode);// Display the cardinality for end1
var attributeCardinality=end1.attributeCardinality,cardnode=document.createElement("li"),cardtext=document.createTextNode("Cardinality: "+attributeCardinality);cardnode.appendChild(cardtext);listnode.appendChild(cardnode);// Display the attribute name for end1
var attributeName=end1.attributeName,namenode=document.createElement("li"),nametext=document.createTextNode("Attribute Name: "+attributeName);namenode.appendChild(nametext);listnode.appendChild(namenode)}var textnode=document.createTextNode("Entity @ end2:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);// Display the type for end2
var end2=rex.relationshipDef.endDef2;if(end2!==void 0){// Type name
var entityTypeName=end2.entityType.name,typenode=document.createElement("li");this.appendEntityLink(typenode,entityTypeName);listnode.appendChild(typenode);// Display the cardinality for end2
var attributeCardinality=end2.attributeCardinality,cardnode=document.createElement("li"),cardtext=document.createTextNode("Cardinality: "+attributeCardinality);cardnode.appendChild(cardtext);listnode.appendChild(cardnode);// Display the attribute name for end2
var attributeName=end2.attributeName,namenode=document.createElement("li"),nametext=document.createTextNode("Attribute Name: "+attributeName);namenode.appendChild(nametext);listnode.appendChild(namenode)}}// CLASSIFICATION DETAILS
/*
     * The user may have already selected a focus type - or not.
     * If so, include a back link to the focus type; if not then just present the relationship details (no back link)
     *
     */displayClassificationDetails(typeName){var typeCategory="Classification",details=this.$.detailsDiv;details.innerHTML="";if(this.focusType!==void 0){var para=document.createElement("div");para.innerHTML="Return to focus entity type: ";details.append(para);var button=document.createElement("button");button.className="linkable";button.innerHTML=this.focusType;button.addEventListener("click",()=>this.entityLinkHandler(this.focusType));para.append(button)}var boldnode=document.createElement("strong"),textnode=document.createTextNode(typeCategory+" type: "+typeName);boldnode.appendChild(textnode);var paranode=document.createElement("p");paranode.appendChild(boldnode);details.appendChild(paranode);this.classificationAddDescription(details,typeName);this.classificationAddAttributes(details,typeName);this.classificationAddEntities(details,typeName)}classificationAddDescription(details,typeName){var cex=this.typeManager.getClassification(typeName),description=cex.classificationDef.description,textnode=document.createTextNode(description),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}classificationAddAttributes(details,typeName){var textnode=document.createTextNode("Attributes:");details.appendChild(textnode);var cex=this.typeManager.getClassification(typeName),attributeEntries={},localProps=cex.classificationDef.propertiesDefinition;if(localProps!==void 0){var localPropsSorted=localProps.sort();localPropsSorted.forEach(localProp=>{attributeEntries[localProp.attributeName]={};attributeEntries[localProp.attributeName].inherited=!1;attributeEntries[localProp.attributeName].attributeTypeName=localProp.attributeType.name})}var attributeNamesUnsorted=Object.keys(attributeEntries);if(0<attributeNamesUnsorted.length){var listnode=document.createElement("ul");details.appendChild(listnode);var attributeNamesSorted=attributeNamesUnsorted.sort();attributeNamesSorted.forEach(attrName=>{var itemnode=document.createElement("li"),attrNameNode=document.createTextNode(attrName);if(!0===attributeEntries[attrName].inherited){// display in italics
var element=document.createElement("i");itemnode.appendChild(element);element.appendChild(attrNameNode)}else{itemnode.appendChild(attrNameNode)}var separatorNode=document.createTextNode(" : ");itemnode.appendChild(separatorNode);var attrTypeName=attributeEntries[attrName].attributeTypeName;if(this.typeManager.getEnum(attrTypeName)!==void 0){this.appendEnumLink(itemnode,attrTypeName)}else{var attrTypeNode=document.createTextNode(attrTypeName);itemnode.appendChild(attrTypeNode)}listnode.appendChild(itemnode)})}else{var nonenode=document.createTextNode(" <none>");details.appendChild(nonenode)}}classificationAddEntities(details,typeName){var textnode=document.createTextNode("Valid entity types:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var listnode=document.createElement("ul");details.appendChild(listnode);var validEntityEntries=[],cex=this.typeManager.getClassification(typeName),validEntities=cex.classificationDef.validEntityDefs;if(validEntities!==void 0){validEntities.forEach(validEntity=>{validEntityEntries.push(validEntity.name)})}var validEntityEntriesSorted=validEntityEntries.sort();validEntityEntriesSorted.forEach(validEntity=>{var itemnode=document.createElement("li");this.appendEntityLink(itemnode,validEntity);listnode.appendChild(itemnode)})}// Enum details are displayed in the detail area with a back button to return to the current focus type, if any
displayEnumDetails(typeName){var typeCategory="Enum",details=this.$.detailsDiv;details.innerHTML="";if(this.focusType!==void 0){var para=document.createElement("div");para.innerHTML="Return to focus entity type: ";details.append(para);var button=document.createElement("button");button.className="linkable";button.innerHTML=this.focusType;button.addEventListener("click",()=>this.entityLinkHandler(this.focusType));para.append(button)}var textnode=document.createTextNode("Enum Type: "+typeName),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);this.enumAddDescription(details,typeName);this.enumAddValues(details,typeName)}enumAddDescription(details,typeName){var textnode=document.createTextNode("Description:"),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode);var eex=this.typeManager.getEnum(typeName),description=eex.description,textnode=document.createTextNode(description),paranode=document.createElement("p");paranode.appendChild(textnode);details.appendChild(paranode)}enumAddValues(details,typeName){var listnode=document.createElement("ul");details.appendChild(listnode);// Find the enum elements...
var eex=this.typeManager.getEnum(typeName),elements=eex.elementDefs;elements.forEach(element=>{var ordinal=element.ordinal,value=element.value,description=element.description,itemnode=document.createElement("li"),element=document.createTextNode(ordinal+" : "+value+" : "+description);itemnode.appendChild(element);listnode.appendChild(itemnode)})}//
// UTILITY FUNCTIONS
//
appendEntityLink(itemnode,itemName){var button=document.createElement("button");button.className="linkable";button.innerHTML="Type: "+itemName;itemnode.appendChild(button);button.addEventListener("click",()=>this.entityLinkHandler(itemName))}appendRelationshipLink(itemnode,itemName,inherited){var button=document.createElement("button");button.className="collapsible";if(inherited){button.innerHTML="<i>"+itemName+"</i>"}else{button.innerHTML=itemName}var div=document.createElement("div");div.className="content";this.relationshipAddAttributes(div,itemName);var paranode=document.createElement("p");div.appendChild(paranode);var detailButton=document.createElement("button");detailButton.className="linkable";detailButton.innerHTML="More Details";div.appendChild(detailButton);detailButton.addEventListener("click",()=>this.relationshipLinkHandler(itemName));itemnode.append(button);itemnode.append(div);button.addEventListener("click",function(){this.classList.toggle("active");var content=this.nextElementSibling;if("block"===content.style.display){content.style.display="none"}else{content.style.display="block"}})}appendClassificationLink(itemnode,itemName,inherited){var button=document.createElement("button");button.className="collapsible";if(inherited){button.innerHTML="<i>"+itemName+"</i>"}else{button.innerHTML=itemName}var div=document.createElement("div");div.className="content";this.classificationAddAttributes(div,itemName);var paranode=document.createElement("p");div.appendChild(paranode);var detailButton=document.createElement("button");detailButton.className="linkable";detailButton.innerHTML="More Details";div.appendChild(detailButton);detailButton.addEventListener("click",()=>this.classificationLinkHandler(itemName));itemnode.append(button);itemnode.append(div);button.addEventListener("click",function(){this.classList.toggle("active");var content=this.nextElementSibling;if("block"===content.style.display){content.style.display="none"}else{content.style.display="block"}})}appendEnumLink(itemnode,itemName){var button=document.createElement("button");button.className="linkable";button.innerHTML=itemName;itemnode.appendChild(button);button.addEventListener("click",()=>this.enumLinkHandler(itemName))}entityLinkHandler(typeName){// Generate the outbound change focus event...
this.outEvtChangeFocus(typeName)}relationshipLinkHandler(typeName){// Generate the outbound change view event...
this.outEvtChangeView("Relationship",typeName)}classificationLinkHandler(typeName){// Generate the outbound change view event...
this.outEvtChangeView("Classification",typeName)}enumLinkHandler(typeName){// Generate the outbound change view event...
this.outEvtChangeView("Enum",typeName)}/*
     *  Outbound event: change-focus
     */outEvtChangeFocus(typeName){var customEvent=new CustomEvent("change-focus",{bubbles:!0,composed:!0,detail:{source:"details-panel",focusType:typeName}});this.dispatchEvent(customEvent)}/*
     *  Outbound event: change-focus
     */outEvtChangeView(cat,typeName){var customEvent=new CustomEvent("change-view",{bubbles:!0,composed:!0,detail:{source:"details-panel",viewCategory:cat,viewType:typeName}});this.dispatchEvent(customEvent)}}window.customElements.define("details-panel",DetailsPanel)});