/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.lineage;

import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.governanceservers.openlineage.converters.ScopeEnumConverter;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.OpenLineageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lineage"})
public class OpenLineageController {
    @Autowired
    private OpenLineageService openLineageService;

    @GetMapping(value={"/entities/{guid}/ultimate-source"})
    public Map<String, List> ultimateSourceGraph(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getUltimateSource(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/end2end"})
    @ResponseBody
    public Map<String, List> endToEndLineage(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getEndToEndLineage(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/ultimate-destination"})
    public Map<String, List> ultimateDestination(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getUltimateDestination(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/vertical-lineage"})
    public Map<String, List> verticalLineage(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getVerticalLineage(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/source-and-destination"})
    public Map<String, List> sourceAndDestinationLineage(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Map exportedGraph = this.openLineageService.getSourceAndDestination(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @InitBinder
    public void initBinder(WebDataBinder webdataBinder) {
        webdataBinder.registerCustomEditor(Scope.class, (PropertyEditor)new ScopeEnumConverter());
    }
}

