/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth.ldap;

import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.SecurityConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

@EnableWebSecurity
@Configuration(value="securityConfig")
@Order(value=-2147483648)
@ConditionalOnProperty(value={"authentication.source"}, havingValue="ldap", matchIfMissing=true)
class LdapSecurityConfig
extends SecurityConfig {
    @Value(value="${ldap.user.search.base}")
    private String userSearchBase;
    @Value(value="${ldap.user.search.filter}")
    private String userSearchFilter;
    @Value(value="${ldap.group.search.base}")
    private String groupSearchBase;
    @Value(value="${ldap.group.search.filter}")
    private String groupSearchFilter;
    @Value(value="${ldap.url}")
    private String ldapURL;
    @Value(value="${ldap.user.dn.patterns}")
    private String userDnPatterns;
    @Value(value="${ldap.npa.dn}")
    private String npaDn;
    @Value(value="${ldap.npa.password}")
    private String npaPassword;
    @Value(value="${ldap.group.role.attribute}")
    private String roleAttribute;

    LdapSecurityConfig() {
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.ldapAuthentication().userDetailsContextMapper((UserDetailsContextMapper)this.userContextMapper()).groupSearchBase(this.groupSearchBase).groupSearchFilter(this.groupSearchFilter).userSearchBase(this.userSearchBase).userSearchFilter(this.userSearchFilter).groupRoleAttribute(this.roleAttribute).rolePrefix("").contextSource().url(this.ldapURL).managerDn(this.npaDn).managerPassword(this.npaPassword).and().userDnPatterns(new String[]{this.userDnPatterns});
    }
}

