define(["exports","../../../@polymer/polymer/polymer-element.js","../../../@polymer/polymer/lib/mixins/gesture-event-listeners.js","../../vaadin-themable-mixin/vaadin-themable-mixin.js","../../vaadin-control-state-mixin/vaadin-control-state-mixin.js","../../vaadin-element-mixin/vaadin-element-mixin.js","../../../@polymer/polymer/lib/utils/html-tag.js"],function(_exports,_polymerElement,_gestureEventListeners,_vaadinThemableMixin,_vaadinControlStateMixin,_vaadinElementMixin,_htmlTag){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
});_exports.CheckboxElement=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * `<vaadin-checkbox>` is a Web Component for customized checkboxes.
 *
 * ```html
 * <vaadin-checkbox>
 *   Make my profile visible
 * </vaadin-checkbox>
 * ```
 *
 * ### Styling
 *
 * The following shadow DOM parts are available for styling:
 *
 * Part name         | Description
 * ------------------|----------------
 * `checkbox`        | The wrapper element for the native <input type="checkbox">
 * `label`           | The wrapper element in which the component's children, namely the label, is slotted
 *
 * The following state attributes are available for styling:
 *
 * Attribute    | Description | Part name
 * -------------|-------------|--------------
 * `active`     | Set when the checkbox is pressed down, either with mouse, touch or the keyboard. | `:host`
 * `disabled`   | Set when the checkbox is disabled. | `:host`
 * `focus-ring` | Set when the checkbox is focused using the keyboard. | `:host`
 * `focused`    | Set when the checkbox is focused. | `:host`
 * `indeterminate` | Set when the checkbox is in indeterminate mode. | `:host`
 * `checked` | Set when the checkbox is checked. | `:host`
 * `empty` | Set when there is no label provided. | `label`
 *
 * See [ThemableMixin – how to apply styles for shadow parts](https://github.com/vaadin/vaadin-themable-mixin/wiki)
 *
 * @extends PolymerElement
 * @mixes ElementMixin
 * @mixes ControlStateMixin
 * @mixes ThemableMixin
 * @mixes GestureEventListeners
 * @demo demo/index.html
 */class CheckboxElement extends(0,_vaadinElementMixin.ElementMixin)((0,_vaadinControlStateMixin.ControlStateMixin)((0,_vaadinThemableMixin.ThemableMixin)((0,_gestureEventListeners.GestureEventListeners)(_polymerElement.PolymerElement)))){static get template(){return _htmlTag.html`
    <style>
      :host {
        display: inline-block;
      }

      :host([hidden]) {
        display: none !important;
      }

      label {
        display: inline-flex;
        align-items: baseline;
        outline: none;
      }

      [part="checkbox"] {
        position: relative;
        display: inline-block;
        flex: none;
      }

      input[type="checkbox"] {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        cursor: inherit;
        margin: 0;
      }

      :host([disabled]) {
        -webkit-tap-highlight-color: transparent;
      }
    </style>

    <label>
      <span part="checkbox">
        <input type="checkbox" checked="{{checked::change}}" disabled\$="[[disabled]]" indeterminate="{{indeterminate::change}}" role="presentation" tabindex="-1">
      </span>

      <span part="label">
        <slot></slot>
      </span>
    </label>
`}static get is(){return"vaadin-checkbox"}static get version(){return"2.5.0"}static get properties(){return{/**
       * True if the checkbox is checked.
       * @type {boolean}
       */checked:{type:Boolean,value:/* ignoreName */!1/* skipSlots */ /* skipSlots */,notify:!0,observer:"_checkedChanged",reflectToAttribute:!0},/**
       * Indeterminate state of the checkbox when it's neither checked nor unchecked, but undetermined.
       * https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/checkbox#Indeterminate_state_checkboxes
       * @type {boolean}
       */indeterminate:{type:Boolean,notify:!0,observer:"_indeterminateChanged",reflectToAttribute:!0,value:!1},/**
       * The value given to the data submitted with the checkbox's name to the server when the control is inside a form.
       */value:{type:String,value:"on"},/** @private */_nativeCheckbox:{type:Object}}}constructor(){super();/**
     * @type {string}
     * Name of the element.
     */this.name}get name(){return this.checked?this._storedName:""}set name(name){this._storedName=name}ready(){super.ready();this.setAttribute("role","checkbox");this._nativeCheckbox=this.shadowRoot.querySelector("input[type=\"checkbox\"]");this.addEventListener("click",this._handleClick.bind(this));this._addActiveListeners();const attrName=this.getAttribute("name");if(attrName){this.name=attrName}this.shadowRoot.querySelector("[part~=\"label\"]").querySelector("slot").addEventListener("slotchange",this._updateLabelAttribute.bind(this));this._updateLabelAttribute()}/** @private */_updateLabelAttribute(){const label=this.shadowRoot.querySelector("[part~=\"label\"]"),assignedNodes=label.firstElementChild.assignedNodes();if(this._isAssignedNodesEmpty(assignedNodes)){label.setAttribute("empty","")}else{label.removeAttribute("empty")}}/** @private */_isAssignedNodesEmpty(nodes){// The assigned nodes considered to be empty if there is no slotted content or only one empty text node
return 0===nodes.length||1==nodes.length&&nodes[0].nodeType==Node.TEXT_NODE&&""===nodes[0].textContent.trim()}/** @private */_checkedChanged(checked){if(this.indeterminate){this.setAttribute("aria-checked","mixed")}else{this.setAttribute("aria-checked",!!checked)}}/** @private */_indeterminateChanged(indeterminate){if(indeterminate){this.setAttribute("aria-checked","mixed")}else{this.setAttribute("aria-checked",this.checked)}}/** @private */_addActiveListeners(){// DOWN
this._addEventListenerToNode(this,"down",e=>{if(this.__interactionsAllowed(e)){this.setAttribute("active","")}});// UP
this._addEventListenerToNode(this,"up",()=>this.removeAttribute("active"));// KEYDOWN
this.addEventListener("keydown",e=>{if(this.__interactionsAllowed(e)&&32===e.keyCode){e.preventDefault();this.setAttribute("active","")}});// KEYUP
this.addEventListener("keyup",e=>{if(this.__interactionsAllowed(e)&&32===e.keyCode){e.preventDefault();this._toggleChecked();this.removeAttribute("active");if(this.indeterminate){this.indeterminate=!1}}})}/**
   * @return {!HTMLInputElement}
   * @protected
   */get focusElement(){return this.shadowRoot.querySelector("input")}/**
   * True if users' interactions (mouse or keyboard)
   * should toggle the checkbox
   */__interactionsAllowed(e){if(this.disabled){return!1}// https://github.com/vaadin/vaadin-checkbox/issues/63
if("a"===e.target.localName){return!1}return!0}/** @private */_handleClick(e){if(this.__interactionsAllowed(e)){if(!this.indeterminate){if(e.composedPath()[0]!==this._nativeCheckbox){e.preventDefault();this._toggleChecked()}}else{/*
         * Required for IE 11 and Edge.
         * See issue here: https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/7344418/
         */this.indeterminate=!1;e.preventDefault();this._toggleChecked()}}}/** @protected */_toggleChecked(){this.checked=!this.checked;this.dispatchEvent(new CustomEvent("change",{composed:!1,bubbles:!0}))}/**
   * Fired when the user commits a value change.
   *
   * @event change
   */}_exports.CheckboxElement=CheckboxElement;customElements.define(CheckboxElement.is,CheckboxElement)});