define(["exports","./vaadin-combo-box-placeholder.js"],function(_exports,_vaadinComboBoxPlaceholder){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
});_exports.ComboBoxDataProviderMixin=void 0;/**
@license
Copyright (c) 2018 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * @polymerMixin
 */const ComboBoxDataProviderMixin=superClass=>class DataProviderMixin extends superClass{static get properties(){return{/**
       * Number of items fetched at a time from the dataprovider.
       * @attr {number} page-size
       * @type {number}
       */pageSize:{type:Number,value:50,observer:"_pageSizeChanged"},/**
       * Total number of items.
       * @type {number | undefined}
       */size:{type:Number,observer:"_sizeChanged"},/**
       * Function that provides items lazily. Receives arguments `params`, `callback`
       *
       * `params.page` Requested page index
       *
       * `params.pageSize` Current page size
       *
       * `params.filter` Currently applied filter
       *
       * `callback(items, size)` Callback function with arguments:
       *   - `items` Current page of items
       *   - `size` Total number of items.
       * @type {ComboBoxDataProvider | undefined}
       */dataProvider:{type:Object,observer:"_dataProviderChanged"},/** @private */_pendingRequests:{value:()=>{return{}}},/** @private */__placeHolder:{value:new _vaadinComboBoxPlaceholder.ComboBoxPlaceholder}}}static get observers(){return["_dataProviderFilterChanged(filter, dataProvider)","_dataProviderClearFilter(dataProvider, opened, value)","_warnDataProviderValue(dataProvider, value)","_ensureFirstPage(opened)"]}/** @private */_dataProviderClearFilter(dataProvider,opened,value){// Can't depend on filter in this observer as we don't want
// to clear the filter whenever it's set
if(dataProvider&&this.filter){this.size=void 0;this._pendingRequests={};this.filter="";this.clearCache()}}/** @protected */ready(){super.ready();this.clearCache();this.$.overlay.addEventListener("index-requested",e=>{const index=e.detail.index;if(index!==void 0){const page=this._getPageForIndex(index);if(this._shouldLoadPage(page)){this._loadPage(page)}}})}/** @private */_dataProviderFilterChanged(){if(this.dataProvider&&this.opened){this.size=void 0;this._pendingRequests={};this.clearCache()}}/** @private */_ensureFirstPage(opened){if(opened&&this._shouldLoadPage(0)){this._loadPage(0)}}/** @private */_shouldLoadPage(page){if(!this.filteredItems||this._forceNextRequest){this._forceNextRequest=/* ignoreName */!1/* skipSlots */ /* skipSlots */;return!0}const loadedItem=this.filteredItems[page*this.pageSize];if(loadedItem!==void 0){return loadedItem instanceof _vaadinComboBoxPlaceholder.ComboBoxPlaceholder}else{return this.size===void 0}}/** @private */_loadPage(page){// make sure same page isn't requested multiple times.
if(!this._pendingRequests[page]&&this.dataProvider){this.loading=!0;const params={page,pageSize:this.pageSize,filter:this.filter},callback=(items,size)=>{if(this._pendingRequests[page]===callback){if(!this.filteredItems){const filteredItems=[];filteredItems.splice(params.page*params.pageSize,items.length,...items);this.filteredItems=filteredItems}else{this.splice("filteredItems",params.page*params.pageSize,items.length,...items)}// Update selectedItem from filteredItems if value is set
if(this._isValidValue(this.value)&&this._getItemValue(this.selectedItem)!==this.value){this._selectItemForValue(this.value)}this.size=size;delete this._pendingRequests[page];if(0===Object.keys(this._pendingRequests).length){this.loading=!1}if(0===page&&this.__repositionOverlayDebouncer&&items.length>(this.__maxRenderedItems||0)){setTimeout(()=>this.__repositionOverlayDebouncer.flush());this.__maxRenderedItems=items.length}}};this._pendingRequests[page]=callback;this.dataProvider(params,callback)}}/** @private */_getPageForIndex(index){return Math.floor(index/this.pageSize)}/**
   * Clears the cached pages and reloads data from dataprovider when needed.
   */clearCache(){if(!this.dataProvider){return}this._pendingRequests={};const filteredItems=[];for(let i=0;i<(this.size||0);i++){filteredItems.push(this.__placeHolder)}this.filteredItems=filteredItems;if(this.opened){this._loadPage(0)}else{this._forceNextRequest=!0}}/** @private */_sizeChanged(size=0){const filteredItems=(this.filteredItems||[]).slice(0,size);for(let i=0;i<size;i++){filteredItems[i]=filteredItems[i]!==void 0?filteredItems[i]:this.__placeHolder}this.filteredItems=filteredItems}/** @private */_pageSizeChanged(pageSize,oldPageSize){if(Math.floor(pageSize)!==pageSize||1>pageSize){this.pageSize=oldPageSize;throw new Error("`pageSize` value must be an integer > 0")}this.clearCache()}/** @private */_dataProviderChanged(dataProvider,oldDataProvider){this._ensureItemsOrDataProvider(()=>{this.dataProvider=oldDataProvider})}/** @private */_ensureItemsOrDataProvider(restoreOldValueCallback){if(this.items!==void 0&&this.dataProvider!==void 0){restoreOldValueCallback();throw new Error("Using `items` and `dataProvider` together is not supported")}else if(this.dataProvider&&!this.filteredItems){this.filteredItems=[]}}/** @private */_warnDataProviderValue(dataProvider,value){if(dataProvider&&""!==value&&(this.selectedItem===void 0||null===this.selectedItem)){const valueIndex=this._indexOfValue(value,this.filteredItems);if(0>valueIndex||!this._getItemLabel(this.filteredItems[valueIndex])){/* eslint-disable no-console */console.warn("Warning: unable to determine the label for the provided `value`. "+"Nothing to display in the text field. This usually happens when "+"setting an initial `value` before any items are returned from "+"the `dataProvider` callback. Consider setting `selectedItem` "+"instead of `value`");/* eslint-enable no-console */}}}};_exports.ComboBoxDataProviderMixin=ComboBoxDataProviderMixin});