define(["exports","../../../@polymer/polymer/lib/utils/render-status.js","../../../@polymer/polymer/lib/utils/async.js","../../../@polymer/polymer/lib/utils/flush.js","./iron-list.js","../../../@polymer/polymer/lib/utils/debounce.js"],function(_exports,_renderStatus,_async,_flush,_ironList,_debounce){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
});_exports.ScrollerElement=void 0;/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * This Element is used internally by vaadin-grid.
 *
 * @implements PolymerIronList
 * @extends HTMLElement
 */class GridScrollerElement extends _ironList.PolymerIronList{static get is(){return"vaadin-grid-scroller"}static get properties(){return{size:{type:Number,notify:!0},/**
       * @type {number}
       * @protected
       */_vidxOffset:{value:0}}}static get observers(){return["_effectiveSizeChanged(_effectiveSize)"]}/** @protected */connectedCallback(){super.connectedCallback();this._scrollHandler()}/**
   * @param {!HTMLTableRowElement} item
   * @param {number} index
   * @protected
   */_updateScrollerItem(item,index){}/** @protected */_afterScroll(){}/** @protected */_getRowTarget(){}/** @protected */_createScrollerRows(){}/** @protected */_canPopulate(){}/**
   * @param {number} index
   * @protected
   */scrollToIndex(index){this._warnPrivateAPIAccess("scrollToIndex");this._scrollingToIndex=!0;index=Math.min(Math.max(index,0),this._effectiveSize-1);this.$.table.scrollTop=index/this._effectiveSize*(this.$.table.scrollHeight-this.$.table.offsetHeight);this._scrollHandler();if(this._accessIronListAPI(()=>this._maxScrollTop)&&this._virtualCount<this._effectiveSize){this._adjustVirtualIndexOffset(1e6)}this._accessIronListAPI(()=>super.scrollToIndex(index-this._vidxOffset));this._scrollHandler();// Ensure scroll position
const row=Array.from(this.$.items.children).filter(child=>child.index===index)[0];if(row){const headerOffset=row.getBoundingClientRect().top-this.$.header.getBoundingClientRect().bottom;if(1<Math.abs(headerOffset)){this.$.table.scrollTop+=headerOffset;this._scrollHandler()}}this._scrollingToIndex=/* ignoreName */!1/* skipSlots */ /* skipSlots */}/** @private */_effectiveSizeChanged(size){let fvi,fviOffset=0;// first visible (adjusted) index
this._iterateItems((pidx,vidx)=>{if(vidx===this._firstVisibleIndex){const row=this._physicalItems[pidx];fvi=row.index;fviOffset=row.getBoundingClientRect().top}});if(this.items&&size<this.items.length){// Size was reduced, scroll to 0 first
this._scrollTop=0}if(!Array.isArray(this.items)){// Edge/IE seems to have the lowest maximum
const maxVirtualItems=this._edge||this._ie?3e4:1e5;this.items={length:Math.min(size,maxVirtualItems)}}this._accessIronListAPI(()=>super._itemsChanged({path:"items"}));this._virtualCount=Math.min(this.items.length,size)||0;if(0===this._scrollTop){this._accessIronListAPI(()=>this._scrollToIndex(Math.min(size-1,fvi)));this._iterateItems((pidx,vidx)=>{const row=this._physicalItems[pidx];if(row.index===fvi){this.$.table.scrollTop+=Math.round(row.getBoundingClientRect().top-fviOffset)}// Restore keyboard focus to the right cell
if(row.index===this._focusedItemIndex&&this._itemsFocusable&&this.$.items.contains(this.shadowRoot.activeElement)){const cellIndex=Array.from(this._itemsFocusable.parentElement.children).indexOf(this._itemsFocusable);row.children[cellIndex].focus()}})}this._assignModels();requestAnimationFrame(()=>this._update());this.__updateFooterPositioning();if(this._ie){// Workaround an IE flexbox bug where the rows would horizontally collapse
// whenever item count change toggles the scrollbar visibility (is tested)
this.$.table.style.display="block";setTimeout(()=>{this.$.table.style.display="flex";this._translateStationaryElements()})}}/** @protected */_positionItems(){this._adjustScrollPosition();let rePosition;if(isNaN(this._physicalTop)){rePosition=!0;this._physicalTop=0}let y=this._physicalTop;this._iterateItems((pidx,vidx)=>{this._physicalItems[pidx].style.transform=`translateY(${y}px)`;y+=this._physicalSizes[pidx]});if(rePosition){this._scrollToIndex(0)}}/**
   * @param {number} count
   * @protected
   */_increasePoolIfNeeded(count){if(0===count&&this._scrollingToIndex||!this._canPopulate()||!this._effectiveSize){return}if(!this._initialPoolCreated){this._initialPoolCreated=!0;super._increasePoolIfNeeded(25)}else if(this._optPhysicalSize!==1/0){this._debounceIncreasePool=_debounce.Debouncer.debounce(this._debounceIncreasePool,_async.animationFrame,()=>{this._updateMetrics();const remainingPhysicalSize=this._optPhysicalSize-this._physicalSize;let estimatedMissingRowCount=Math.ceil(remainingPhysicalSize/this._physicalAverage);if(this._physicalCount+estimatedMissingRowCount>this._effectiveSize){// Do not increase the physical item count above the this._effectiveSize
estimatedMissingRowCount=Math.max(0,this._effectiveSize-this._physicalCount)}if(this._physicalSize&&0<estimatedMissingRowCount&&this._optPhysicalSize!==1/0){super._increasePoolIfNeeded(estimatedMissingRowCount);// Ensure the rows are in order after increasing pool
this.__reorderChildNodes()}})}}/** @private */__reorderChildNodes(){const childNodes=Array.from(this.$.items.childNodes),rowsInOrder=!!childNodes.reduce((inOrder,current,currentIndex,array)=>{if(0===currentIndex||array[currentIndex-1].index===current.index-1){return inOrder}},!0);if(!rowsInOrder){childNodes.sort((row1,row2)=>{return row1.index-row2.index}).forEach(row=>this.$.items.appendChild(row))}}/** @private */_createPool(size){const fragment=document.createDocumentFragment(),physicalItems=this._createScrollerRows(size);physicalItems.forEach(inst=>fragment.appendChild(inst));this._getRowTarget().appendChild(fragment);// Weird hack needed to get Safari to actually distribute slots
const content=this.querySelector("[slot]");if(content){const slot=content.getAttribute("slot");content.setAttribute("slot","foo-bar");content.setAttribute("slot",slot)}(0,_renderStatus.afterNextRender)(this,()=>this.notifyResize());return physicalItems}/**
   * Assigns the data models to a given set of items.
   * @param {!Array<number>=} itemSet
   * @protected
   */_assignModels(itemSet){this._iterateItems((pidx,vidx)=>{const el=this._physicalItems[pidx];this._toggleAttribute("hidden",vidx>=this._effectiveSize,el);this._updateScrollerItem(el,vidx+(this._vidxOffset||0))},itemSet)}/** @protected */_scrollHandler(){const delta=this.$.table.scrollTop-this._scrollPosition;this._accessIronListAPI(super._scrollHandler);const oldOffset=this._vidxOffset;if(this._accessIronListAPI(()=>this._maxScrollTop)&&this._virtualCount<this._effectiveSize){this._adjustVirtualIndexOffset(delta)}else{this._vidxOffset=0}if(this._vidxOffset!==oldOffset){this._update()}this._afterScroll()}/** @private */_adjustVirtualIndexOffset(delta){if(1e4<Math.abs(delta)){if(this._noScale){this._noScale=!1;return}const scale=this.$.table.scrollTop/(this.$.table.scrollHeight-this.$.table.offsetHeight),offset=scale*this._effectiveSize;this._vidxOffset=Math.round(offset-scale*this._virtualCount)}else{// Make sure user can always swipe/wheel scroll to the start and end
const oldOffset=this._vidxOffset||0,threshold=1e3,maxShift=100;// At start
if(0===this._scrollTop){this._vidxOffset=0;if(oldOffset!==this._vidxOffset){super.scrollToIndex(0)}}else if(this.firstVisibleIndex<threshold&&0<this._vidxOffset){this._vidxOffset-=Math.min(this._vidxOffset,maxShift);if(oldOffset!==this._vidxOffset){super.scrollToIndex(this.firstVisibleIndex+(oldOffset-this._vidxOffset))}this._noScale=!0}// At end
const maxOffset=this._effectiveSize-this._virtualCount;if(this._scrollTop>=this._maxScrollTop&&0<this._maxScrollTop){this._vidxOffset=maxOffset;if(oldOffset!==this._vidxOffset){super.scrollToIndex(this._virtualCount)}}else if(this.firstVisibleIndex>this._virtualCount-threshold&&this._vidxOffset<maxOffset){this._vidxOffset+=Math.min(maxOffset-this._vidxOffset,maxShift);if(oldOffset!==this._vidxOffset){super.scrollToIndex(this.firstVisibleIndex-(this._vidxOffset-oldOffset))}this._noScale=!0}}}/** @private */_accessIronListAPI(cb){this._warnPrivateAPIAccessAsyncEnabled=!1;const returnValue=cb.apply(this);this._debouncerWarnPrivateAPIAccess=_debounce.Debouncer.debounce(this._debouncerWarnPrivateAPIAccess,_async.animationFrame,()=>this._warnPrivateAPIAccessAsyncEnabled=!0);return returnValue}/**
   * Allow iron-list to access its APIs from debounced callbacks without warns
   * @private
   */_debounceRender(cb,asyncModule){super._debounceRender(()=>this._accessIronListAPI(cb),asyncModule)}/**
   * Warn when iron-list APIs are being accessed directly
   * @private
   */_warnPrivateAPIAccess(apiName){if(this._warnPrivateAPIAccessAsyncEnabled){console.warn(`Accessing private API (${apiName})!`)}}/** @protected */_render(){this._accessIronListAPI(super._render)}/** @private */_createFocusBackfillItem(){}/* Ignore */ /** @private */_multiSelectionChanged(){}/* Ignore */ /** @private */clearSelection(){}/* Ignore */ /** @protected */_itemsChanged(){}/* Ignore */ /** @private */_manageFocus(){}/* Ignore */ /** @private */_removeFocusedItem(){}/* Ignore */ /**
   * @return {number}
   * @protected
   */get _firstVisibleIndex(){return this._accessIronListAPI(()=>super.firstVisibleIndex)}/**
   * @return {number}
   * @protected
   */get _lastVisibleIndex(){return this._accessIronListAPI(()=>super.lastVisibleIndex)}/**
   * @param {number} index
   * @protected
   */_scrollToIndex(index){this._accessIronListAPI(()=>this.scrollToIndex(index))}/** @private */get firstVisibleIndex(){this._warnPrivateAPIAccess("firstVisibleIndex");return super.firstVisibleIndex}/** @private */set firstVisibleIndex(value){this._warnPrivateAPIAccess("firstVisibleIndex");super.firstVisibleIndex=value}/** @private */get lastVisibleIndex(){this._warnPrivateAPIAccess("lastVisibleIndex");return super.lastVisibleIndex}/** @private */set lastVisibleIndex(value){this._warnPrivateAPIAccess("lastVisibleIndex");super.lastVisibleIndex=value}/** @private */updateViewportBoundaries(){this._warnPrivateAPIAccess("updateViewportBoundaries");super.updateViewportBoundaries.apply(this,arguments)}/** @protected */_resizeHandler(){super._resizeHandler();(0,_flush.flush)()}}_exports.ScrollerElement=GridScrollerElement;customElements.define(GridScrollerElement.is,GridScrollerElement)});