define(["exports","./vaadin-grid-column.js","./vaadin-grid-sorter.js","../../../@polymer/polymer/lib/utils/html-tag.js"],function(_exports,_vaadinGridColumn,_vaadinGridSorter,_htmlTag){"use strict";Object.defineProperty(_exports,"__esModule",{value:// unflatten -> {"es": {"hi": "hola"}}
!0/* ignoreName */ /* skipSlots */ // merge so existing resources won't be clobbered
});_exports.GridSortColumnElement=void 0;/**
@license
Copyright (c) 2018 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/ /**
 * `<vaadin-grid-sort-column>` is a helper element for the `<vaadin-grid>`
 * that provides default header template and functionality for sorting.
 *
 * #### Example:
 * ```html
 * <vaadin-grid items="[[items]]">
 *  <vaadin-grid-sort-column path="name.first" direction="asc"></vaadin-grid-sort-column>
 *
 *  <vaadin-grid-column>
 *    ...
 * ```
 *
 */class GridSortColumnElement extends _vaadinGridColumn.GridColumnElement{static get template(){return _htmlTag.html`
    <template class="header" id="headerTemplate">
      <vaadin-grid-sorter path="[[path]]" direction="{{direction}}">[[_getHeader(header, path)]]</vaadin-grid-sorter>
    </template>
`}static get is(){return"vaadin-grid-sort-column"}static get properties(){return{/**
       * JS Path of the property in the item used for sorting the data.
       */path:String,/**
       * How to sort the data.
       * Possible values are `asc` to use an ascending algorithm, `desc` to sort the data in
       * descending direction, or `null` for not sorting the data.
       * @type {GridSorterDirection | undefined}
       */direction:{type:String,notify:!0}}}/** @private */_prepareHeaderTemplate(){const headerTemplate=this._prepareTemplatizer(this.$.headerTemplate);// needed to override the dataHost correctly in case internal template is used.
headerTemplate.templatizer.dataHost=this;return headerTemplate}/** @private */_getHeader(header,path){return header||this._generateHeader(path)}}_exports.GridSortColumnElement=GridSortColumnElement;customElements.define(GridSortColumnElement.is,GridSortColumnElement)});