define(["require","../../node_modules/@polymer/polymer/polymer-element.js","../../node_modules/@vaadin/vaadin-tabs/vaadin-tabs.js","../shared-styles.js","./asset-search-view.js"],function(_require,_polymerElement,_vaadinTabs,_sharedStyles,_assetSearchView){"use strict";_require=babelHelpers.interopRequireWildcard(_require);/* SPDX-License-Identifier: Apache-2.0 */ /* Copyright Contributors to the ODPi Egeria project. */class AssetCatalogView extends _polymerElement.PolymerElement{static get template(){return _polymerElement.html`
      <style include="shared-styles">
       :host {
          display: block;
          margin:var(--egeria-view-margin);
          min-height: var(--egeria-view-min-height);
        }
         #useCases {
            color: var(--egeria-primary-color);
            width: fit-content;
            margin: auto;
        }
      </style>
      
      <app-route route="{{route}}" pattern="/:usecase" data="{{routeData}}" tail="{{tail}}"></app-route>
      
      <dom-if if="[[ _tabsVisible(routeData) ]]" > 
        <app-route route="{{tail}}" pattern="/:guid" data="{{routeTailData}}" "></app-route>
        <template> 
            <vaadin-tabs id="useCases" selected="[[ _getUseCase(routeData.usecase) ]]">
              <vaadin-tab value="[[ usecases.0 ]]">
                <a href="[[rootPath]]#/asset-catalog/view/[[routeTailData.guid]]" tabindex="-1" rel="noopener"> 
                    Details
                </a>
              </vaadin-tab>
              <vaadin-tab value="[[ usecases.1 ]]">
                <a href="[[rootPath]]#/asset-catalog/context/[[routeTailData.guid]]" tabindex="-1"  rel="noopener"> 
                    Context
                </a>
              </vaadin-tab>
              
            </vaadin-tabs>
        </template>
      </dom-if>
      
      <iron-pages selected="[[routeData.usecase]]" attr-for-selected="name" role="main" fallback-selection="search">
         <asset-search-view language="[[language]]" name="search" route="{{tail}}"></asset-search-view>
         <asset-details-view language="[[language]]" name="view" route="{{tail}}"></asset-details-view>
         <asset-context-view language="[[language]]" name="context" route="{{tail}}"></asset-context-view>
      </iron-pages>
    `}static get properties(){return{usecases:{type:Array,value:["view","context"]}}}static get observers(){return["_routeChanged(route)"]}_getUseCase(usecase){return this.usecases.indexOf(usecase)}_tabsVisible(routeData){return routeData!==void 0&&routeData.usecase!==void 0&&"search"!==routeData.usecase}_routeChanged(route){if("/asset-catalog"===route.prefix){/**
             * keeping the switch for later add cases
             */switch(this.routeData.usecase){case"view":new Promise((res,rej)=>_require.default(["./asset-details-view.js"],res,rej));break;case"context":new Promise((res,rej)=>_require.default(["./asset-context-view.js"],res,rej));break;}}}}window.customElements.define("asset-view",AssetCatalogView)});