/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.asset;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetElements;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Type;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.AssetCatalogOMASService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/assets"})
public class AssetController {
    @Autowired
    AssetCatalogOMASService assetCatalogOMASService;

    @GetMapping(path={"/search"})
    public List<AssetElements> searchAssets(@RequestParam(value="q") String searchCriteria, @RequestParam(value="types") List<String> types, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="10") Integer pageSize) throws PropertyServerException, InvalidParameterException {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        SearchParameters searchParameters = new SearchParameters();
        if (CollectionUtils.isNotEmpty(types)) {
            searchParameters.setEntityTypes(types);
        }
        searchParameters.setPageSize(pageSize);
        searchParameters.setFrom(from);
        return this.assetCatalogOMASService.searchAssets(user, searchCriteria, searchParameters);
    }

    @GetMapping(path={"/types"})
    public List<Type> getSupportedTypes() throws PropertyServerException, InvalidParameterException {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.assetCatalogOMASService.getSupportedTypes(user);
    }

    @GetMapping(value={"/{guid}"})
    public AssetDescription getAsset(@PathVariable(value="guid") String guid) throws PropertyServerException, InvalidParameterException {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.assetCatalogOMASService.getAssetDetails(user, guid, "none");
    }

    @GetMapping(value={"/{guid}/context"})
    public AssetElements getAssetContext(@PathVariable(value="guid") String guid) throws PropertyServerException, InvalidParameterException {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.assetCatalogOMASService.getAssetContext(user, guid, "none");
    }
}

