/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum RexErrorCode implements ExceptionMessageSet
{
    NO_GUID(400, "REX-400-001", "A null unique identifier (guid) has been passed as the {0} parameter on a {1} request to open metadata repository {2}", "The system is unable to perform the request because the unique identifier is needed.", "Correct the caller's code and retry the request."),
    INVALID_VALUE(400, "REX-400-002", "An invalid value has been passed as the {0} parameter on a {1} request to open metadata repository {2}", "The system is unable to perform the request using the value provided.", "Correct the caller's code and retry the request."),
    ENTITY_NOT_KNOWN(400, "REX-400-003", "The entity identified with guid {0} passed on the {1} call is not known to the open metadata repository {2}", "\"The system is unable to retrieve the properties for the requested entity because the supplied guid is not recognized.", "The guid is supplied by the caller to the server.  It may have a logic problem that has corrupted the guid, or the entity has been deleted since the guid was retrieved."),
    RELATIONSHIP_NOT_KNOWN(400, "REX-400-004", "The relationship identified with guid {0} passed on the {1} call is not known to the open metadata repository {2}", "\"The system is unable to retrieve the properties for the requested relationship because the supplied guid is not recognized.", "The guid is supplied by the caller to the server.  It may have a logic problem that has corrupted the guid, or the relationship has been deleted since the guid was retrieved."),
    TROUBLE_AT_MILL(400, "REX-400-005", "Apparently, one on't cross beams gone ow't askew on't treddle on repository {2}", "The system is unable to perform the request because none expects the Spanish Inquisition!", "Correct the caller's code and retry the request.");

    private ExceptionMessageDefinition messageDefinition;

    private RexErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "OMRSErrorCode{messageDefinition=" + this.messageDefinition + '}';
    }
}

