/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.List;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Rule;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Service;

@Service
@ConfigurationProperties(prefix="lineage-display-config")
public class LineageGraphDisplayRulesService {
    private List<Rule> rules;

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public void applyRules(Graph graph) {
        List edges = graph.getEdges();
        List nodes = graph.getNodes();
        if (this.rules == null || this.rules.isEmpty()) {
            return;
        }
        for (Edge edge : edges) {
            for (Rule rule : this.rules) {
                if (rule.getEdgeType() == null || !rule.getEdgeType().equals(edge.getLabel())) continue;
                this.applyRule(nodes, edge, rule);
            }
        }
    }

    private void applyRule(List<Node> nodes, Edge edge, Rule rule) {
        if (rule.getSourceNodeType() != null && rule.getDestinationNodeType() != null) {
            this.applyRuleWithBothNodeTypes(nodes, edge, rule);
        } else if (rule.getSourceNodeType() != null && rule.getDestinationNodeType() == null) {
            this.applyRuleWithOneNodeType(nodes, edge, edge.getFrom(), rule.getSourceNodeType());
        } else if (rule.getSourceNodeType() == null && rule.getDestinationNodeType() != null) {
            this.applyRuleWithOneNodeType(nodes, edge, edge.getTo(), rule.getDestinationNodeType());
        } else {
            this.invertEdgeDirection(edge);
        }
    }

    private void applyRuleWithBothNodeTypes(List<Node> nodes, Edge edge, Rule rule) {
        boolean findSource = false;
        boolean findDestination = false;
        for (Node node : nodes) {
            if (node.getId().equals(edge.getFrom()) && node.getGroup().equals(rule.getSourceNodeType())) {
                findSource = true;
            }
            if (node.getId().equals(edge.getTo()) && node.getGroup().equals(rule.getDestinationNodeType())) {
                findDestination = true;
            }
            if (!findSource || !findDestination) continue;
            this.invertEdgeDirection(edge);
        }
    }

    private void applyRuleWithOneNodeType(List<Node> nodes, Edge edge, String nodeId, String ruleNodeType) {
        boolean findNode = false;
        for (Node node : nodes) {
            if (node.getId().equals(nodeId) && node.getGroup().equals(ruleNodeType)) {
                findNode = true;
            }
            if (!findNode) continue;
            this.invertEdgeDirection(edge);
        }
    }

    private void invertEdgeDirection(Edge edge) {
        String originalFrom = edge.getFrom();
        String originalTo = edge.getTo();
        edge.setFrom(originalTo);
        edge.setTo(originalFrom);
    }

    public String toString() {
        return "LineageGraphDisplayRulesService{rules=" + this.rules + '}';
    }
}

